/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.compress;

import com.starrocks.data.load.stream.compress.CompressionCodec;
import com.starrocks.data.load.stream.compress.CompressionOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameOutputStream;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public class LZ4FrameCompressionCodec
implements CompressionCodec {
    public static final String NAME = "LZ4_FRAME";
    private final LZ4FrameOutputStream.BLOCKSIZE blockSize;
    private final LZ4Compressor compressor;
    private final XXHash32 hash;

    public LZ4FrameCompressionCodec(LZ4FrameOutputStream.BLOCKSIZE blockSize) {
        this.blockSize = blockSize;
        this.compressor = LZ4Factory.fastestInstance().fastCompressor();
        this.hash = XXHashFactory.fastestInstance().hash32();
    }

    @Override
    public OutputStream createCompressionStream(OutputStream rawOutputStream, long contentSize) throws IOException {
        return contentSize < 0L ? new LZ4FrameOutputStream(rawOutputStream, this.blockSize, -1L, this.compressor, this.hash, LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE) : new LZ4FrameOutputStream(rawOutputStream, this.blockSize, contentSize, this.compressor, this.hash, LZ4FrameOutputStream.FLG.Bits.CONTENT_SIZE, LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE);
    }

    LZ4FrameOutputStream.BLOCKSIZE getBlockSize() {
        return this.blockSize;
    }

    public static LZ4FrameCompressionCodec create(Map<String, Object> properties) {
        LZ4FrameOutputStream.BLOCKSIZE blockSize = (LZ4FrameOutputStream.BLOCKSIZE)((Object)properties.getOrDefault("compression.lz4.block.size", (Object)CompressionOptions.DEFAULT_LZ4_BLOCK_SIZE));
        return new LZ4FrameCompressionCodec(blockSize);
    }
}

