/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.exception;

import com.starrocks.data.load.stream.StreamLoadResponse;
import com.starrocks.data.load.stream.exception.StreamLoadFailException;
import java.util.Arrays;
import java.util.List;

public class ErrorUtils {
    private static final List<String> UNRETRYABLE_FAIL_MESSAGE_KEY_WORDS = Arrays.asList("too many filtered rows".toLowerCase(), "primary key size exceed the limit".toLowerCase(), "Only primary key table support partial update".toLowerCase(), "Access denied".toLowerCase(), "current running txns on db".toLowerCase());

    public static boolean isRetryable(Throwable e) {
        if (!(e instanceof StreamLoadFailException)) {
            return true;
        }
        StreamLoadFailException exception = (StreamLoadFailException)e;
        StreamLoadResponse.StreamLoadResponseBody responseBody = exception.getResponseBody();
        if (responseBody == null) {
            return true;
        }
        if (!"Fail".equalsIgnoreCase(responseBody.getStatus()) && !"INTERNAL_ERROR".equalsIgnoreCase(responseBody.getStatus())) {
            return false;
        }
        String failMsg = responseBody.getMessage();
        if (failMsg == null) {
            return true;
        }
        failMsg = failMsg.toLowerCase();
        for (String keyword : UNRETRYABLE_FAIL_MESSAGE_KEY_WORDS) {
            if (!failMsg.contains(keyword)) continue;
            return false;
        }
        return true;
    }
}

