/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.io;

import com.starrocks.data.load.stream.StreamLoadDataFormat;
import com.starrocks.data.load.stream.TableRegion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class StreamLoadStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final TableRegion region;
    private final StreamLoadDataFormat dataFormat;
    private ByteBuffer buffer;
    private byte[] cache;
    private int pos;
    private boolean endStream = false;
    private static final int DATA_FIRST = 1;
    private static final int DATA_BODY = 2;
    private static final int DATA_END = 3;
    private int state = 1;
    private byte[] next;
    private boolean first = true;

    public StreamLoadStream(TableRegion region, StreamLoadDataFormat dataFormat) {
        this.region = region;
        this.dataFormat = dataFormat;
        this.buffer = ByteBuffer.allocate(2048);
        this.buffer.position(this.buffer.capacity());
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int ws = this.read(bytes);
        if (ws == -1) {
            return -1;
        }
        return bytes[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!this.buffer.hasRemaining()) {
            if (this.cache == null && this.endStream) {
                return -1;
            }
            this.fillBuffer();
        }
        int size = len - off;
        int ws = Math.min(size, this.buffer.remaining());
        this.buffer.get(b, off, ws);
        return ws;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        this.cache = null;
        this.pos = 0;
        this.endStream = true;
    }

    private void fillBuffer() {
        byte[] bytes;
        this.buffer.clear();
        if (this.cache != null) {
            this.writeBuffer(this.cache, this.pos);
        }
        if (this.endStream || !this.buffer.hasRemaining()) {
            this.buffer.flip();
            return;
        }
        while ((bytes = this.readRegion()) != null) {
            this.writeBuffer(bytes, 0);
            bytes = null;
            if (this.buffer.hasRemaining()) continue;
        }
        if (this.buffer.position() == 0) {
            this.buffer.position(this.buffer.limit());
        } else {
            this.buffer.flip();
        }
    }

    private void writeBuffer(byte[] bytes, int pos) {
        int size = bytes.length - pos;
        int remain = this.buffer.remaining();
        int ws = Math.min(size, remain);
        this.buffer.put(bytes, pos, ws);
        if (size > remain) {
            this.cache = bytes;
            this.pos = pos + ws;
        } else {
            this.cache = null;
            this.pos = 0;
        }
    }

    private byte[] readRegion() {
        switch (this.state) {
            case 1: {
                this.state = 2;
                if (this.dataFormat.first() != null && this.dataFormat.first().length > 0) {
                    return this.dataFormat.first();
                }
                return this.readRegion();
            }
            case 2: {
                if (this.next != null) {
                    byte[] body = this.next;
                    this.next = null;
                    return body;
                }
                byte[] body = this.region.read();
                if (body == null) {
                    this.state = 3;
                    return null;
                }
                if (!this.first) {
                    this.next = body;
                    body = this.dataFormat.delimiter();
                } else {
                    this.first = false;
                }
                return body;
            }
            case 3: {
                if (this.endStream) {
                    return null;
                }
                this.endStream = true;
                return this.dataFormat.end();
            }
        }
        return null;
    }
}

