/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.properties;

import com.starrocks.data.load.stream.StreamLoadDataFormat;
import com.starrocks.data.load.stream.StreamLoadUtils;
import com.starrocks.data.load.stream.annotation.Evolving;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.jpountz.lz4.LZ4FrameOutputStream;

public class StreamLoadTableProperties
implements Serializable {
    private final String uniqueKey;
    private final String database;
    private final String table;
    private final StreamLoadDataFormat dataFormat;
    private final Map<String, Object> tableProperties;
    private final Map<String, String> properties;
    private final boolean enableUpsertDelete;
    private final long chunkLimit;
    private final int maxBufferRows;
    private final String columns;
    private final Map<String, String> commonProperties;

    private StreamLoadTableProperties(Builder builder) {
        this.database = builder.database;
        this.table = builder.table;
        this.uniqueKey = builder.uniqueKey == null ? StreamLoadUtils.getTableUniqueKey(this.database, this.table) : builder.uniqueKey;
        this.dataFormat = builder.dataFormat == null ? StreamLoadDataFormat.JSON : builder.dataFormat;
        this.enableUpsertDelete = builder.enableUpsertDelete;
        this.chunkLimit = this.dataFormat instanceof StreamLoadDataFormat.JSONFormat ? Math.min(0xC0000000L, builder.chunkLimit) : Math.min(0x280000000L, builder.chunkLimit);
        this.maxBufferRows = builder.maxBufferRows;
        this.tableProperties = new HashMap<String, Object>(builder.tableProperties);
        this.properties = new HashMap<String, String>(builder.properties);
        this.columns = builder.columns;
        this.commonProperties = new HashMap<String, String>(builder.commonProperties);
    }

    public String getColumns() {
        return this.columns;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isEnableUpsertDelete() {
        return this.enableUpsertDelete;
    }

    public StreamLoadDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public Long getChunkLimit() {
        return this.chunkLimit;
    }

    public int getMaxBufferRows() {
        return this.maxBufferRows;
    }

    @Evolving
    public Map<String, Object> getTableProperties() {
        return this.tableProperties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getCommonProperties() {
        return this.commonProperties;
    }

    public Optional<String> getProperty(String name) {
        String value = this.properties.get(name);
        if (value != null) {
            return Optional.of(value);
        }
        return Optional.ofNullable(this.commonProperties.get(name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String uniqueKey;
        private String database;
        private String table;
        private String columns;
        private boolean enableUpsertDelete;
        private StreamLoadDataFormat dataFormat;
        private long chunkLimit;
        private int maxBufferRows = Integer.MAX_VALUE;
        private final Map<String, Object> tableProperties = new HashMap<String, Object>();
        private final Map<String, String> properties = new HashMap<String, String>();
        private final Map<String, String> commonProperties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder copyFrom(StreamLoadTableProperties streamLoadTableProperties) {
            this.database(streamLoadTableProperties.getDatabase());
            this.table(streamLoadTableProperties.getTable());
            this.columns(streamLoadTableProperties.getColumns());
            this.streamLoadDataFormat(streamLoadTableProperties.getDataFormat());
            this.chunkLimit(streamLoadTableProperties.getChunkLimit());
            this.maxBufferRows(streamLoadTableProperties.getMaxBufferRows());
            this.tableProperties.putAll(streamLoadTableProperties.getTableProperties());
            this.commonProperties.putAll(streamLoadTableProperties.getCommonProperties());
            return this;
        }

        public Builder uniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder columns(String columns) {
            this.columns = columns;
            return this;
        }

        public Builder enableUpsertDelete(boolean enableUpsertDelete) {
            this.enableUpsertDelete = enableUpsertDelete;
            return this;
        }

        public Builder streamLoadDataFormat(StreamLoadDataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder chunkLimit(long chunkLimit) {
            this.chunkLimit = chunkLimit;
            return this;
        }

        public Builder maxBufferRows(int maxBufferRows) {
            this.maxBufferRows = maxBufferRows;
            return this;
        }

        public Builder addProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder addProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder setLZ4BlockSize(LZ4FrameOutputStream.BLOCKSIZE blockSize) {
            this.tableProperties.put("compression.lz4.block.size", (Object)blockSize);
            return this;
        }

        public Builder addCommonProperties(Map<String, String> properties) {
            this.commonProperties.putAll(properties);
            return this;
        }

        public StreamLoadTableProperties build() {
            if (this.database == null || this.table == null) {
                throw new IllegalArgumentException(String.format("database `%s` or table `%s` can't be null", this.database, this.table));
            }
            this.addProperty("db", this.database);
            this.addProperty("table", this.table);
            if (this.columns != null) {
                this.addProperty("columns", this.columns);
            }
            return new StreamLoadTableProperties(this);
        }
    }
}

