/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.v2;

import com.starrocks.data.load.stream.Chunk;
import com.starrocks.data.load.stream.v2.ChunkInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkHttpEntity
extends AbstractHttpEntity {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkHttpEntity.class);
    protected static final int OUTPUT_BUFFER_SIZE = 2048;
    private static final Header CONTENT_TYPE = new BasicHeader("Content-Type", ContentType.APPLICATION_OCTET_STREAM.toString());
    private final String tableUniqueKey;
    private final Chunk chunk;
    private final long contentLength;
    private boolean logAfterWrite;

    public ChunkHttpEntity(String tableUniqueKey, Chunk chunk) {
        this.tableUniqueKey = tableUniqueKey;
        this.chunk = chunk;
        this.contentLength = chunk.chunkBytes();
        this.logAfterWrite = true;
    }

    public String getTableUniqueKey() {
        return this.tableUniqueKey;
    }

    public void setLogAfterWrite(boolean logAfterWrite) {
        this.logAfterWrite = logAfterWrite;
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        return CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() {
        return new ChunkInputStream(this.chunk);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        long startTime = System.nanoTime();
        try (ChunkInputStream inputStream = new ChunkInputStream(this.chunk);){
            int len;
            byte[] buffer = new byte[2048];
            while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
        }
        if (this.logAfterWrite || LOG.isDebugEnabled()) {
            LOG.info("Write entity for table {}, size:{}, time:{}us", new Object[]{this.tableUniqueKey, this.contentLength, (System.nanoTime() - startTime) / 1000L});
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

