/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.rdd;

import com.starrocks.connector.spark.backend.BackendClient;
import com.starrocks.connector.spark.cfg.Settings;
import com.starrocks.connector.spark.exception.ShouldNeverHappenException;
import com.starrocks.connector.spark.rest.PartitionDefinition;
import com.starrocks.connector.spark.rest.models.Schema;
import com.starrocks.connector.spark.serialization.Routing;
import com.starrocks.connector.spark.serialization.RowBatch;
import com.starrocks.connector.spark.sql.SchemaUtils$;
import com.starrocks.thrift.TScanBatchResult;
import com.starrocks.thrift.TScanCloseParams;
import com.starrocks.thrift.TScanColumnDesc;
import com.starrocks.thrift.TScanNextBatchParams;
import com.starrocks.thrift.TScanOpenParams;
import com.starrocks.thrift.TScanOpenResult;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Breaks;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\u0015*\u0001QB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")\u0011\n\u0001C\u0001\u0015\"9q\n\u0001b\u0001\n#\u0001\u0006BB.\u0001A\u0003%\u0011\u000bC\u0004]\u0001\t\u0007I\u0011C/\t\r\u0019\u0004\u0001\u0015!\u0003_\u0011\u001d9\u0007A1A\u0005\u0012!Daa\u001c\u0001!\u0002\u0013I\u0007b\u00029\u0001\u0001\u0004%\t\"\u001d\u0005\bk\u0002\u0001\r\u0011\"\u0005w\u0011\u0019a\b\u0001)Q\u0005e\"9Q\u0010\u0001a\u0001\n#q\b\"CA\n\u0001\u0001\u0007I\u0011CA\u000b\u0011\u001d\tI\u0002\u0001Q!\n}D1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002\u001e!Y\u00111\u0006\u0001A\u0002\u0003\u0007I\u0011CA\u0017\u0011-\t\t\u0004\u0001a\u0001\u0002\u0003\u0006K!a\b\t\u0013\u0005M\u0002\u00011A\u0005\u0012\u0005U\u0002\"CA\u001f\u0001\u0001\u0007I\u0011CA \u0011!\t\u0019\u0005\u0001Q!\n\u0005]\u0002\"CA#\u0001\u0001\u0007I\u0011CA$\u0011%\t\t\u0006\u0001a\u0001\n#\t\u0019\u0006\u0003\u0005\u0002X\u0001\u0001\u000b\u0015BA%\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA/\u0011%\tY\u0007\u0001b\u0001\n#\ti\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA8\u0011%\t9\b\u0001b\u0001\n#\tI\b\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BA>\u0011%\t\u0019\n\u0001b\u0001\n#\t)\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAL\u0011%\t)\u000b\u0001b\u0001\n#\t9\u000b\u0003\u0005\u00026\u0002\u0001\u000b\u0011BAU\u0011%\t9\f\u0001b\u0001\n#\t)\u0004\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BA\u001c\u0011\u001d\tY\f\u0001C\u0001\u0003kAq!!0\u0001\t\u0003\ty\fC\u0004\u0002B\u0002!\t!a1\u0003!M\u001b\u0017\r\\1WC2,XMU3bI\u0016\u0014(B\u0001\u0016,\u0003\r\u0011H\r\u001a\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\u0013\r|gN\\3di>\u0014(B\u0001\u00192\u0003%\u0019H/\u0019:s_\u000e\\7OC\u00013\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VMZ\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"!\u0010!\u000e\u0003yR!aP\u0016\u0002\tI,7\u000f^\u0005\u0003\u0003z\u00121\u0003U1si&$\u0018n\u001c8EK\u001aLg.\u001b;j_:\f\u0001b]3ui&twm\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r.\n1a\u00194h\u0013\tAUI\u0001\u0005TKR$\u0018N\\4t\u0003\u0019a\u0014N\\5u}Q\u00191*\u0014(\u0011\u00051\u0003Q\"A\u0015\t\u000bm\u001a\u0001\u0019\u0001\u001f\t\u000b\t\u001b\u0001\u0019A\"\u0002\r1|wmZ3s+\u0005\t\u0006C\u0001*Z\u001b\u0005\u0019&B\u0001+V\u0003\u0015awn\u001a\u001bk\u0015\t1v+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0006\u0019qN]4\n\u0005i\u001b&A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0011QLW.\u001a.p]\u0016,\u0012A\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA\u0001^5nK*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005\u0019QvN\\3JI\u0006IA/[7f5>tW\rI\u0001\u0007G2LWM\u001c;\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\\u0016\u0002\u000f\t\f7m[3oI&\u0011an\u001b\u0002\u000e\u0005\u0006\u001c7.\u001a8e\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u00051qN\u001a4tKR,\u0012A\u001d\t\u0003mML!\u0001^\u001c\u0003\u0007%sG/\u0001\u0006pM\u001a\u001cX\r^0%KF$\"a\u001e>\u0011\u0005YB\u0018BA=8\u0005\u0011)f.\u001b;\t\u000fm\\\u0011\u0011!a\u0001e\u0006\u0019\u0001\u0010J\u0019\u0002\u000f=4gm]3uA\u0005\u0019Qm\\:\u0016\u0003}\u0004B!!\u0001\u0002\u00105\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u0013\tY!\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u0004c\u0003\u0011)H/\u001b7\n\t\u0005E\u00111\u0001\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u000f\u0015|7o\u0018\u0013fcR\u0019q/a\u0006\t\u000fmt\u0011\u0011!a\u0001\u007f\u0006!Qm\\:!\u0003!\u0011xn\u001e\"bi\u000eDWCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013W\u0005i1/\u001a:jC2L'0\u0019;j_:LA!!\u000b\u0002$\tA!k\\<CCR\u001c\u0007.\u0001\u0007s_^\u0014\u0015\r^2i?\u0012*\u0017\u000fF\u0002x\u0003_A\u0001b_\t\u0002\u0002\u0003\u0007\u0011qD\u0001\ne><()\u0019;dQ\u0002\nq\u0004Z3tKJL\u0017\r\\5{K\u0006\u0013(o\\<U_J{wOQ1uG\"\f5/\u001f8d+\t\t9\u0004E\u00027\u0003sI1!a\u000f8\u0005\u001d\u0011un\u001c7fC:\f1\u0005Z3tKJL\u0017\r\\5{K\u0006\u0013(o\\<U_J{wOQ1uG\"\f5/\u001f8d?\u0012*\u0017\u000fF\u0002x\u0003\u0003B\u0001b\u001f\u000b\u0002\u0002\u0003\u0007\u0011qG\u0001!I\u0016\u001cXM]5bY&TX-\u0011:s_^$vNU8x\u0005\u0006$8\r[!ts:\u001c\u0007%A\u000bs_^\u0014\u0015\r^2i\u00052|7m[5oOF+X-^3\u0016\u0005\u0005%\u0003CBA&\u0003\u001b\ny\"\u0004\u0002\u0002\b%!\u0011qJA\u0004\u00055\u0011En\\2lS:<\u0017+^3vK\u0006I\"o\\<CCR\u001c\u0007N\u00117pG.LgnZ)vKV,w\fJ3r)\r9\u0018Q\u000b\u0005\tw^\t\t\u00111\u0001\u0002J\u00051\"o\\<CCR\u001c\u0007N\u00117pG.LgnZ)vKV,\u0007%\u0001\u0006pa\u0016t\u0007+\u0019:b[N,\"!!\u0018\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u00190\u0003\u0019!\bN]5gi&!\u0011qMA1\u0005=!6kY1o\u001fB,g\u000eU1sC6\u001c\u0018aC8qK:\u0004\u0016M]1ng\u0002\n!b\u001c9f]J+7/\u001e7u+\t\ty\u0007\u0005\u0003\u0002`\u0005E\u0014\u0002BA:\u0003C\u0012q\u0002V*dC:|\u0005/\u001a8SKN,H\u000e^\u0001\f_B,gNU3tk2$\b%A\u0005d_:$X\r\u001f;JIV\u0011\u00111\u0010\t\u0005\u0003{\nYI\u0004\u0003\u0002\u0000\u0005\u001d\u0005cAAAo5\u0011\u00111\u0011\u0006\u0004\u0003\u000b\u001b\u0014A\u0002\u001fs_>$h(C\u0002\u0002\n^\na\u0001\u0015:fI\u00164\u0017\u0002BAG\u0003\u001f\u0013aa\u0015;sS:<'bAAEo\u0005Q1m\u001c8uKb$\u0018\n\u001a\u0011\u0002\rM\u001c\u0007.Z7b+\t\t9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\tiJP\u0001\u0007[>$W\r\\:\n\t\u0005\u0005\u00161\u0014\u0002\u0007'\u000eDW-\\1\u0002\u000fM\u001c\u0007.Z7bA\u0005Y\u0011m]=oGRC'/Z1e+\t\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\tyKY\u0001\u0005Y\u0006tw-\u0003\u0003\u00024\u00065&A\u0002+ie\u0016\fG-\u0001\u0007bgft7\r\u00165sK\u0006$\u0007%\u0001\nbgft7\r\u00165sK\u0006$7\u000b^1si\u0016$\u0017aE1ts:\u001cG\u000b\u001b:fC\u0012\u001cF/\u0019:uK\u0012\u0004\u0013a\u00025bg:+\u0007\u0010^\u0001\u0005]\u0016DH/F\u00016\u0003\u0015\u0019Gn\\:f)\u00059\b")
public class ScalaValueReader {
    private final Settings settings;
    private final Logger logger;
    private final ZoneId timeZone;
    private final BackendClient client;
    private int offset;
    private AtomicBoolean eos;
    private RowBatch rowBatch;
    private boolean deserializeArrowToRowBatchAsync;
    private BlockingQueue<RowBatch> rowBatchBlockingQueue;
    private final TScanOpenParams openParams;
    private final TScanOpenResult openResult;
    private final String contextId;
    private final Schema schema;
    private final Thread asyncThread;
    private final boolean asyncThreadStarted;

    public Logger logger() {
        return this.logger;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public BackendClient client() {
        return this.client;
    }

    public int offset() {
        return this.offset;
    }

    public void offset_$eq(int x$1) {
        this.offset = x$1;
    }

    public AtomicBoolean eos() {
        return this.eos;
    }

    public void eos_$eq(AtomicBoolean x$1) {
        this.eos = x$1;
    }

    public RowBatch rowBatch() {
        return this.rowBatch;
    }

    public void rowBatch_$eq(RowBatch x$1) {
        this.rowBatch = x$1;
    }

    public boolean deserializeArrowToRowBatchAsync() {
        return this.deserializeArrowToRowBatchAsync;
    }

    public void deserializeArrowToRowBatchAsync_$eq(boolean x$1) {
        this.deserializeArrowToRowBatchAsync = x$1;
    }

    public BlockingQueue<RowBatch> rowBatchBlockingQueue() {
        return this.rowBatchBlockingQueue;
    }

    public void rowBatchBlockingQueue_$eq(BlockingQueue<RowBatch> x$1) {
        this.rowBatchBlockingQueue = x$1;
    }

    private TScanOpenParams openParams() {
        return this.openParams;
    }

    public TScanOpenResult openResult() {
        return this.openResult;
    }

    public String contextId() {
        return this.contextId;
    }

    public Schema schema() {
        return this.schema;
    }

    public Thread asyncThread() {
        return this.asyncThread;
    }

    public boolean asyncThreadStarted() {
        return this.asyncThreadStarted;
    }

    public boolean hasNext() {
        BooleanRef hasNext = BooleanRef.create((boolean)false);
        if (this.deserializeArrowToRowBatchAsync() && this.asyncThreadStarted()) {
            if (this.rowBatch() == null || !this.rowBatch().hasNext()) {
                Breaks loop = new Breaks();
                loop.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (!this.eos().get() || !this.rowBatchBlockingQueue().isEmpty()) {
                        if (!this.rowBatchBlockingQueue().isEmpty()) {
                            this.rowBatch_$eq(this.rowBatchBlockingQueue().take());
                            hasNext$1.elem = true;
                            throw loop.break();
                        }
                        Thread.sleep(5L);
                    }
                });
            } else {
                hasNext.elem = true;
            }
        } else {
            if (!(this.eos().get() || this.rowBatch() != null && this.rowBatch().hasNext())) {
                if (this.rowBatch() != null) {
                    this.offset_$eq(this.offset() + this.rowBatch().getReadRowCount());
                    this.rowBatch().close();
                }
                TScanNextBatchParams nextBatchParams = new TScanNextBatchParams();
                nextBatchParams.setContext_id(this.contextId());
                nextBatchParams.setOffset(this.offset());
                TScanBatchResult nextResult = this.client().getNext(nextBatchParams);
                this.eos().set(nextResult.isEos());
                if (!this.eos().get()) {
                    this.rowBatch_$eq(new RowBatch(nextResult, this.schema(), this.timeZone()));
                }
            }
            hasNext.elem = !this.eos().get();
        }
        return hasNext.elem;
    }

    public Object next() {
        if (!this.hasNext()) {
            this.logger().error((Object)"Should not come here.");
            throw new ShouldNeverHappenException();
        }
        return this.rowBatch().next();
    }

    public void close() {
        TScanCloseParams closeParams = new TScanCloseParams();
        closeParams.context_id = this.contextId();
        this.client().closeScanner(closeParams);
    }

    public ScalaValueReader(PartitionDefinition partition, Settings settings) {
        this.settings = settings;
        this.logger = Logger.getLogger(ScalaValueReader.class);
        this.timeZone = ZoneId.of(settings.getProperty("starrocks.timezone", ZoneId.systemDefault().toString()));
        this.client = new BackendClient(new Routing(partition.getBeAddress()), settings);
        this.offset = 0;
        this.eos = new AtomicBoolean(false);
        this.deserializeArrowToRowBatchAsync = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.settings.getProperty("starrocks.deserialize.arrow.async", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString()))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn((Object)new Tuple3((Object)"Parse '{}' to boolean failed. Original string is '{}'.", (Object)"starrocks.deserialize.arrow.async", (Object)$this.settings.getProperty("starrocks.deserialize.arrow.async")));
            return false;
        }));
        int blockingQueueSize = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.settings.getProperty("starrocks.deserialize.queue.size", ((Object)BoxesRunTime.boxToInteger((int)64)).toString()))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn((Object)new Tuple3((Object)"Parse '{}' to number failed. Original string is '{}'.", (Object)"starrocks.deserialize.queue.size", (Object)$this.settings.getProperty("starrocks.deserialize.queue.size")));
            return 64;
        }));
        ArrayBlockingQueue queue = null;
        if (this.deserializeArrowToRowBatchAsync()) {
            queue = new ArrayBlockingQueue(blockingQueueSize);
        }
        this.rowBatchBlockingQueue = queue;
        TScanOpenParams params = new TScanOpenParams();
        params.cluster = "default_cluster";
        params.database = partition.getDatabase();
        params.table = partition.getTable();
        params.tablet_ids = JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(partition.getTabletIds()).toList());
        params.opaqued_query_plan = partition.getQueryPlan();
        int batchSize = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.settings.getProperty("starrocks.batch.size", ((Object)BoxesRunTime.boxToInteger((int)1024)).toString()))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn((Object)new Tuple3((Object)"Parse '{}' to number failed. Original string is '{}'.", (Object)"starrocks.batch.size", (Object)$this.settings.getProperty("starrocks.batch.size")));
            return 1024;
        }));
        int queryStarrocksTimeout = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.settings.getProperty("starrocks.request.query.timeout.s", ((Object)BoxesRunTime.boxToInteger((int)3600)).toString()))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn((Object)new Tuple3((Object)"Parse '{}' to number failed. Original string is '{}'.", (Object)"starrocks.request.query.timeout.s", (Object)$this.settings.getProperty("starrocks.request.query.timeout.s")));
            return 3600;
        }));
        long execMemLimit = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.settings.getProperty("starrocks.exec.mem.limit", ((Object)BoxesRunTime.boxToLong((long)0x80000000L)).toString()))).toLong()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn((Object)new Tuple3((Object)"Parse '{}' to number failed. Original string is '{}'.", (Object)"starrocks.exec.mem.limit", (Object)$this.settings.getProperty("starrocks.exec.mem.limit")));
            return 0x80000000L;
        }));
        params.setBatch_size(batchSize);
        params.setQuery_timeout(queryStarrocksTimeout);
        params.setMem_limit(execMemLimit);
        params.setUser(settings.getProperty("starrocks.request.auth.user", ""));
        params.setPasswd(settings.getProperty("starrocks.request.auth.password", ""));
        this.logger().debug((Object)new StringBuilder(142).append("Open scan params is, ").append("cluster: ").append(params.getCluster()).append(", ").append("database: ").append(params.getDatabase()).append(", ").append("table: ").append(params.getTable()).append(", ").append("tabletId: ").append(params.getTablet_ids()).append(", ").append("batch size: ").append(batchSize).append(", ").append("query timeout: ").append(queryStarrocksTimeout).append(", ").append("execution memory limit: ").append(execMemLimit).append(", ").append("user: ").append(params.getUser()).append(", ").append("query plan: ").append(params.opaqued_query_plan).toString());
        this.openParams = params;
        this.openResult = this.client().openScanner(this.openParams());
        this.contextId = this.openResult().getContext_id();
        this.schema = SchemaUtils$.MODULE$.convertToSchema((Seq<TScanColumnDesc>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.openResult().getSelected_columns()));
        this.asyncThread = new Thread(this){
            private final /* synthetic */ ScalaValueReader $outer;

            public void run() {
                TScanNextBatchParams nextBatchParams = new TScanNextBatchParams();
                nextBatchParams.setContext_id(this.$outer.contextId());
                while (!this.$outer.eos().get()) {
                    nextBatchParams.setOffset(this.$outer.offset());
                    TScanBatchResult nextResult = this.$outer.client().getNext(nextBatchParams);
                    this.$outer.eos().set(nextResult.isEos());
                    if (this.$outer.eos().get()) continue;
                    RowBatch rowBatch = new RowBatch(nextResult, this.$outer.schema(), this.$outer.timeZone());
                    this.$outer.offset_$eq(this.$outer.offset() + rowBatch.getReadRowCount());
                    rowBatch.close();
                    this.$outer.rowBatchBlockingQueue().put(rowBatch);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean started = false;
        if (this.deserializeArrowToRowBatchAsync()) {
            this.asyncThread().start();
            started = true;
        }
        this.asyncThreadStarted = started;
        this.logger().debug((Object)new StringBuilder(43).append("Open scan result is, contextId: ").append(this.contextId()).append(", schema: ").append(this.schema()).append(".").toString());
    }
}

