/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.rest.models;

import com.starrocks.connector.spark.rest.models.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Schema {
    private int status = 0;
    private List<Field> properties;

    public Schema() {
        this.properties = new ArrayList<Field>();
    }

    public Schema(int fieldCount) {
        this.properties = new ArrayList<Field>(fieldCount);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<Field> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Field> properties) {
        this.properties = properties;
    }

    public void put(String name, String type, String comment, int scale, int precision) {
        this.properties.add(new Field(name, type, comment, scale, precision));
    }

    public void put(Field f) {
        this.properties.add(f);
    }

    public Field get(int index) {
        if (index >= this.properties.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Fields size: " + this.properties.size());
        }
        return this.properties.get(index);
    }

    public int size() {
        return this.properties.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return this.status == schema.status && Objects.equals(this.properties, schema.properties);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.properties);
    }

    public String toString() {
        return "Schema{status=" + this.status + ", properties=" + this.properties + '}';
    }
}

