/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql;

import com.starrocks.connector.spark.sql.StarRocksTable;
import com.starrocks.connector.spark.sql.StarrocksRelation;
import com.starrocks.connector.spark.sql.Utils;
import com.starrocks.connector.spark.sql.conf.SimpleStarRocksConfig;
import com.starrocks.connector.spark.sql.conf.StarRocksConfig;
import com.starrocks.connector.spark.sql.connect.StarRocksConnector;
import com.starrocks.connector.spark.sql.schema.InferSchema;
import com.starrocks.connector.spark.sql.schema.StarRocksSchema;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Map;

public class StarRocksTableProvider
implements RelationProvider,
TableProvider,
DataSourceRegister {
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksTableProvider.class);
    @Nullable
    private StarRocksSchema starocksSchema;

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return new StarrocksRelation(sqlContext, Utils.params(parameters, LOG));
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        SimpleStarRocksConfig config = new SimpleStarRocksConfig(StarRocksTableProvider.makeWriteCompatibleWithRead((java.util.Map<String, String>)options));
        this.starocksSchema = this.getStarRocksSchema(config);
        return InferSchema.inferSchema(this.starocksSchema, config);
    }

    public Table getTable(StructType schema, Transform[] partitioning, java.util.Map<String, String> properties) {
        SimpleStarRocksConfig config = new SimpleStarRocksConfig(StarRocksTableProvider.makeWriteCompatibleWithRead(properties));
        StarRocksSchema starRocksSchema = this.getStarRocksSchema(config);
        return new StarRocksTable(schema, starRocksSchema, config);
    }

    public String shortName() {
        return "starrocks";
    }

    private StarRocksSchema getStarRocksSchema(StarRocksConfig config) {
        if (this.starocksSchema == null) {
            this.starocksSchema = StarRocksConnector.getSchema(config);
        }
        return this.starocksSchema;
    }

    private static java.util.Map<String, String> makeWriteCompatibleWithRead(java.util.Map<String, String> options) {
        String password;
        HashMap<String, String> compatibleOptions = new HashMap<String, String>(options);
        String user = options.get("user");
        if (user != null && !options.containsKey("starrocks.user")) {
            compatibleOptions.put("starrocks.user", user);
        }
        if ((password = options.get("password")) != null && !options.containsKey("starrocks.password")) {
            compatibleOptions.put("starrocks.password", password);
        }
        String feNodes = options.get("starrocks.fenodes");
        String feHttp = options.get("starrocks.fe.http.url");
        if (feNodes == null && feHttp != null) {
            compatibleOptions.put("starrocks.fenodes", feHttp);
        }
        if (feNodes != null && feHttp == null) {
            compatibleOptions.put("starrocks.fe.http.url", feNodes);
        }
        return compatibleOptions;
    }
}

