/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.starrocks.connector.spark.sql.schema.AbstractRowStringConverter;
import java.time.ZoneId;
import java.util.HashMap;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRowStringConverter
extends AbstractRowStringConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONRowStringConverter.class);
    private final String[] streamLoadColumnNames;
    private final ObjectMapper mapper;

    public JSONRowStringConverter(StructType schema, String[] streamLoadColumnNames, ZoneId timeZone) {
        super(schema, timeZone);
        this.streamLoadColumnNames = streamLoadColumnNames;
        this.mapper = new ObjectMapper();
    }

    @Override
    public String fromRow(Row row) {
        if (row.schema() == null) {
            throw new RuntimeException("Can't convert Row without schema");
        }
        HashMap data = new HashMap();
        for (int i = 0; i < row.length(); ++i) {
            StructField field = row.schema().apply(i);
            if (field.nullable() && row.isNullAt(i)) continue;
            data.put(this.streamLoadColumnNames[i], this.valueConverters[i].apply(row.get(i)));
        }
        try {
            return this.mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            LOG.error("Failed to serialize row to json, data: {}", data, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

