/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.schema;

import com.starrocks.connector.spark.sql.schema.StarRocksField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StarRocksSchema {
    private final List<StarRocksField> columns;
    private final List<StarRocksField> pks;
    private final Map<String, StarRocksField> columnMap;

    public StarRocksSchema(List<StarRocksField> columns, List<StarRocksField> pks) {
        this.columns = columns;
        this.pks = pks;
        this.columnMap = new HashMap<String, StarRocksField>();
        for (StarRocksField field : columns) {
            this.columnMap.put(field.getName(), field);
        }
    }

    public List<StarRocksField> getColumns() {
        return this.columns;
    }

    public boolean isPrimaryKey() {
        return !this.pks.isEmpty();
    }

    public StarRocksField getField(String columnName) {
        if (StarRocksField.__OP.getName().equalsIgnoreCase(columnName)) {
            return StarRocksField.__OP;
        }
        return this.columnMap.get(columnName);
    }
}

