/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import com.starrocks.data.load.stream.StreamLoadDataFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class Chunk {
    private final StreamLoadDataFormat format;
    private final LinkedList<byte[]> buffer;
    private final AtomicLong rowBytes;
    private final AtomicLong chunkBytes;

    public Chunk(StreamLoadDataFormat format) {
        this.format = format;
        this.buffer = new LinkedList();
        this.rowBytes = new AtomicLong();
        this.chunkBytes = new AtomicLong();
        this.chunkBytes.addAndGet(format.first().length);
        this.chunkBytes.addAndGet(format.end().length);
    }

    public void addRow(byte[] data) {
        this.rowBytes.addAndGet(data.length);
        this.chunkBytes.addAndGet(data.length + (this.buffer.isEmpty() ? 0 : this.format.delimiter().length));
        this.buffer.add(data);
    }

    public int numRows() {
        return this.buffer.size();
    }

    public long rowBytes() {
        return this.rowBytes.get();
    }

    public long chunkBytes() {
        return this.chunkBytes.get();
    }

    public long estimateChunkSize(byte[] data) {
        return this.chunkBytes.get() + (long)data.length + (long)this.format.delimiter().length;
    }

    public Iterator<byte[]> iterator() {
        return new DataIterator();
    }

    private class DataIterator
    implements Iterator<byte[]> {
        private final Iterator<byte[]> rowIterator;
        private int totalItems;
        private ItemType nextItemType;

        public DataIterator() {
            this.totalItems = 2 + Chunk.this.buffer.size() + (Chunk.this.buffer.size() - 1);
            this.rowIterator = Chunk.this.buffer.iterator();
            this.nextItemType = ItemType.FIRST;
        }

        @Override
        public boolean hasNext() {
            return this.totalItems > 0;
        }

        @Override
        public byte[] next() {
            byte[] item;
            switch (this.nextItemType) {
                case FIRST: {
                    item = Chunk.this.format.first();
                    this.nextItemType = this.rowIterator.hasNext() ? ItemType.ROW : ItemType.END;
                    break;
                }
                case ROW: {
                    item = this.rowIterator.next();
                    this.nextItemType = this.rowIterator.hasNext() ? ItemType.DELIMITER : ItemType.END;
                    break;
                }
                case DELIMITER: {
                    item = Chunk.this.format.delimiter();
                    this.nextItemType = ItemType.ROW;
                    break;
                }
                case END: {
                    item = Chunk.this.format.end();
                    this.nextItemType = ItemType.NONE;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Should not switch to type " + (Object)((Object)this.nextItemType));
                }
            }
            --this.totalItems;
            return item;
        }
    }

    static enum ItemType {
        NONE,
        FIRST,
        ROW,
        DELIMITER,
        END;

    }
}

