/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import java.io.StringWriter;

public class DelimiterParser {
    private static final String HEX_STRING = "0123456789ABCDEF";

    private static byte[] hexStrToBytes(String hexStr) {
        String upperHexStr = hexStr.toUpperCase();
        int length = upperHexStr.length() / 2;
        char[] hexChars = upperHexStr.toCharArray();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            bytes[i] = (byte)(DelimiterParser.charToByte(hexChars[pos]) << 4 | 0xFF & DelimiterParser.charToByte(hexChars[pos + 1]));
        }
        return bytes;
    }

    private static byte charToByte(char c) {
        return (byte)HEX_STRING.indexOf(c);
    }

    public static String convertDelimiter(String originStr) {
        if (originStr == null || originStr.isEmpty()) {
            throw new RuntimeException("The delimiter can't be null or empty");
        }
        if (originStr.toUpperCase().startsWith("\\X") || originStr.toUpperCase().startsWith("0X")) {
            String hexStr = originStr.substring(2);
            if (hexStr.isEmpty()) {
                throw new RuntimeException("Invalid delimiter '" + originStr + ": empty hex string");
            }
            if (hexStr.length() % 2 != 0) {
                throw new RuntimeException("Invalid delimiter '" + originStr + ": hex length must be a even number");
            }
            for (char hexChar : hexStr.toUpperCase().toCharArray()) {
                if (HEX_STRING.indexOf(hexChar) != -1) continue;
                throw new RuntimeException("Invalid delimiter '" + originStr + "': invalid hex format");
            }
            StringWriter writer = new StringWriter();
            for (byte b : DelimiterParser.hexStrToBytes(hexStr)) {
                writer.append((char)b);
            }
            return writer.toString();
        }
        return originStr;
    }
}

