/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import com.starrocks.data.load.stream.StreamLoadResponse;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(LoadMetrics.class);
    private final long startTimeNano;
    private final AtomicLong numberOfSuccessLoad = new AtomicLong();
    private final AtomicLong totalSuccessLoadBytes = new AtomicLong();
    private final AtomicLong totalSuccessLoadRows = new AtomicLong();
    private final AtomicLong totalSuccessLoadTimeNano = new AtomicLong();
    private final AtomicLong numberOfFailedLoad = new AtomicLong();
    private final AtomicLong numberWriteTriggerFlush = new AtomicLong();
    private final AtomicLong numberWriteBlock = new AtomicLong();
    private final AtomicLong totalWriteBlockTimeNano = new AtomicLong();

    public LoadMetrics() {
        this.startTimeNano = System.nanoTime();
    }

    public void updateSuccessLoad(StreamLoadResponse response) {
        this.numberOfSuccessLoad.incrementAndGet();
        if (response.getFlushBytes() != null) {
            this.totalSuccessLoadBytes.addAndGet(response.getFlushBytes());
        }
        if (response.getFlushRows() != null) {
            this.totalSuccessLoadRows.addAndGet(response.getFlushRows());
        }
        if (response.getCostNanoTime() != null) {
            this.totalSuccessLoadTimeNano.addAndGet(response.getCostNanoTime());
        }
    }

    public void updateFailedLoad() {
        this.numberOfFailedLoad.incrementAndGet();
    }

    public void updateWriteTriggerFlush(int number) {
        this.numberWriteTriggerFlush.addAndGet(number);
    }

    public void updateWriteBlock(int number, long timeNano) {
        this.numberWriteBlock.addAndGet(number);
        this.totalWriteBlockTimeNano.addAndGet(timeNano);
    }

    public String toString() {
        return "LoadMetrics{startTimeNano=" + this.startTimeNano + ", totalRunningTimeNano=" + (System.nanoTime() - this.startTimeNano) + ", numberOfSuccessLoad=" + this.numberOfSuccessLoad + ", totalSuccessLoadBytes=" + this.totalSuccessLoadBytes + ", totalSuccessLoadRows=" + this.totalSuccessLoadRows + ", totalSuccessLoadTimeNano=" + this.totalSuccessLoadTimeNano + ", numberOfFailedLoad=" + this.numberOfFailedLoad + ", numberWriteTriggerFlush=" + this.numberWriteTriggerFlush + ", numberWriteBlock=" + this.numberWriteBlock + ", totalWriteBlockTimeNano=" + this.totalWriteBlockTimeNano + '}';
    }
}

