/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksVersion.class);
    private static final Pattern PATTERN = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<patch>\\d+).*");
    private int major;
    private int minor;
    private int patch;

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return "StarRocksVersion{major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + '}';
    }

    public static StarRocksVersion parse(String versionStr) {
        if (versionStr == null) {
            return null;
        }
        try {
            Matcher match = PATTERN.matcher(versionStr.trim());
            if (match.matches()) {
                StarRocksVersion version = new StarRocksVersion();
                version.major = Integer.parseInt(match.group("major"));
                version.minor = Integer.parseInt(match.group("minor"));
                version.patch = Integer.parseInt(match.group("patch"));
                LOG.info("Successful to parse starrocks version {}, {}", (Object)versionStr, (Object)version);
                return version;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to parse starrocks version {}", (Object)versionStr, (Object)e);
        }
        LOG.info("Fail to parse starrocks version {}", (Object)versionStr);
        return null;
    }
}

