/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

public interface StreamLoadConstants {
    public static final String PATH_STREAM_LOAD = "/api/{db}/{table}/_stream_load";
    public static final String PATH_TRANSACTION_BEGIN = "/api/transaction/begin";
    public static final String PATH_TRANSACTION_SEND = "/api/transaction/load";
    public static final String PATH_TRANSACTION_ROLLBACK = "/api/transaction/rollback";
    public static final String PATH_TRANSACTION_PRE_COMMIT = "/api/transaction/prepare";
    public static final String PATH_TRANSACTION_COMMIT = "/api/transaction/commit";
    public static final String PATH_STREAM_LOAD_STATE = "/api/{db}/get_load_state?label={label}";
    public static final String RESULT_STATUS_OK = "OK";
    public static final String RESULT_STATUS_SUCCESS = "Success";
    public static final String RESULT_STATUS_INTERNAL_ERROR = "INTERNAL_ERROR";
    public static final String RESULT_STATUS_FAILED = "Fail";
    public static final String RESULT_STATUS_LABEL_EXISTED = "Label Already Exists";
    public static final String RESULT_STATUS_TRANSACTION_NOT_EXISTED = "TXN_NOT_EXISTS";
    public static final String RESULT_STATUS_TRANSACTION_COMMIT_TIMEOUT = "Commit Timeout";
    public static final String RESULT_STATUS_TRANSACTION_PUBLISH_TIMEOUT = "Publish Timeout";
    public static final String EXISTING_JOB_STATUS_FINISHED = "FINISHED";

    public static String getBeginUrl(String host) {
        if (host == null) {
            throw new IllegalArgumentException("None of the hosts in `load_url` could be connected.");
        }
        return host + PATH_TRANSACTION_BEGIN;
    }

    public static String getSendUrl(String host) {
        if (host == null) {
            throw new IllegalArgumentException("None of the hosts in `load_url` could be connected.");
        }
        return host + PATH_TRANSACTION_SEND;
    }

    public static String getPrepareUrl(String host) {
        if (host == null) {
            throw new IllegalArgumentException("None of the hosts in `load_url` could be connected.");
        }
        return host + PATH_TRANSACTION_PRE_COMMIT;
    }

    public static String getCommitUrl(String host) {
        if (host == null) {
            throw new IllegalArgumentException("None of the hosts in `load_url` could be connected.");
        }
        return host + PATH_TRANSACTION_COMMIT;
    }

    public static String getRollbackUrl(String host) {
        if (host == null) {
            throw new IllegalArgumentException("None of the hosts in `load_url` could be connected.");
        }
        return host + PATH_TRANSACTION_ROLLBACK;
    }
}

