/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import com.starrocks.data.load.stream.TableRegion;
import com.starrocks.data.load.stream.properties.StreamLoadProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StreamLoadStrategy
extends Serializable {
    public List<TableRegion> select(Iterable<TableRegion> var1);

    public static class DefaultLoadStrategy
    implements StreamLoadStrategy {
        private static final long serialVersionUID = 1L;
        private static final Logger log = LoggerFactory.getLogger(DefaultLoadStrategy.class);
        private final long oldAge;
        private final long youngAge;
        private final long cacheMaxBytes;
        private final long writingThreshold;
        private final float regionBufferRatio;
        private final float cacheLimitBytes;

        public DefaultLoadStrategy(StreamLoadProperties properties) {
            long expectDelayTime = properties.getExpectDelayTime();
            this.youngAge = (long)((float)(expectDelayTime / properties.getScanningFrequency()) * properties.getYoungThreshold());
            this.oldAge = (long)((float)(expectDelayTime / properties.getScanningFrequency()) * properties.getOldThreshold());
            this.cacheMaxBytes = properties.getMaxCacheBytes();
            this.cacheLimitBytes = (float)this.cacheMaxBytes * 0.8f;
            this.writingThreshold = properties.getWritingThreshold();
            this.regionBufferRatio = properties.getRegionBufferRatio();
            log.info("Load Strategy properties : {}", (Object)this);
        }

        @Override
        public List<TableRegion> select(Iterable<TableRegion> regions) {
            ArrayList<TableRegion> waitFlushRegions = new ArrayList<TableRegion>();
            ArrayList<TableRegion> youngRegions = new ArrayList<TableRegion>();
            int totalReadableRegion = 0;
            for (TableRegion region : regions) {
                long age = region.getAndIncrementAge();
                ++totalReadableRegion;
                if (age >= this.oldAge) {
                    waitFlushRegions.add(region);
                    continue;
                }
                if (age < this.youngAge) continue;
                youngRegions.add(region);
            }
            if (totalReadableRegion == 0) {
                return waitFlushRegions;
            }
            long cacheThreshold = (long)((float)(this.cacheMaxBytes / (long)totalReadableRegion) * this.regionBufferRatio);
            long currentTimeMillis = System.currentTimeMillis();
            for (TableRegion region : youngRegions) {
                if (region.getCacheBytes() < cacheThreshold || (float)region.getCacheBytes() < this.cacheLimitBytes && currentTimeMillis - region.getLastWriteTimeMillis() < this.writingThreshold) continue;
                waitFlushRegions.add(region);
            }
            waitFlushRegions.sort(Comparator.comparingLong(TableRegion::getCacheBytes).reversed());
            return waitFlushRegions;
        }

        public long getOldAge() {
            return this.oldAge;
        }

        public long getYoungAge() {
            return this.youngAge;
        }

        public long getCacheMaxBytes() {
            return this.cacheMaxBytes;
        }

        public long getWritingThreshold() {
            return this.writingThreshold;
        }

        public float getRegionBufferRatio() {
            return this.regionBufferRatio;
        }

        public String toString() {
            return "DefaultLoadStrategy{oldAge=" + this.oldAge + ", youngAge=" + this.youngAge + ", cacheMaxBytes=" + this.cacheMaxBytes + ", writingThreshold=" + this.writingThreshold + ", regionBufferRatio=" + this.regionBufferRatio + ", cacheLimitBytes=" + this.cacheLimitBytes + '}';
        }
    }
}

