/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.http;

import com.starrocks.data.load.stream.StreamLoadDataFormat;
import com.starrocks.data.load.stream.TableRegion;
import com.starrocks.data.load.stream.http.StreamLoadEntityMeta;
import com.starrocks.data.load.stream.io.StreamLoadStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamLoadEntity
extends AbstractHttpEntity {
    private static final Logger log = LoggerFactory.getLogger(StreamLoadEntity.class);
    protected static final int OUTPUT_BUFFER_SIZE = 2048;
    private static final Header CONTENT_TYPE = new BasicHeader("Content-Type", ContentType.APPLICATION_OCTET_STREAM.toString());
    private final TableRegion region;
    private final InputStream content;
    private final boolean chunked;
    private final long contentLength;

    public StreamLoadEntity(TableRegion region, StreamLoadDataFormat dataFormat, StreamLoadEntityMeta meta) {
        this.region = region;
        this.content = new StreamLoadStream(region, dataFormat);
        this.chunked = meta.getBytes() == -1L;
        this.contentLength = meta.getBytes();
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        return CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.content;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        long total = 0L;
        try (InputStream inputStream = this.content;){
            int l;
            byte[] buffer = new byte[2048];
            while ((l = inputStream.read(buffer)) != -1) {
                total += (long)l;
                outputStream.write(buffer, 0, l);
            }
        }
        log.info("Entity write end, contentLength : {}, total : {}", (Object)this.contentLength, (Object)total);
    }

    public boolean isStreaming() {
        return true;
    }
}

