/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.starrocks.data.load.stream.StarRocksVersion;
import com.starrocks.data.load.stream.properties.StreamLoadTableProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StreamLoadProperties
implements Serializable {
    private final String jdbcUrl;
    private final String[] loadUrls;
    private final String username;
    @JsonIgnore
    private final String password;
    private final String version;
    private final StarRocksVersion starRocksVersion;
    private final String labelPrefix;
    private final StreamLoadTableProperties defaultTableProperties;
    private final Map<String, StreamLoadTableProperties> tablePropertiesMap;
    private final boolean enableTransaction;
    private final long scanningFrequency;
    private final long maxCacheBytes;
    private final long expectDelayTime;
    private final int connectTimeout;
    private final int socketTimeout;
    private final int waitForContinueTimeoutMs;
    private final int ioThreadCount;
    private final long writingThreshold;
    private final float regionBufferRatio;
    private final float youngThreshold;
    private final float oldThreshold;
    private final int maxRetries;
    private final int retryIntervalInMs;
    private final Map<String, String> headers;

    private StreamLoadProperties(Builder builder) {
        this.jdbcUrl = builder.jdbcUrl;
        this.loadUrls = builder.loadUrls;
        this.username = builder.username;
        this.password = builder.password;
        this.version = builder.version;
        this.starRocksVersion = StarRocksVersion.parse(this.version);
        this.enableTransaction = builder.enableTransaction;
        this.labelPrefix = builder.labelPrefix;
        this.defaultTableProperties = builder.defaultTableProperties;
        this.tablePropertiesMap = builder.tablePropertiesMap;
        this.scanningFrequency = builder.scanningFrequency;
        this.maxCacheBytes = builder.maxCacheBytes;
        this.expectDelayTime = builder.expectDelayTime;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.waitForContinueTimeoutMs = builder.waitForContinueTimeoutMs;
        this.ioThreadCount = builder.ioThreadCount;
        this.writingThreshold = builder.writingThreshold;
        this.regionBufferRatio = builder.regionBufferRatio;
        this.youngThreshold = builder.youngThreshold;
        this.oldThreshold = builder.oldThreshold;
        this.maxRetries = builder.maxRetries;
        this.retryIntervalInMs = builder.retryIntervalInMs;
        this.headers = Collections.unmodifiableMap(builder.headers);
    }

    public boolean isEnableTransaction() {
        return this.enableTransaction;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String[] getLoadUrls() {
        return this.loadUrls;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVersion() {
        return this.version;
    }

    public StarRocksVersion getStarRocksVersion() {
        return this.starRocksVersion;
    }

    public boolean isOpAutoProjectionInJson() {
        return this.version == null || this.version.length() > 0 && !this.version.trim().startsWith("1.");
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public StreamLoadTableProperties getDefaultTableProperties() {
        return this.defaultTableProperties;
    }

    public StreamLoadTableProperties getTableProperties(String uniqueKey, String database, String table) {
        StreamLoadTableProperties tableProperties = this.tablePropertiesMap.getOrDefault(uniqueKey, this.defaultTableProperties);
        if (!tableProperties.getDatabase().equals(database) || !tableProperties.getDatabase().equals(table)) {
            StreamLoadTableProperties.Builder tablePropertiesBuilder = StreamLoadTableProperties.builder();
            tablePropertiesBuilder = tablePropertiesBuilder.copyFrom(tableProperties).database(database).table(table);
            return tablePropertiesBuilder.build();
        }
        return tableProperties;
    }

    public Map<String, StreamLoadTableProperties> getTablePropertiesMap() {
        return this.tablePropertiesMap;
    }

    public long getScanningFrequency() {
        return this.scanningFrequency;
    }

    public long getMaxCacheBytes() {
        return this.maxCacheBytes;
    }

    public long getExpectDelayTime() {
        return this.expectDelayTime;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getWaitForContinueTimeoutMs() {
        return this.waitForContinueTimeoutMs;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public long getWritingThreshold() {
        return this.writingThreshold;
    }

    public float getRegionBufferRatio() {
        return this.regionBufferRatio;
    }

    public float getYoungThreshold() {
        return this.youngThreshold;
    }

    public float getOldThreshold() {
        return this.oldThreshold;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryIntervalInMs() {
        return this.retryIntervalInMs;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String jdbcUrl;
        private String[] loadUrls;
        private String username;
        private String password;
        private String version;
        private boolean enableTransaction;
        private String labelPrefix = "";
        private long scanningFrequency = 50L;
        private long maxCacheBytes = (long)((double)Runtime.getRuntime().freeMemory() * 0.7);
        private long expectDelayTime = 300000L;
        private StreamLoadTableProperties defaultTableProperties;
        private Map<String, StreamLoadTableProperties> tablePropertiesMap = new HashMap<String, StreamLoadTableProperties>();
        private int connectTimeout = 60000;
        private int socketTimeout;
        private int waitForContinueTimeoutMs = 3000;
        private int ioThreadCount = Runtime.getRuntime().availableProcessors();
        private long writingThreshold = 50L;
        private float regionBufferRatio = 0.6f;
        private float youngThreshold = 0.1f;
        private float oldThreshold = 0.9f;
        private int maxRetries = 0;
        private int retryIntervalInMs = 10000;
        private Map<String, String> headers = new HashMap<String, String>();

        public Builder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public Builder loadUrls(String ... loadUrls) {
            this.loadUrls = (String[])Arrays.stream(loadUrls).filter(Objects::nonNull).map(url -> {
                if (!url.startsWith("http")) {
                    return "http://" + url;
                }
                return url;
            }).toArray(String[]::new);
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder enableTransaction() {
            this.enableTransaction = true;
            return this;
        }

        public Builder labelPrefix(String labelPrefix) {
            this.labelPrefix = labelPrefix;
            return this;
        }

        public Builder defaultTableProperties(StreamLoadTableProperties tableProperties) {
            this.defaultTableProperties = tableProperties;
            return this;
        }

        public Builder addTableProperties(StreamLoadTableProperties tableProperties) {
            if (this.defaultTableProperties == null) {
                this.defaultTableProperties = tableProperties;
            }
            this.tablePropertiesMap.put(tableProperties.getUniqueKey(), tableProperties);
            return this;
        }

        public Builder scanningFrequency(long scanningFrequency) {
            if (scanningFrequency < 50L) {
                throw new IllegalArgumentException("scanningFrequency `" + scanningFrequency + "ms` set failed, must greater or equals to 50");
            }
            this.scanningFrequency = scanningFrequency;
            return this;
        }

        public Builder cacheMaxBytes(long maxCacheBytes) {
            if (maxCacheBytes <= 0L) {
                throw new IllegalArgumentException("cacheMaxBytes `" + maxCacheBytes + "` set failed, must greater to 0");
            }
            if (maxCacheBytes > Runtime.getRuntime().maxMemory()) {
                throw new IllegalArgumentException("cacheMaxBytes `" + maxCacheBytes + "` set failed, current maxMemory is " + Runtime.getRuntime().maxMemory());
            }
            this.maxCacheBytes = maxCacheBytes;
            return this;
        }

        public Builder expectDelayTime(long expectDelayTime) {
            if (expectDelayTime <= 0L) {
                throw new IllegalArgumentException("expectDelayTime `" + expectDelayTime + "ms` set failed, must greater to 0");
            }
            this.expectDelayTime = expectDelayTime;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            if (connectTimeout < 100 || connectTimeout > 60000) {
                throw new IllegalArgumentException("connectTimeout `" + connectTimeout + "ms` set failed, must range in [100, 60000]");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder waitForContinueTimeoutMs(int waitForContinueTimeoutMs) {
            if (waitForContinueTimeoutMs < 3000 || waitForContinueTimeoutMs > 60000) {
                throw new IllegalArgumentException("waitForContinueTimeoutMs `" + waitForContinueTimeoutMs + "ms` set failed, must be in range in [100, 60000]");
            }
            this.waitForContinueTimeoutMs = waitForContinueTimeoutMs;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            if (socketTimeout < 0) {
                throw new IllegalArgumentException("socketTimeout `" + socketTimeout + "ms` set failed, must greater or equals to 0");
            }
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder ioThreadCount(int ioThreadCount) {
            if (ioThreadCount <= 0) {
                throw new IllegalArgumentException("ioThreadCount `" + ioThreadCount + "` set failed, must greater to 0");
            }
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder writingThreshold(long writingThreshold) {
            this.writingThreshold = writingThreshold;
            return this;
        }

        public Builder regionBufferRatio(float regionBufferRatio) {
            if (regionBufferRatio <= 0.0f || regionBufferRatio > 1.0f) {
                throw new IllegalArgumentException("regionBufferRatio `" + regionBufferRatio + "` set failed, must range in (0, 1]");
            }
            this.regionBufferRatio = regionBufferRatio;
            return this;
        }

        public Builder youngThreshold(float youngThreshold) {
            if (youngThreshold <= 0.0f || youngThreshold > 1.0f) {
                throw new IllegalArgumentException("youngThreshold `" + youngThreshold + "` set failed, must range in (0, 1]");
            }
            this.youngThreshold = youngThreshold;
            return this;
        }

        public Builder oldThreshold(float oldThreshold) {
            if (oldThreshold <= 0.0f || oldThreshold > 1.0f) {
                throw new IllegalArgumentException("youngThreshold `" + oldThreshold + "` set failed, must range in (0, 1]");
            }
            this.oldThreshold = oldThreshold;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder retryIntervalInMs(int retryIntervalInMs) {
            this.retryIntervalInMs = retryIntervalInMs;
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public StreamLoadProperties build() {
            StreamLoadProperties streamLoadProperties = new StreamLoadProperties(this);
            if (streamLoadProperties.getYoungThreshold() >= streamLoadProperties.getOldThreshold()) {
                throw new IllegalArgumentException(String.format("oldThreshold(`%s`) must greater to youngThreshold(`%s`)", Float.valueOf(streamLoadProperties.getOldThreshold()), Float.valueOf(streamLoadProperties.getYoungThreshold())));
            }
            if (streamLoadProperties.getExpectDelayTime() < streamLoadProperties.getScanningFrequency()) {
                throw new IllegalArgumentException(String.format("expectDelayTime(`%s`) must greater to scanningFrequency(`%s`)", streamLoadProperties.getExpectDelayTime(), streamLoadProperties.getScanningFrequency()));
            }
            return streamLoadProperties;
        }
    }
}

