/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.v2;

import com.starrocks.data.load.stream.Chunk;
import com.starrocks.data.load.stream.v2.ChunkInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkHttpEntity
extends AbstractHttpEntity {
    private static final Logger log = LoggerFactory.getLogger(ChunkHttpEntity.class);
    protected static final int OUTPUT_BUFFER_SIZE = 2048;
    private static final Header CONTENT_TYPE = new BasicHeader("Content-Type", ContentType.APPLICATION_OCTET_STREAM.toString());
    private final String tableUniqueKey;
    private final InputStream content;
    private final long contentLength;

    public ChunkHttpEntity(String tableUniqueKey, Chunk chunk) {
        this.tableUniqueKey = tableUniqueKey;
        this.content = new ChunkInputStream(chunk);
        this.contentLength = chunk.chunkBytes();
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        return CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() {
        return this.content;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        long total = 0L;
        try (InputStream inputStream = this.content;){
            int l;
            byte[] buffer = new byte[2048];
            while ((l = inputStream.read(buffer)) != -1) {
                total += (long)l;
                outputStream.write(buffer, 0, l);
            }
        }
        log.info("Entity write end, uniqueKey: {}, contentLength : {}, total : {}", new Object[]{this.tableUniqueKey, this.contentLength, total});
    }

    public boolean isStreaming() {
        return true;
    }
}

