/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.v2;

import com.starrocks.data.load.stream.Chunk;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class ChunkInputStream
extends InputStream {
    private final Chunk chunk;
    private final Iterator<byte[]> itemIterator;
    private byte[] currentItem;
    private int currentPos;

    public ChunkInputStream(Chunk chunk) {
        this.chunk = chunk;
        this.itemIterator = chunk.iterator();
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int ws = this.read(bytes);
        if (ws == -1) {
            return -1;
        }
        return bytes[0];
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int readBytes;
        int size;
        if (!this.itemIterator.hasNext() && this.currentItem == null) {
            return -1;
        }
        byte[] item = this.currentItem;
        int pos = this.currentPos;
        for (readBytes = 0; readBytes < len && (item != null || this.itemIterator.hasNext()); readBytes += size) {
            if (item == null) {
                item = this.itemIterator.next();
                pos = 0;
            }
            size = Math.min(len - readBytes, item.length - pos);
            System.arraycopy(item, pos, buf, off + readBytes, size);
            if ((pos += size) != item.length) continue;
            item = null;
            pos = 0;
        }
        this.currentItem = item;
        this.currentPos = pos;
        return readBytes;
    }
}

