/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.v2;

import com.starrocks.data.load.stream.Chunk;
import com.starrocks.data.load.stream.LabelGenerator;
import com.starrocks.data.load.stream.StreamLoadManager;
import com.starrocks.data.load.stream.StreamLoadResponse;
import com.starrocks.data.load.stream.StreamLoadSnapshot;
import com.starrocks.data.load.stream.StreamLoader;
import com.starrocks.data.load.stream.TableRegion;
import com.starrocks.data.load.stream.exception.ErrorUtils;
import com.starrocks.data.load.stream.exception.StreamLoadFailException;
import com.starrocks.data.load.stream.http.StreamLoadEntityMeta;
import com.starrocks.data.load.stream.properties.StreamLoadTableProperties;
import com.starrocks.data.load.stream.v2.ChunkHttpEntity;
import com.starrocks.data.load.stream.v2.FlushReason;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionTableRegion
implements TableRegion {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionTableRegion.class);
    private final StreamLoadManager manager;
    private final StreamLoader streamLoader;
    private final LabelGenerator labelGenerator;
    private final String uniqueKey;
    private final String database;
    private final String table;
    private final StreamLoadTableProperties properties;
    private final AtomicLong age = new AtomicLong(0L);
    private final AtomicLong cacheBytes = new AtomicLong();
    private final AtomicLong cacheRows = new AtomicLong();
    private final AtomicReference<State> state;
    private final AtomicBoolean ctl = new AtomicBoolean(false);
    private volatile Chunk activeChunk;
    private final ConcurrentLinkedQueue<Chunk> inactiveChunks = new ConcurrentLinkedQueue();
    private volatile String label;
    private volatile Future<?> responseFuture;
    private volatile long lastCommitTimeMills;
    private final int maxRetries;
    private final int retryIntervalInMs;
    private volatile int numRetries;
    private volatile long lastFailTimeMs;
    private volatile Throwable firstException;

    public TransactionTableRegion(String uniqueKey, String database, String table, StreamLoadManager manager, StreamLoadTableProperties properties, StreamLoader streamLoader, LabelGenerator labelGenerator, int maxRetries, int retryIntervalInMs) {
        this.uniqueKey = uniqueKey;
        this.database = database;
        this.table = table;
        this.manager = manager;
        this.properties = properties;
        this.streamLoader = streamLoader;
        this.labelGenerator = labelGenerator;
        this.state = new AtomicReference<State>(State.ACTIVE);
        this.lastCommitTimeMills = System.currentTimeMillis();
        this.activeChunk = new Chunk(properties.getDataFormat());
        this.maxRetries = maxRetries;
        this.retryIntervalInMs = retryIntervalInMs;
    }

    @Override
    public StreamLoadTableProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getUniqueKey() {
        return this.uniqueKey;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public LabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    @Override
    public void setLabel(String label) {
        if (this.numRetries > 0 && label != null) {
            return;
        }
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public long getCacheBytes() {
        return this.cacheBytes.get();
    }

    @Override
    public void resetAge() {
        this.age.set(0L);
    }

    @Override
    public long getAndIncrementAge() {
        return this.age.getAndIncrement();
    }

    @Override
    public long getAge() {
        return this.age.get();
    }

    @Override
    public int write(byte[] row) {
        int c;
        if (row == null) {
            return 0;
        }
        if (this.ctl.compareAndSet(false, true)) {
            c = this.write0(row);
        } else {
            while (!this.ctl.compareAndSet(false, true)) {
            }
            c = this.write0(row);
        }
        this.ctl.set(false);
        return c;
    }

    private void switchChunk() {
        if (this.activeChunk == null || this.activeChunk.numRows() == 0) {
            return;
        }
        this.inactiveChunks.add(this.activeChunk);
        this.activeChunk = new Chunk(this.properties.getDataFormat());
    }

    protected int write0(byte[] row) {
        if (this.activeChunk.estimateChunkSize(row) > this.properties.getChunkLimit() || this.activeChunk.numRows() >= this.properties.getMaxBufferRows()) {
            this.switchChunk();
        }
        this.activeChunk.addRow(row);
        this.cacheBytes.addAndGet(row.length);
        this.cacheRows.incrementAndGet();
        return row.length;
    }

    @Override
    public boolean isFlushing() {
        return this.state.get() == State.FLUSHING;
    }

    public FlushReason shouldFlush() {
        if (this.state.get() != State.ACTIVE) {
            return FlushReason.NONE;
        }
        return this.cacheRows.get() >= (long)this.properties.getMaxBufferRows() ? FlushReason.BUFFER_ROWS_REACH_LIMIT : FlushReason.NONE;
    }

    public boolean flush(FlushReason reason) {
        if (this.state.compareAndSet(State.ACTIVE, State.FLUSHING)) {
            while (!this.ctl.compareAndSet(false, true)) {
            }
            LOG.info("Flush uniqueKey : {}, label : {}, bytes : {}, rows: {}, reason: {}", new Object[]{this.uniqueKey, this.label, this.cacheBytes.get(), this.cacheRows.get(), reason});
            if (reason != FlushReason.BUFFER_ROWS_REACH_LIMIT || this.activeChunk.numRows() >= this.properties.getMaxBufferRows()) {
                this.switchChunk();
            }
            this.ctl.set(false);
            if (!this.inactiveChunks.isEmpty()) {
                this.streamLoad(0);
                return true;
            }
            this.state.compareAndSet(State.FLUSHING, State.ACTIVE);
            return false;
        }
        return false;
    }

    public boolean commit() {
        boolean commitSuccess;
        if (!this.state.compareAndSet(State.ACTIVE, State.COMMITTING)) {
            return false;
        }
        if (this.label != null) {
            StreamLoadSnapshot.Transaction transaction = new StreamLoadSnapshot.Transaction(this.database, this.table, this.label);
            try {
                if (!this.streamLoader.prepare(transaction)) {
                    String errorMsg = "Failed to prepare transaction, please check taskmanager log for details, " + transaction;
                    throw new StreamLoadFailException(errorMsg);
                }
                if (!this.streamLoader.commit(transaction)) {
                    String errorMsg = "Failed to commit transaction, please check taskmanager log for details, " + transaction;
                    throw new StreamLoadFailException(errorMsg);
                }
            }
            catch (Exception e) {
                LOG.error("TransactionTableRegion commit failed, db: {}, table: {}, label: {}", new Object[]{this.database, this.table, this.label, e});
                this.fail(e);
                return false;
            }
            this.label = null;
            long commitTime = System.currentTimeMillis();
            long commitDuration = commitTime - this.lastCommitTimeMills;
            this.lastCommitTimeMills = commitTime;
            commitSuccess = true;
            LOG.info("Success to commit transaction: {}, duration: {} ms", (Object)transaction, (Object)commitDuration);
        } else {
            commitSuccess = this.cacheBytes.get() == 0L;
        }
        this.state.compareAndSet(State.COMMITTING, State.ACTIVE);
        return commitSuccess;
    }

    @Override
    public void fail(Throwable e) {
        if (this.firstException == null) {
            this.firstException = e;
        }
        if (this.numRetries >= this.maxRetries || !ErrorUtils.isRetryable(e)) {
            LOG.error("Failed to flush data for db: {}, table: {} after {} times retry, the last exception is", new Object[]{this.database, this.table, this.numRetries, e});
            this.manager.callback(this.firstException);
            return;
        }
        this.responseFuture = null;
        ++this.numRetries;
        this.lastFailTimeMs = System.currentTimeMillis();
        LOG.warn("Failed to flush data for db: {}, table: {}, and will retry for {} times after {} ms", new Object[]{this.database, this.table, this.numRetries, this.retryIntervalInMs, e});
        this.streamLoad(this.retryIntervalInMs);
    }

    @Override
    public void complete(StreamLoadResponse response) {
        Chunk chunk = (Chunk)this.inactiveChunks.remove();
        this.cacheBytes.addAndGet(-chunk.rowBytes());
        this.cacheRows.addAndGet(-chunk.numRows());
        response.setFlushBytes(chunk.rowBytes());
        response.setFlushRows(chunk.numRows());
        this.manager.callback(response);
        this.numRetries = 0;
        this.firstException = null;
        LOG.info("Stream load flushed, db: {}, table: {}, label : {}", new Object[]{this.database, this.table, this.label});
        if (!this.inactiveChunks.isEmpty()) {
            LOG.info("Stream load continue, db: {}, table: {}, label : {}", new Object[]{this.database, this.table, this.label});
            this.streamLoad(0);
            return;
        }
        if (this.state.compareAndSet(State.FLUSHING, State.ACTIVE)) {
            LOG.info("Stream load completed, db: {}, table: {}, label : {}", new Object[]{this.database, this.table, this.label});
        }
    }

    @Override
    public Future<?> getResult() {
        return this.responseFuture;
    }

    protected void streamLoad(int delayMs) {
        try {
            Chunk chunk = this.inactiveChunks.peek();
            LOG.info("Stream load chunk, db: {}, table: {}, numRows: {}, rowBytes: {}, chunkBytes: {}", new Object[]{this.database, this.table, chunk.numRows(), chunk.rowBytes(), chunk.chunkBytes()});
            this.responseFuture = this.streamLoader.send(this, delayMs);
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    @Override
    public HttpEntity getHttpEntity() {
        return new ChunkHttpEntity(this.uniqueKey, this.inactiveChunks.peek());
    }

    @Override
    public long getLastWriteTimeMillis() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setResult(Future<?> result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void callback(StreamLoadResponse response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFlushBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] read() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StreamLoadEntityMeta getEntityMeta() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean testPrepare() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean prepare() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean cancel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean flush() {
        throw new UnsupportedOperationException();
    }

    static enum State {
        ACTIVE,
        FLUSHING,
        COMMITTING;

    }
}

