/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.adsbase;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.startapp.b1;
import com.startapp.j;
import com.startapp.sdk.adsbase.ActivityExtra;
import com.startapp.sdk.adsbase.SimpleTokenUtils;
import com.startapp.sdk.adsbase.adinformation.AdInformationOverrides;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;
import com.startapp.sdk.adsbase.adlisteners.NotDisplayedReason;
import com.startapp.sdk.adsbase.cache.CacheMetaData;
import com.startapp.sdk.adsbase.consent.ConsentData;
import com.startapp.sdk.adsbase.model.AdPreferences;
import com.startapp.sdk.adsbase.remoteconfig.MetaData;
import com.startapp.sdk.adsbase.remoteconfig.MetaDataRequest;
import com.startapp.sdk.adsbase.remoteconfig.c;
import com.startapp.sdk.components.ComponentLocator;
import com.startapp.t9;
import com.startapp.wb;
import java.io.Serializable;

public abstract class Ad
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static boolean b = false;
    @NonNull
    public transient Context a;
    public ActivityExtra activityExtra;
    public Serializable extraData;
    private AdInformationOverrides adInfoOverride;
    public AdPreferences.Placement placement;
    public ConsentData consentData;
    @Nullable
    public String errorMessage;
    public Long adCacheTtl;
    private AdState state;
    private NotDisplayedReason notDisplayedReason;
    private Long lastLoadTime;
    private AdType type;
    public boolean belowMinCPM;
    private boolean videoCancelCallBack;

    public Ad(@NonNull Context context, AdPreferences.Placement placement) {
        Ad ad2 = this;
        this.extraData = null;
        this.adCacheTtl = null;
        this.state = AdState.UN_INITIALIZED;
        this.lastLoadTime = null;
        this.belowMinCPM = false;
        this.a = context;
        ad2.placement = placement;
        ad2.adInfoOverride = AdInformationOverrides.a();
    }

    public static void a(Ad ad2, Long l10) {
        ad2.lastLoadTime = l10;
    }

    public Serializable getExtraData() {
        return this.extraData;
    }

    @NonNull
    public Context getContext() {
        return this.a;
    }

    public void setContext(@NonNull Context context) {
        this.a = context;
    }

    public void setActivityExtra(ActivityExtra activityExtra) {
        this.activityExtra = activityExtra;
    }

    public void setExtraData(Serializable serializable) {
        this.extraData = serializable;
    }

    public AdState getState() {
        return this.state;
    }

    public boolean isBelowMinCPM() {
        return this.belowMinCPM;
    }

    public void setState(AdState adState) {
        this.state = adState;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(@Nullable String string) {
        this.errorMessage = string;
    }

    public AdInformationOverrides getAdInfoOverride() {
        return this.adInfoOverride;
    }

    public void setAdInfoOverride(AdInformationOverrides adInformationOverrides) {
        this.adInfoOverride = adInformationOverrides;
    }

    @Nullable
    public final ConsentData getConsentData() {
        return this.consentData;
    }

    public AdPreferences.Placement f() {
        return this.placement;
    }

    @Deprecated
    public void load() {
        AdPreferences adPreferences;
        Ad ad2 = serializable;
        Serializable serializable = adPreferences;
        adPreferences = new AdPreferences();
        ad2.load((AdPreferences)serializable, null);
    }

    @Deprecated
    public void load(AdEventListener adEventListener) {
        AdPreferences adPreferences;
        Ad ad2 = serializable;
        Serializable serializable = adPreferences;
        adPreferences = new AdPreferences();
        ad2.load((AdPreferences)serializable, adEventListener);
    }

    @Deprecated
    public void load(AdPreferences adPreferences) {
        this.load(adPreferences, null);
    }

    @Deprecated
    public void load(AdPreferences adPreferences, AdEventListener adEventListener) {
        this.load(adPreferences, adEventListener, true);
    }

    public boolean load(final AdPreferences adPreferences, final AdEventListener adEventListener, boolean bl) {
        c c10;
        AdEventListener adEventListener2;
        final AdEventListener adEventListener3 = adEventListener2;
        adEventListener2 = new AdEventListener(){

            @Override
            public void onReceiveAd(@NonNull Ad ad2) {
                a a10 = this;
                Ad.a(a10.Ad.this, System.currentTimeMillis());
                j.b(a10.Ad.this.a, adEventListener, ad2, false);
                Serializable serializable = ad2.getConsentData();
                if (serializable != null) {
                    ConsentData consentData = serializable;
                    serializable = consentData.f();
                    Long l10 = consentData.e();
                    Boolean bl = consentData.a();
                    ComponentLocator.a(Ad.this.a).f().a((Integer)serializable, l10, bl, false, true);
                }
                wb.a(Ad.this.a, 4, b1.a("Loaded ").append(wb.a(ad2)).append(" ad with creative ID - ").append(ad2.getAdId()).toString(), true);
            }

            @Override
            public void onFailedToReceiveAd(@Nullable Ad object) {
                j.a(a10.Ad.this.a, a10.adEventListener, (Ad)object, false);
                String string = object != null ? ((Ad)object).getErrorMessage() : null;
                if (string == null) {
                    string = "";
                } else if (string.contains("204")) {
                    string = "NO FILL";
                }
                a a10 = a10.Ad.this.a;
                int n10 = 6;
                StringBuilder stringBuilder = b1.a("Failed to load ");
                object = object != null ? wb.a((Ad)object) : "";
                wb.a((Context)a10, n10, stringBuilder.append((String)object).append(" ad: ").append(string).toString(), true);
            }
        };
        if (!b) {
            SimpleTokenUtils.f(this.a);
            b = true;
        }
        boolean bl2 = false;
        String string = "";
        if (this.state != AdState.UN_INITIALIZED) {
            bl2 = true;
            string = "load() was already called.";
        }
        if (!wb.g(this.a)) {
            bl2 = true;
            string = "network not available.";
        }
        if (!MetaData.k.b()) {
            bl2 = true;
            string = "serving ads disabled";
        }
        if (bl2) {
            Ad ad2 = this;
            ad2.setErrorMessage("Ad wasn't loaded: " + string);
            j.a(ad2.a, adEventListener3, this, false);
            return false;
        }
        this.setState(AdState.PROCESSING);
        c c11 = c10;
        c10 = new c(){

            @Override
            public void a(@Nullable MetaDataRequest.RequestReason requestReason, boolean bl) {
                b b10 = adPreferences2;
                AdPreferences adPreferences2 = b10.adPreferences;
                adPreferences2.Ad.this.a(adPreferences2, b10.adEventListener3);
            }

            @Override
            public void a(@Nullable MetaDataRequest.RequestReason requestReason) {
                b b10 = adPreferences2;
                AdPreferences adPreferences2 = b10.adPreferences;
                adPreferences2.Ad.this.a(adPreferences2, b10.adEventListener3);
            }
        };
        if (adPreferences.getType() != null) {
            this.type = adPreferences.getType();
        }
        MetaData.k.a(this.a, adPreferences, t9.d.c, bl, c11, false);
        return true;
    }

    public abstract void a(AdPreferences var1, AdEventListener var2);

    public boolean isReady() {
        return this.state == AdState.READY && !this.d();
    }

    @Deprecated
    public boolean show() {
        return false;
    }

    public NotDisplayedReason getNotDisplayedReason() {
        return this.notDisplayedReason;
    }

    public void a(NotDisplayedReason notDisplayedReason) {
        this.notDisplayedReason = notDisplayedReason;
    }

    public Long c() {
        Ad ad2 = serializable;
        long l10 = ad2.e();
        Serializable serializable = ad2.adCacheTtl;
        if (serializable != null) {
            l10 = Math.min((Long)serializable, l10);
        }
        return l10;
    }

    public long e() {
        return CacheMetaData.a.a().a();
    }

    public Long b() {
        return this.lastLoadTime;
    }

    public boolean d() {
        if (this.lastLoadTime == null) {
            return false;
        }
        return System.currentTimeMillis() - this.lastLoadTime > this.c();
    }

    public AdType getType() {
        return this.type;
    }

    public boolean a() {
        return this.videoCancelCallBack;
    }

    public void a(boolean bl) {
        this.videoCancelCallBack = bl;
    }

    @Nullable
    public abstract String getAdId();

    @Nullable
    public abstract String getBidToken();

    public static final class AdType
    extends Enum<AdType> {
        public static final /* enum */ AdType INTERSTITIAL;
        public static final /* enum */ AdType RICH_TEXT;
        public static final /* enum */ AdType VIDEO;
        public static final /* enum */ AdType REWARDED_VIDEO;
        public static final /* enum */ AdType NON_VIDEO;
        public static final /* enum */ AdType VIDEO_NO_VAST;
        private static final /* synthetic */ AdType[] $VALUES;

        public static AdType[] values() {
            return (AdType[])$VALUES.clone();
        }

        public static AdType valueOf(String string) {
            return Enum.valueOf(AdType.class, string);
        }

        static {
            AdType adType;
            AdType adType2;
            AdType adType3;
            AdType adType4;
            AdType adType5;
            AdType adType6;
            AdType adType7 = adType6;
            INTERSTITIAL = new AdType();
            AdType adType8 = adType5;
            RICH_TEXT = new AdType();
            AdType adType9 = adType4;
            VIDEO = new AdType();
            AdType adType10 = adType3;
            REWARDED_VIDEO = new AdType();
            AdType adType11 = adType2;
            NON_VIDEO = new AdType();
            AdType adType12 = adType;
            VIDEO_NO_VAST = new AdType();
            $VALUES = new AdType[]{adType7, adType8, adType9, adType10, adType11, adType12};
        }
    }

    public static final class AdState
    extends Enum<AdState> {
        public static final /* enum */ AdState UN_INITIALIZED;
        public static final /* enum */ AdState PROCESSING;
        public static final /* enum */ AdState READY;
        private static final /* synthetic */ AdState[] $VALUES;

        public static AdState[] values() {
            return (AdState[])$VALUES.clone();
        }

        public static AdState valueOf(String string) {
            return Enum.valueOf(AdState.class, string);
        }

        static {
            AdState adState;
            AdState adState2;
            AdState adState3;
            AdState adState4 = adState3;
            UN_INITIALIZED = new AdState();
            AdState adState5 = adState2;
            PROCESSING = new AdState();
            AdState adState6 = adState;
            READY = new AdState();
            $VALUES = new AdState[]{adState4, adState5, adState6};
        }
    }
}

