/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.networkTest.startapp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.startapp.a3;
import com.startapp.a5;
import com.startapp.d2;
import com.startapp.h9;
import com.startapp.networkTest.results.ConnectivityTestResult;
import com.startapp.networkTest.results.LatencyResult;
import com.startapp.networkTest.startapp.ConnectivityTestListener;
import com.startapp.networkTest.startapp.CoverageMapperManager;
import com.startapp.r5;
import com.startapp.x2;
import com.startapp.x7;

public final class NetworkTester {
    public static final String LOG_TAG = "NetworkTester";
    private static final String P3WRAPPER_PREFS = "StartappP3WrapperPrefs";
    private static final String CTLT_GUARD_DIFF_KEY = "StartappGuardDiffKey";
    private static final String CTLT_PREV_TIME_CHECK_KEY = "StartappCtLtPrevTimeCheckKey";
    private static final String CTLT_CHECK_INTERVAL_KEY = "StartappCtLtCheckIntervalKey";
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    public static NetworkTester sInstance;
    public ConnectivityTestListener mConnectivityTestListener;
    @Nullable
    public CoverageMapperManager mCoverageMapper;
    public a3 mForegroundTestManager;
    private Context mContext;
    public Thread mActiveThread;

    private NetworkTester() {
    }

    public static void init(Context context, Config object) {
        if (context != null) {
            if (object != null) {
                if ((object = r5.a(object)) != null) {
                    if (sInstance != null) {
                        return;
                    }
                    sInstance = new NetworkTester();
                    new NetworkTester().mContext = context;
                    a5.a(context, ((String)object).getBytes());
                    NetworkTester.sInstance.mCoverageMapper = new CoverageMapperManager(context);
                    if (Build.VERSION.SDK_INT >= 14) {
                        NetworkTester.sInstance.mForegroundTestManager = new a3(context, NetworkTester.sInstance.mCoverageMapper);
                    }
                    return;
                }
                throw new IllegalArgumentException("Wrong format of config");
            }
            throw new IllegalArgumentException("config is null");
        }
        throw new IllegalArgumentException("context is null");
    }

    public static void setOnConnectivityLatencyListener(ConnectivityTestListener connectivityTestListener) {
        NetworkTester networkTester = sInstance;
        if (networkTester != null) {
            networkTester.mConnectivityTestListener = connectivityTestListener;
        }
    }

    public static void setOnNetworkInfoListener(CoverageMapperManager.OnNetworkInfoResultListener onNetworkInfoResultListener) {
        Object object = sInstance;
        if (object != null && (object = ((NetworkTester)object).mCoverageMapper) != null) {
            ((CoverageMapperManager)object).a(onNetworkInfoResultListener);
        }
    }

    public static int isAppInForeground() {
        Object object = sInstance;
        if (object != null && (object = ((NetworkTester)object).mForegroundTestManager) != null) {
            return ((a3)object).d();
        }
        return -1;
    }

    public static void startListening(long l10, long l11) {
        NetworkTester networkTester = sInstance;
        if (networkTester == null) {
            return;
        }
        NetworkTester networkTester2 = networkTester;
        SharedPreferences sharedPreferences = networkTester2.mContext.getSharedPreferences(P3WRAPPER_PREFS, 0);
        sharedPreferences.edit().putLong(CTLT_CHECK_INTERVAL_KEY, l10).commit();
        sharedPreferences.edit().putLong(CTLT_GUARD_DIFF_KEY, l11).commit();
        Object object = networkTester2.mCoverageMapper;
        if (object != null) {
            ((CoverageMapperManager)object).b();
        }
        if ((object = networkTester.mForegroundTestManager) != null) {
            ((a3)object).e();
        }
    }

    public static void stopListening() {
        CoverageMapperManager coverageMapperManager;
        Object object = sInstance;
        if (object != null && (coverageMapperManager = ((NetworkTester)object).mCoverageMapper) != null) {
            coverageMapperManager.e();
        }
        if (object != null && Build.VERSION.SDK_INT >= 14 && (object = ((NetworkTester)object).mForegroundTestManager) != null) {
            ((a3)object).h();
        }
    }

    public static boolean isPermissionGranted(Context context, String string) {
        block4: {
            try {
                if (Build.VERSION.SDK_INT < 23) break block4;
            }
            catch (Throwable throwable) {
                x2.a(throwable);
                return false;
            }
            return context.checkSelfPermission(string) == 0;
        }
        return context.checkCallingOrSelfPermission(string) == 0;
    }

    public static void runTests(Context object, b b10) {
        CoverageMapperManager coverageMapperManager;
        if (sInstance == null) {
            b10.a(false);
            return;
        }
        if (!NetworkTester.isPermissionGranted((Context)object, "android.permission.ACCESS_FINE_LOCATION") && !NetworkTester.isPermissionGranted((Context)object, "android.permission.ACCESS_COARSE_LOCATION")) {
            object = sInstance;
            if (object != null && (object = ((NetworkTester)object).mCoverageMapper) != null) {
                ((CoverageMapperManager)object).e();
            }
            b10.a(false);
            return;
        }
        SharedPreferences sharedPreferences = object.getSharedPreferences(P3WRAPPER_PREFS, 0);
        long l10 = sharedPreferences.getLong(CTLT_GUARD_DIFF_KEY, 120000L);
        long l11 = sharedPreferences.getLong(CTLT_PREV_TIME_CHECK_KEY, 0L);
        long l12 = sharedPreferences.getLong(CTLT_CHECK_INTERVAL_KEY, l10);
        if (System.currentTimeMillis() - l11 < l12 - l10) {
            b10.a(false);
            return;
        }
        if (!a5.h()) {
            b10.a(false);
            return;
        }
        if (NetworkTester.sInstance.mActiveThread != null) {
            b10.a(false);
            return;
        }
        long l13 = System.currentTimeMillis();
        sharedPreferences.edit().putLong(CTLT_PREV_TIME_CHECK_KEY, l13).commit();
        Object object2 = sInstance;
        if (object2 != null && (coverageMapperManager = ((NetworkTester)object2).mCoverageMapper) != null) {
            coverageMapperManager.b();
        }
        if (object2 != null) {
            Runnable runnable;
            h9 h92;
            Thread thread;
            NetworkTester networkTester = object2;
            object2 = thread;
            h9 h93 = h92;
            Runnable runnable2 = runnable;
            runnable = new Runnable((Context)object, b10){
                public final /* synthetic */ Context a;
                public final /* synthetic */ b b;
                {
                    this.a = context;
                    this.b = b10;
                }

                @Override
                public void run() {
                    d2 d22;
                    final boolean[] blArray = new boolean[2];
                    Looper.prepare();
                    final Looper looper = Looper.myLooper();
                    final d2 d23 = d22;
                    new d2(this.a.getApplicationContext()).a();
                    d23.a(new x7(){

                        @Override
                        public void onConnectivityTestResult(ConnectivityTestResult connectivityTestResult) {
                            boolean[] blArray2 = blArray;
                            if (blArray[0]) {
                                connectivityTestResult = looper;
                                if (connectivityTestResult != null) {
                                    NetworkTester.sInstance.mActiveThread = null;
                                    connectivityTestResult.quit();
                                    b.a(false);
                                }
                                return;
                            }
                            blArray2[0] = true;
                            if (connectivityTestResult != null) {
                                boolean cfr_ignored_0 = connectivityTestResult.Success;
                            }
                            if ((this = NetworkTester.sInstance.mConnectivityTestListener) != null) {
                                this.onConnectivityTestResult(connectivityTestResult);
                            }
                        }

                        @Override
                        public void onLatencyTestResult(LatencyResult latencyResult) {
                            boolean[] blArray2 = blArray;
                            if (blArray[1]) {
                                latencyResult = looper;
                                if (latencyResult != null) {
                                    NetworkTester.sInstance.mActiveThread = null;
                                    latencyResult.quit();
                                    b.a(false);
                                }
                                return;
                            }
                            blArray2[1] = true;
                            if (latencyResult != null) {
                                boolean cfr_ignored_0 = latencyResult.Success;
                            }
                            if ((this = NetworkTester.sInstance.mConnectivityTestListener) != null) {
                                this.onLatencyTestResult(latencyResult);
                            }
                        }

                        @Override
                        public void a() {
                            a a10 = this;
                            a10.d23.b();
                            Object object = a10.looper;
                            if (object != null) {
                                NetworkTester.sInstance.mActiveThread = null;
                                object.quit();
                            }
                            if ((object = NetworkTester.sInstance.mConnectivityTestListener) != null) {
                                Runnable runnable;
                                h9 h92;
                                Looper looper2 = object;
                                object = h92;
                                Runnable runnable2 = runnable;
                                runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        b.a(false);
                                    }
                                };
                                h92 = new h9(runnable2);
                                looper2.onConnectivityTestFinished((Runnable)object);
                            } else {
                                b.a(false);
                            }
                        }
                    });
                    Looper.loop();
                }
            };
            h92 = new h9(runnable2);
            thread = new Thread(h93);
            networkTester.mActiveThread = object2;
        }
        NetworkTester.sInstance.mActiveThread.start();
    }

    public static interface b {
        public void a(boolean var1);
    }

    public static final class Config {
        public String PROJECT_ID = "20050";
        public String CONNECTIVITY_TEST_HOSTNAME = "d2to8y50b3n6dq.cloudfront.net";
        public String CONNECTIVITY_TEST_FILENAME = "/favicon.ico";
        public boolean CONNECTIVITY_TEST_ENABLED = true;
        public boolean NIR_COLLECT_CELLINFO = true;
        public boolean CT_COLLECT_CELLINFO = true;
        public int NIR_COLLECT_CELLINFO_THRESHOLD = 2;
        public String CONNECTIVITY_TEST_CDNCONFIG_URL = "https://d2to8y50b3n6dq.cloudfront.net/truststores/[PROJECTID]/cdnconfig.zip";
        public String GEOIP_URL = "https://geoip.api.c0nnectthed0ts.com/geoip/";
        public long FOREGROUND_TEST_CT_SCHEDULE_INTERVAL = 300000L;
        public long FOREGROUND_TEST_CT_MIN_INTERVAL = 180000L;
        public boolean FOREGROUND_TEST_CT_ENABLED = true;
        public boolean FOREGROUND_TEST_NIR_ENABLED = true;
    }
}

