/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.ads.splash;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.Log;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.startapp.i4;
import com.startapp.pb;
import com.startapp.sdk.ads.splash.SplashHtml;
import com.startapp.sdk.ads.splash.SplashMetaData;
import com.startapp.sdk.ads.splash.g;
import com.startapp.sdk.adsbase.a;
import com.startapp.vb;
import java.io.Serializable;
import java.util.Arrays;

public class SplashConfig
implements Serializable {
    private static final long serialVersionUID = 995423687458599030L;
    public static final Theme c = Theme.OCEAN;
    public static final MinSplashTime d = MinSplashTime.REGULAR;
    public static final long e = 7500L;
    public static final MaxAdDisplayTime f = MaxAdDisplayTime.FOR_EVER;
    public static final Orientation g = Orientation.AUTO;
    private boolean forceNative = false;
    private int customScreen = -1;
    private String appName = "";
    public transient Drawable a = null;
    private byte[] logoByteArray = null;
    private int logoRes = -1;
    @pb(type=Theme.class)
    private Theme defaultTheme = c;
    @pb(type=MinSplashTime.class)
    private MinSplashTime defaultMinSplashTime = d;
    private Long defaultMaxLoadTime = e;
    @pb(type=MaxAdDisplayTime.class)
    private MaxAdDisplayTime defaultMaxAdDisplayTime = f;
    @pb(type=Orientation.class)
    private Orientation defaultOrientation = g;
    private boolean htmlSplash = true;
    private String splashBgColor = "#066CAA";
    private String splashFontColor = "ffffff";
    private String splashLoadingType = "LoadingDots";
    public transient String b = "";

    public static SplashConfig getDefaultSplashConfig() {
        SplashConfig splashConfig = new SplashConfig();
        splashConfig.setTheme(c).setMinSplashTime(d).defaultMaxLoadTime = e;
        splashConfig.setTheme(c).setMinSplashTime(d).setMaxAdDisplayTime(f).setOrientation(g).setLoadingType("LoadingDots").setAppName("");
        return splashConfig;
    }

    public SplashConfig setTheme(Theme theme) {
        this.defaultTheme = theme;
        return this;
    }

    public SplashConfig setCustomScreen(int n10) {
        this.customScreen = n10;
        return this;
    }

    public SplashConfig setAppName(String string) {
        this.appName = string;
        return this;
    }

    public SplashConfig setLogo(int n10) {
        this.logoRes = n10;
        return this;
    }

    public SplashConfig setLogo(byte[] byArray) {
        this.logoByteArray = byArray;
        return this;
    }

    public SplashConfig setOrientation(Orientation orientation) {
        this.defaultOrientation = orientation;
        return this;
    }

    public SplashConfig setMinSplashTime(MinSplashTime minSplashTime) {
        this.defaultMinSplashTime = minSplashTime;
        return this;
    }

    public SplashConfig setMaxAdDisplayTime(MaxAdDisplayTime maxAdDisplayTime) {
        this.defaultMaxAdDisplayTime = maxAdDisplayTime;
        return this;
    }

    public int getCustomScreen() {
        return this.customScreen;
    }

    public String getAppName() {
        return this.appName;
    }

    public Drawable getLogo() {
        return this.a;
    }

    public int getLogoRes() {
        return this.logoRes;
    }

    public byte[] getLogoByteArray() {
        return this.logoByteArray;
    }

    public Long a() {
        return this.defaultMaxLoadTime;
    }

    public String getErrorMessage() {
        return this.b;
    }

    public Orientation getOrientation() {
        return this.defaultOrientation;
    }

    public MinSplashTime getMinSplashTime() {
        return this.defaultMinSplashTime;
    }

    public MaxAdDisplayTime getMaxAdDisplayTime() {
        return this.defaultMaxAdDisplayTime;
    }

    public boolean isHtmlSplash() {
        if (this.forceNative) {
            return false;
        }
        return this.htmlSplash;
    }

    public String getBgColor() {
        return this.splashBgColor;
    }

    public String getFontColor() {
        return this.splashFontColor;
    }

    public String getLoadingType() {
        return this.splashLoadingType;
    }

    public SplashConfig setLoadingType(String string) {
        this.splashLoadingType = string;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public boolean b(Context var1_1) {
        block6: {
            block7: {
                var2_2 = true;
                if (1.$SwitchMap$com$startapp$sdk$ads$splash$SplashConfig$Theme[this.defaultTheme.ordinal()] == 7) break block7;
                if (this.getAppName().equals("")) {
                    this.setAppName(com.startapp.sdk.adsbase.a.a(var1_1, "Welcome!"));
                }
                if (this.getLogo() != null || this.getLogoByteArray() != null) break block6;
                if (this.getLogoRes() != -1) ** GOTO lbl17
                v0 = this;
                v1 = var1_1;
                this.setLogo(var1_1.getApplicationInfo().icon);
                try {
                    v0.a = v1.getResources().getDrawable(var1_1.getApplicationInfo().icon);
                    break block6;
lbl17:
                    // 1 sources

                    this.a = var1_1.getResources().getDrawable(this.getLogoRes());
                }
                catch (Throwable v2) {
                    i4.a(v2);
                }
                break block6;
            }
            if (this.getCustomScreen() == -1) {
                var2_2 = false;
                this.b = "StartApp: Exception getting custom screen resource id, make sure it is set";
            }
        }
        return var2_2;
    }

    public View a(Context context) {
        View view = null;
        Theme theme = this.defaultTheme;
        if (theme == Theme.USER_DEFINED) {
            try {
                view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(this.getCustomScreen(), null);
            }
            catch (Throwable throwable) {
                i4.a(throwable);
            }
            catch (InflateException inflateException) {
                Log.w((String)"StartAppSDK", (Throwable)inflateException);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"StartAppSDK", (Throwable)notFoundException);
            }
        } else {
            view = null;
            switch (g.a.a[theme.ordinal()]) {
                default: {
                    break;
                }
                case 6: {
                    view = com.startapp.sdk.ads.splash.g.a(context, this);
                    view.setBackgroundDrawable((Drawable)new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-14451558, -7876130}));
                    ((TextView)view.findViewById(100)).setTextColor(Color.rgb((int)6, (int)61, (int)82));
                    ((TextView)view.findViewById(105)).setTextColor(Color.rgb((int)6, (int)61, (int)82));
                    break;
                }
                case 5: {
                    view = com.startapp.sdk.ads.splash.g.a(context, this);
                    view.setBackgroundColor(Color.rgb((int)47, (int)53, (int)63));
                    ((TextView)view.findViewById(100)).setTextColor(Color.rgb((int)51, (int)181, (int)229));
                    ((TextView)view.findViewById(105)).setTextColor(Color.rgb((int)122, (int)130, (int)139));
                    break;
                }
                case 4: {
                    view = com.startapp.sdk.ads.splash.g.a(context, this);
                    int n10 = context.getResources().getDisplayMetrics().widthPixels;
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BL_TR, new int[]{-92376, -40960});
                    gradientDrawable.setGradientType(1);
                    gradientDrawable.setGradientRadius((float)(n10 / 2));
                    view.setBackgroundDrawable((Drawable)gradientDrawable);
                    ((TextView)view.findViewById(100)).setTextColor(Color.rgb((int)255, (int)255, (int)255));
                    ((TextView)view.findViewById(105)).setTextColor(Color.rgb((int)255, (int)198, (int)151));
                    break;
                }
                case 3: {
                    view = com.startapp.sdk.ads.splash.g.a(context, this);
                    view.setBackgroundDrawable((Drawable)new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-3881788, -1}));
                    ((TextView)view.findViewById(100)).setTextColor(Color.rgb((int)51, (int)51, (int)51));
                    ((TextView)view.findViewById(105)).setTextColor(Color.rgb((int)153, (int)153, (int)153));
                    break;
                }
                case 2: {
                    view = com.startapp.sdk.ads.splash.g.a(context, this);
                    int n11 = context.getResources().getDisplayMetrics().widthPixels;
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BL_TR, new int[]{-921103, -6040347});
                    gradientDrawable.setGradientType(1);
                    gradientDrawable.setGradientRadius((float)(n11 / 2));
                    view.setBackgroundDrawable((Drawable)gradientDrawable);
                    ((TextView)view.findViewById(100)).setTextColor(Color.rgb((int)51, (int)51, (int)51));
                    ((TextView)view.findViewById(105)).setTextColor(Color.rgb((int)162, (int)172, (int)175));
                    break;
                }
                case 1: {
                    view = com.startapp.sdk.ads.splash.g.a(context, this);
                    view.setBackgroundDrawable((Drawable)new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-16356182, -15029533, -16356182}));
                    ((TextView)view.findViewById(100)).setTextColor(Color.rgb((int)255, (int)255, (int)255));
                    ((TextView)view.findViewById(105)).setTextColor(Color.rgb((int)208, (int)210, (int)210));
                }
            }
        }
        return view;
    }

    public void setDefaults(Context context) {
        SplashConfig splashConfig = SplashMetaData.a.a();
        if (splashConfig == null) {
            splashConfig = SplashConfig.getDefaultSplashConfig();
        } else {
            this.htmlSplash = splashConfig.isHtmlSplash();
        }
        SplashConfig splashConfig2 = SplashConfig.getDefaultSplashConfig();
        if (splashConfig.defaultTheme == null) {
            splashConfig.setTheme(splashConfig2.defaultTheme);
        }
        if (splashConfig.getMinSplashTime() == null) {
            splashConfig.setMinSplashTime(splashConfig2.getMinSplashTime());
        }
        if (splashConfig.defaultMaxLoadTime == null) {
            splashConfig.defaultMaxLoadTime = (long)splashConfig2.defaultMaxLoadTime;
        }
        if (splashConfig.getMaxAdDisplayTime() == null) {
            splashConfig.setMaxAdDisplayTime(splashConfig2.getMaxAdDisplayTime());
        }
        if (splashConfig.getOrientation() == null) {
            splashConfig.setOrientation(splashConfig2.getOrientation());
        }
        if (splashConfig.getLoadingType() == null) {
            splashConfig.setLoadingType(splashConfig2.getLoadingType());
        }
        if (splashConfig.getAppName().equals("")) {
            splashConfig.setAppName(com.startapp.sdk.adsbase.a.a(context, "Welcome!"));
        }
        if (this.getMaxAdDisplayTime() == null) {
            this.setMaxAdDisplayTime(splashConfig.getMaxAdDisplayTime());
        }
        if (this.defaultMaxLoadTime == null) {
            this.defaultMaxLoadTime = (long)splashConfig.defaultMaxLoadTime;
        }
        if (this.getMinSplashTime() == null) {
            this.setMinSplashTime(splashConfig.getMinSplashTime());
        }
        if (this.getOrientation() == null) {
            this.setOrientation(splashConfig.getOrientation());
        }
        if (this.defaultTheme == null) {
            this.setTheme(splashConfig.defaultTheme);
        }
        if (this.getLogoRes() == -1 && (context = context.getApplicationInfo()) != null) {
            this.setLogo(context.icon);
        }
        if (this.getAppName().equals("")) {
            this.setAppName(splashConfig.getAppName());
        }
    }

    public SplashHtml a(Activity activity) {
        String string = "#066CAA";
        String string2 = "ffffff";
        switch (1.$SwitchMap$com$startapp$sdk$ads$splash$SplashConfig$Theme[this.defaultTheme.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                string2 = "#063D51";
                string = "#237C9A";
                break;
            }
            case 5: {
                string2 = "#33B5E5";
                string = "#2F353F";
                break;
            }
            case 4: {
                string2 = "#FFFFFF";
                string = "#FF6600";
                break;
            }
            case 3: {
                string2 = "#333333";
                string = "#E3E3E3";
                break;
            }
            case 2: {
                string2 = "#333333";
                string = "#a3d4e5";
                break;
            }
            case 1: {
                string2 = "#FFFFFF";
                string = "#066CAA";
            }
        }
        this.splashBgColor = string;
        this.splashFontColor = string2;
        SplashHtml splashHtml = new SplashHtml(activity);
        splashHtml.a(this);
        splashHtml.d();
        return splashHtml;
    }

    public boolean b() {
        return this.defaultTheme == Theme.USER_DEFINED || this.getCustomScreen() != -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (SplashConfig)object;
            return this.forceNative == ((SplashConfig)object).forceNative && this.customScreen == ((SplashConfig)object).customScreen && this.logoRes == ((SplashConfig)object).logoRes && this.htmlSplash == ((SplashConfig)object).htmlSplash && vb.a(this.appName, ((SplashConfig)object).appName) && Arrays.equals(this.logoByteArray, ((SplashConfig)object).logoByteArray) && this.defaultTheme == ((SplashConfig)object).defaultTheme && this.defaultMinSplashTime == ((SplashConfig)object).defaultMinSplashTime && vb.a(this.defaultMaxLoadTime, ((SplashConfig)object).defaultMaxLoadTime) && this.defaultMaxAdDisplayTime == ((SplashConfig)object).defaultMaxAdDisplayTime && this.defaultOrientation == ((SplashConfig)object).defaultOrientation && vb.a(this.splashBgColor, ((SplashConfig)object).splashBgColor) && vb.a(this.splashFontColor, ((SplashConfig)object).splashFontColor) && vb.a(this.splashLoadingType, ((SplashConfig)object).splashLoadingType);
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[13];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.forceNative;
        objectArray2[1] = this.customScreen;
        objectArray2[2] = this.appName;
        objectArray2[3] = this.logoRes;
        objectArray2[4] = this.defaultTheme;
        objectArray2[5] = this.defaultMinSplashTime;
        objectArray2[6] = this.defaultMaxLoadTime;
        objectArray2[7] = this.defaultMaxAdDisplayTime;
        objectArray2[8] = this.defaultOrientation;
        objectArray2[9] = this.htmlSplash;
        objectArray2[10] = this.splashBgColor;
        objectArray2[11] = this.splashFontColor;
        objectArray[12] = this.splashLoadingType;
        int n10 = Arrays.deepHashCode(objectArray) * 31;
        return Arrays.hashCode(this.logoByteArray) + n10;
    }

    public static final class Theme
    extends Enum<Theme> {
        public static final /* enum */ Theme DEEP_BLUE;
        public static final /* enum */ Theme SKY;
        public static final /* enum */ Theme ASHEN_SKY;
        public static final /* enum */ Theme BLAZE;
        public static final /* enum */ Theme GLOOMY;
        public static final /* enum */ Theme OCEAN;
        public static final /* enum */ Theme USER_DEFINED;
        private static final /* synthetic */ Theme[] $VALUES;
        private int index;

        public static Theme[] values() {
            return (Theme[])$VALUES.clone();
        }

        public static Theme valueOf(String string) {
            return Enum.valueOf(Theme.class, string);
        }

        private Theme(int n11) {
            this.index = n11;
        }

        public static Theme getByIndex(int n10) {
            Theme theme = DEEP_BLUE;
            Theme[] themeArray = Theme.values();
            for (int i10 = 0; i10 < themeArray.length; ++i10) {
                if (themeArray[i10].getIndex() != n10) continue;
                theme = themeArray[i10];
            }
            return theme;
        }

        public static Theme getByName(String string) {
            Theme theme = DEEP_BLUE;
            Theme[] themeArray = Theme.values();
            for (int i10 = 0; i10 < themeArray.length; ++i10) {
                if (themeArray[i10].name().toLowerCase().compareTo(string.toLowerCase()) != 0) continue;
                theme = themeArray[i10];
            }
            return theme;
        }

        static {
            Theme theme;
            Theme theme2;
            Theme theme3;
            Theme theme4;
            Theme theme5;
            Theme theme6;
            Theme theme7;
            Theme theme8 = theme7;
            DEEP_BLUE = new Theme(1);
            Theme theme9 = theme6;
            SKY = new Theme(2);
            Theme theme10 = theme5;
            ASHEN_SKY = new Theme(3);
            Theme theme11 = theme4;
            BLAZE = new Theme(4);
            Theme theme12 = theme3;
            GLOOMY = new Theme(5);
            Theme theme13 = theme2;
            OCEAN = new Theme(6);
            Theme theme14 = theme;
            USER_DEFINED = new Theme(0);
            $VALUES = new Theme[]{theme8, theme9, theme10, theme11, theme12, theme13, theme14};
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation PORTRAIT;
        public static final /* enum */ Orientation LANDSCAPE;
        public static final /* enum */ Orientation AUTO;
        private static final /* synthetic */ Orientation[] $VALUES;
        private int index;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }

        private Orientation(int n11) {
            this.index = n11;
        }

        public static Orientation getByIndex(int n10) {
            Orientation orientation = PORTRAIT;
            Orientation[] orientationArray = Orientation.values();
            for (int i10 = 0; i10 < orientationArray.length; ++i10) {
                if (orientationArray[i10].getIndex() != n10) continue;
                orientation = orientationArray[i10];
            }
            return orientation;
        }

        public static Orientation getByName(String string) {
            Orientation orientation = AUTO;
            Orientation[] orientationArray = Orientation.values();
            for (int i10 = 0; i10 < orientationArray.length; ++i10) {
                if (orientationArray[i10].name().toLowerCase().compareTo(string.toLowerCase()) != 0) continue;
                orientation = orientationArray[i10];
            }
            return orientation;
        }

        static {
            Orientation orientation;
            Orientation orientation2;
            Orientation orientation3;
            Orientation orientation4 = orientation3;
            PORTRAIT = new Orientation(1);
            Orientation orientation5 = orientation2;
            LANDSCAPE = new Orientation(2);
            Orientation orientation6 = orientation;
            AUTO = new Orientation(3);
            $VALUES = new Orientation[]{orientation4, orientation5, orientation6};
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static final class MinSplashTime
    extends Enum<MinSplashTime> {
        public static final /* enum */ MinSplashTime REGULAR;
        public static final /* enum */ MinSplashTime SHORT;
        public static final /* enum */ MinSplashTime LONG;
        private static final /* synthetic */ MinSplashTime[] $VALUES;
        private long index;

        public static MinSplashTime[] values() {
            return (MinSplashTime[])$VALUES.clone();
        }

        public static MinSplashTime valueOf(String string) {
            return Enum.valueOf(MinSplashTime.class, string);
        }

        private MinSplashTime(int n11) {
            this.index = n11;
        }

        public static MinSplashTime getByIndex(long l10) {
            MinSplashTime minSplashTime = SHORT;
            MinSplashTime[] minSplashTimeArray = MinSplashTime.values();
            for (int i10 = 0; i10 < minSplashTimeArray.length; ++i10) {
                if (minSplashTimeArray[i10].getIndex() != l10) continue;
                minSplashTime = minSplashTimeArray[i10];
            }
            return minSplashTime;
        }

        public static MinSplashTime getByName(String string) {
            MinSplashTime minSplashTime = LONG;
            MinSplashTime[] minSplashTimeArray = MinSplashTime.values();
            for (int i10 = 0; i10 < minSplashTimeArray.length; ++i10) {
                if (minSplashTimeArray[i10].name().toLowerCase().compareTo(string.toLowerCase()) != 0) continue;
                minSplashTime = minSplashTimeArray[i10];
            }
            return minSplashTime;
        }

        static {
            MinSplashTime minSplashTime;
            MinSplashTime minSplashTime2;
            MinSplashTime minSplashTime3;
            MinSplashTime minSplashTime4 = minSplashTime3;
            REGULAR = new MinSplashTime(3000);
            MinSplashTime minSplashTime5 = minSplashTime2;
            SHORT = new MinSplashTime(2000);
            MinSplashTime minSplashTime6 = minSplashTime;
            LONG = new MinSplashTime(5000);
            $VALUES = new MinSplashTime[]{minSplashTime4, minSplashTime5, minSplashTime6};
        }

        public long getIndex() {
            return this.index;
        }
    }

    public static final class MaxAdDisplayTime
    extends Enum<MaxAdDisplayTime> {
        public static final /* enum */ MaxAdDisplayTime SHORT;
        public static final /* enum */ MaxAdDisplayTime LONG;
        public static final /* enum */ MaxAdDisplayTime FOR_EVER;
        private static final /* synthetic */ MaxAdDisplayTime[] $VALUES;
        private long index;

        public static MaxAdDisplayTime[] values() {
            return (MaxAdDisplayTime[])$VALUES.clone();
        }

        public static MaxAdDisplayTime valueOf(String string) {
            return Enum.valueOf(MaxAdDisplayTime.class, string);
        }

        private MaxAdDisplayTime(long l10) {
            this.index = l10;
        }

        public static MaxAdDisplayTime getByIndex(long l10) {
            MaxAdDisplayTime maxAdDisplayTime = SHORT;
            MaxAdDisplayTime[] maxAdDisplayTimeArray = MaxAdDisplayTime.values();
            for (int i10 = 0; i10 < maxAdDisplayTimeArray.length; ++i10) {
                if (maxAdDisplayTimeArray[i10].getIndex() != l10) continue;
                maxAdDisplayTime = maxAdDisplayTimeArray[i10];
            }
            return maxAdDisplayTime;
        }

        public static MaxAdDisplayTime getByName(String string) {
            MaxAdDisplayTime maxAdDisplayTime = FOR_EVER;
            MaxAdDisplayTime[] maxAdDisplayTimeArray = MaxAdDisplayTime.values();
            for (int i10 = 0; i10 < maxAdDisplayTimeArray.length; ++i10) {
                if (maxAdDisplayTimeArray[i10].name().toLowerCase().compareTo(string.toLowerCase()) != 0) continue;
                maxAdDisplayTime = maxAdDisplayTimeArray[i10];
            }
            return maxAdDisplayTime;
        }

        static {
            MaxAdDisplayTime maxAdDisplayTime;
            MaxAdDisplayTime maxAdDisplayTime2;
            MaxAdDisplayTime maxAdDisplayTime3;
            MaxAdDisplayTime maxAdDisplayTime4 = maxAdDisplayTime3;
            SHORT = new MaxAdDisplayTime(5000L);
            MaxAdDisplayTime maxAdDisplayTime5 = maxAdDisplayTime2;
            LONG = new MaxAdDisplayTime(10000L);
            MaxAdDisplayTime maxAdDisplayTime6 = maxAdDisplayTime;
            FOR_EVER = new MaxAdDisplayTime(86400000L);
            $VALUES = new MaxAdDisplayTime[]{maxAdDisplayTime4, maxAdDisplayTime5, maxAdDisplayTime6};
        }

        public long getIndex() {
            return this.index;
        }
    }
}

