/*
 * Decompiled with CFR 0.152.
 */
package com.statemachinesystems.util;

import java.util.function.Supplier;

public class DynamicReference<T> {
    private final InheritableThreadLocal<T> threadLocal;

    public DynamicReference(final T initialValue) {
        this.threadLocal = new InheritableThreadLocal<T>(){

            @Override
            protected T initialValue() {
                return initialValue;
            }
        };
    }

    public T get() {
        return this.threadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withValue(T newValue, Runnable block) {
        Object oldValue = this.threadLocal.get();
        this.threadLocal.set(newValue);
        try {
            block.run();
        }
        finally {
            this.threadLocal.set(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R withValue(T newValue, Supplier<R> block) {
        Object oldValue = this.threadLocal.get();
        this.threadLocal.set(newValue);
        try {
            R r = block.get();
            return r;
        }
        finally {
            this.threadLocal.set(oldValue);
        }
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

