/*
 * Decompiled with CFR 0.152.
 */
package ip3country;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lip3country/CountryLookup;", "", "()V", "Companion", "ip3country-kotlin"})
public final class CountryLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> countryCodes = new ArrayList();
    @NotNull
    private static final List<Long> ipRanges = new ArrayList();
    @NotNull
    private static final List<String> countryTable = new ArrayList();
    private static boolean initialized;
    @NotNull
    private static final Object lock;

    @JvmStatic
    public static final void initialize() {
        Companion.initialize();
    }

    @JvmStatic
    @Nullable
    public static final String lookupIPString(@NotNull String ipAddressString) {
        return Companion.lookupIPString(ipAddressString);
    }

    @JvmStatic
    @Nullable
    public static final String lookupIPNumber(long ipNumber) {
        return Companion.lookupIPNumber(ipNumber);
    }

    static {
        lock = new Object();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lip3country/CountryLookup$Companion;", "", "()V", "countryCodes", "", "", "getCountryCodes", "()Ljava/util/List;", "countryTable", "initialized", "", "ipRanges", "", "getIpRanges", "lock", "binarySearch", "", "ipNumber", "initialize", "", "initializeWithBytes", "bytes", "", "lookupIPNumber", "lookupIPString", "ipAddressString", "ip3country-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getCountryCodes() {
            return countryCodes;
        }

        @NotNull
        public final List<Long> getIpRanges() {
            return ipRanges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void initialize() {
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                if (initialized) {
                    return;
                }
                URL uRL = CountryLookup.class.getClassLoader().getResource("ip_supalite.table");
                Object object2 = uRL == null ? null : TextStreamsKt.readBytes((URL)uRL);
                if (object2 == null) {
                    return;
                }
                byte[] bytes = object2;
                Companion.initializeWithBytes(bytes);
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmStatic
        @Nullable
        public final String lookupIPString(@NotNull String ipAddressString) {
            Intrinsics.checkNotNullParameter((Object)ipAddressString, (String)"ipAddressString");
            this.initialize();
            if (((CharSequence)ipAddressString).length() == 0) {
                return null;
            }
            Object object = new String[]{"."};
            List components = StringsKt.split$default((CharSequence)ipAddressString, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (components.size() != 4) {
                return null;
            }
            try {
                long ipNumber = Long.parseLong((String)components.get(0)) * (long)0x1000000 + Long.parseLong((String)components.get(1)) * (long)65536 + Long.parseLong((String)components.get(2)) * (long)256 + Long.parseLong((String)components.get(3));
                object = this.lookupIPNumber(ipNumber);
            }
            catch (Exception _e) {
                object = null;
            }
            return object;
        }

        @JvmStatic
        @Nullable
        public final String lookupIPNumber(long ipNumber) {
            this.initialize();
            int index = this.binarySearch(ipNumber);
            String cc = this.getCountryCodes().get(index);
            if (Intrinsics.areEqual((Object)cc, (Object)"--")) {
                return null;
            }
            return cc;
        }

        private final void initializeWithBytes(byte[] bytes) {
            int index = 0;
            while (index < bytes.length) {
                int n = index;
                index = n + 1;
                byte c1 = bytes[n];
                int n2 = index;
                index = n2 + 1;
                byte c2 = bytes[n2];
                byte[] byArray = new byte[]{c1, c2};
                countryTable.add(new String(byArray, Charsets.UTF_8));
                if (c1 != 42) continue;
            }
            long lastEndRange = 0L;
            while (index < bytes.length) {
                int n3;
                int n;
                int n2;
                int n4;
                long count = 0L;
                int n5 = index;
                index = n5 + 1;
                int n1 = bytes[n5] & 0xFF;
                if (n1 < 240) {
                    count = n1;
                } else if (n1 == 242) {
                    n4 = index;
                    index = n4 + 1;
                    n2 = bytes[n4] & 0xFF;
                    n = index;
                    index = n + 1;
                    n3 = bytes[n] & 0xFF;
                    count = n2 | n3 << 8;
                } else if (n1 == 243) {
                    n3 = index;
                    index = n3 + 1;
                    n2 = bytes[n3] & 0xFF;
                    n = index;
                    index = n + 1;
                    n3 = bytes[n] & 0xFF;
                    int n6 = index;
                    index = n6 + 1;
                    int n42 = bytes[n6] & 0xFF;
                    count = n2 | n3 << 8 | n42 << 16;
                }
                n4 = index;
                index = n4 + 1;
                int cc = bytes[n4] & 0xFF;
                this.getIpRanges().add(lastEndRange += count * (long)256);
                this.getCountryCodes().add((String)countryTable.get(cc));
            }
            initialized = true;
        }

        private final int binarySearch(long ipNumber) {
            int min = 0;
            int max = this.getIpRanges().size() - 1;
            while (min < max) {
                int mid = min + max >> 1;
                if (((Number)this.getIpRanges().get(mid)).longValue() <= ipNumber) {
                    min = mid + 1;
                    continue;
                }
                max = mid;
            }
            return min;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

