/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;

public class StiAdvancedBorder
extends StiBorder {
    private StiBorderSide leftSide;
    private StiBorderSide rightSide;
    private StiBorderSide topSide;
    private StiBorderSide bottomSide;

    public StiAdvancedBorder() {
        this(new StiBorderSide(), new StiBorderSide(), new StiBorderSide(), new StiBorderSide(), false, 4.0, (StiBrush)new StiSolidBrush(StiColor.Black));
    }

    public StiAdvancedBorder(StiColor topSideColor, double topSideSize, StiPenStyle topSideStyle, StiColor bottomSideColor, double bottomSideSize, StiPenStyle bottomSideStyle, StiColor leftSideColor, double leftSideSize, StiPenStyle leftSideStyle, StiColor rightSideColor, double rightSideSize, StiPenStyle rightSideStyle, boolean dropShadow, double shadowSize, StiBrush shadowBrush) {
        this(new StiBorderSide(topSideColor, topSideSize, topSideStyle), new StiBorderSide(bottomSideColor, bottomSideSize, bottomSideStyle), new StiBorderSide(leftSideColor, leftSideSize, leftSideStyle), new StiBorderSide(rightSideColor, rightSideSize, rightSideStyle), dropShadow, shadowSize, shadowBrush);
    }

    public StiAdvancedBorder(StiColor topSideColor, double topSideSize, StiPenStyle topSideStyle, StiColor bottomSideColor, double bottomSideSize, StiPenStyle bottomSideStyle, StiColor leftSideColor, double leftSideSize, StiPenStyle leftSideStyle, StiColor rightSideColor, double rightSideSize, StiPenStyle rightSideStyle, boolean dropShadow, double shadowSize, StiBrush shadowBrush, boolean topmost) {
        this(new StiBorderSide(topSideColor, topSideSize, topSideStyle), new StiBorderSide(bottomSideColor, bottomSideSize, bottomSideStyle), new StiBorderSide(leftSideColor, leftSideSize, leftSideStyle), new StiBorderSide(rightSideColor, rightSideSize, rightSideStyle), dropShadow, shadowSize, shadowBrush, topmost);
    }

    public StiAdvancedBorder(StiBorderSide topSide, StiBorderSide bottomSide, StiBorderSide leftSide, StiBorderSide rightSide, boolean dropShadow, double shadowSize, StiBrush shadowBrush) {
        this(topSide, bottomSide, leftSide, rightSide, dropShadow, shadowSize, shadowBrush, false);
    }

    public StiAdvancedBorder(StiBorderSide topSide, StiBorderSide bottomSide, StiBorderSide leftSide, StiBorderSide rightSide, boolean dropShadow, double shadowSize, StiBrush shadowBrush, boolean topmost) {
        this.topSide = topSide;
        this.bottomSide = bottomSide;
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.leftSide.side = StiBorderSides.Left;
        this.rightSide.side = StiBorderSides.Right;
        this.topSide.side = StiBorderSides.Top;
        this.bottomSide.side = StiBorderSides.Bottom;
        this.setShadowBrush(shadowBrush);
        this.setShadowSize(shadowSize);
        this.setDropShadow(dropShadow);
        this.setTopmost(topmost);
    }

    @Override
    public Object clone() {
        Object tempVar = super.clone();
        StiAdvancedBorder border = (StiAdvancedBorder)(tempVar instanceof StiAdvancedBorder ? tempVar : null);
        Object tempVar2 = this.topSide.clone();
        border.topSide = (StiBorderSide)(tempVar2 instanceof StiBorderSide ? tempVar2 : null);
        Object tempVar3 = this.bottomSide.clone();
        border.bottomSide = (StiBorderSide)(tempVar3 instanceof StiBorderSide ? tempVar3 : null);
        Object tempVar4 = this.leftSide.clone();
        border.leftSide = (StiBorderSide)(tempVar4 instanceof StiBorderSide ? tempVar4 : null);
        Object tempVar5 = this.rightSide.clone();
        border.rightSide = (StiBorderSide)(tempVar5 instanceof StiBorderSide ? tempVar5 : null);
        return border;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public StiBorderSide getLeftSide() {
        return this.leftSide;
    }

    public StiBorderSide getRightSide() {
        return this.rightSide;
    }

    public StiBorderSide getTopSide() {
        return this.topSide;
    }

    public StiBorderSide getBottomSide() {
        return this.bottomSide;
    }

    @Override
    public boolean isTopBorderSidePresent() {
        return this.getTopSide().getStyle() != StiPenStyle.None;
    }

    @Override
    public boolean isBottomBorderSidePresent() {
        return this.getBottomSide().getStyle() != StiPenStyle.None;
    }

    @Override
    public boolean isLeftBorderSidePresent() {
        return this.getLeftSide().getStyle() != StiPenStyle.None;
    }

    @Override
    public boolean isRightBorderSidePresent() {
        return this.getRightSide().getStyle() != StiPenStyle.None;
    }

    @Override
    public boolean isAllBorderSidesPresent() {
        return this.isLeftBorderSidePresent() && this.isRightBorderSidePresent() && this.isTopBorderSidePresent() && this.isBottomBorderSidePresent();
    }

    @Override
    public StiEnumSet<StiBorderSides> getSide() {
        StiEnumSet<StiBorderSides> result = StiEnumSet.of(StiBorderSides.None);
        if (this.isLeftBorderSidePresent()) {
            result.OR(StiBorderSides.Left);
        }
        if (this.isRightBorderSidePresent()) {
            result.OR(StiBorderSides.Right);
        }
        if (this.isTopBorderSidePresent()) {
            result.OR(StiBorderSides.Top);
        }
        if (this.isBottomBorderSidePresent()) {
            result.OR(StiBorderSides.Bottom);
        }
        return result;
    }

    @Override
    public void setSide(StiBorderSides value) {
        int valueInt = value.intValue;
        if ((valueInt & StiBorderSides.Left.intValue) > 0) {
            if (!this.isLeftBorderSidePresent()) {
                this.getLeftSide().setStyle(StiPenStyle.Solid);
            }
        } else {
            this.getLeftSide().setStyle(StiPenStyle.None);
        }
        if ((valueInt & StiBorderSides.Right.intValue) > 0) {
            if (!this.isRightBorderSidePresent()) {
                this.getRightSide().setStyle(StiPenStyle.Solid);
            }
        } else {
            this.getRightSide().setStyle(StiPenStyle.None);
        }
        if ((valueInt & StiBorderSides.Top.intValue) > 0) {
            if (!this.isTopBorderSidePresent()) {
                this.getTopSide().setStyle(StiPenStyle.Solid);
            }
        } else {
            this.getTopSide().setStyle(StiPenStyle.None);
        }
        if ((valueInt & StiBorderSides.Bottom.intValue) > 0) {
            if (!this.isBottomBorderSidePresent()) {
                this.getBottomSide().setStyle(StiPenStyle.Solid);
            }
        } else {
            this.getBottomSide().setStyle(StiPenStyle.None);
        }
    }

    @Override
    public StiColor getColor() {
        return this.getLeftSide().getColor();
    }

    @Override
    public void setColor(StiColor value) {
        this.getLeftSide().setColor(value);
        this.getRightSide().setColor(value);
        this.getTopSide().setColor(value);
        this.getBottomSide().setColor(value);
    }

    @Override
    public double getSize() {
        return this.getLeftSide().getSize();
    }

    @Override
    public void setSize(double value) {
        this.getLeftSide().setSize(value);
        this.getRightSide().setSize(value);
        this.getTopSide().setSize(value);
        this.getBottomSide().setSize(value);
    }

    @Override
    public StiPenStyle getStyle() {
        return this.getLeftSide().getStyle();
    }

    @Override
    public void setStyle(StiPenStyle value) {
        this.getLeftSide().setStyle(value);
        this.getRightSide().setStyle(value);
        this.getTopSide().setStyle(value);
        this.getBottomSide().setStyle(value);
    }

    @Override
    public boolean isDefault() {
        return !this.getDropShadow() && !this.getTopmost() && this.getShadowSize() == 4.0 && this.getShadowBrush() instanceof StiSolidBrush && ((StiSolidBrush)this.getShadowBrush()).getColor() == StiColor.Black && this.getLeftSide().isDefault() && this.getRightSide().isDefault() && this.getTopSide().isDefault() && this.getBottomSide().isDefault();
    }

    @Override
    public String serialize() {
        String borderSide = this.serializeBorderSide(this.topSide) + this.serializeBorderSide(this.bottomSide) + this.serializeBorderSide(this.leftSide) + this.serializeBorderSide(this.rightSide);
        String shadow = StiSerializTypeConverter.booleanToString(this.getDropShadow()) + ";" + StiSerializTypeConverter.doubleToString(this.getShadowSize()) + ";" + this.getShadowBrush().serialize();
        String result = "Adv" + borderSide + shadow;
        return result;
    }

    private String serializeBorderSide(StiBorderSide borderSide) {
        String result = borderSide.getColor().serializeString() + ";" + StiSerializTypeConverter.doubleToString(borderSide.getSize()) + ";" + (Object)((Object)borderSide.getStyle()) + ";";
        return result;
    }

    @Override
    public void deserialize(String strObject) {
        String[] words = strObject.substring(3).split(";");
        this.deserializeBorderSide(this.topSide, words[0], words[1], words[2]);
        this.deserializeBorderSide(this.bottomSide, words[3], words[4], words[5]);
        this.deserializeBorderSide(this.leftSide, words[6], words[7], words[8]);
        this.deserializeBorderSide(this.rightSide, words[9], words[10], words[11]);
        this.setDropShadow(StiSerializTypeConverter.stringToBoolean(words[12]));
        this.setShadowSize(StiSerializTypeConverter.stringToDouble(words[13]));
        this.setShadowBrush(StiSerializTypeConverter.deserializeStringToBrush(words[14]));
    }

    private void deserializeBorderSide(StiBorderSide borderSide, String color, String size, String style) {
        borderSide.setColor(StiColor.deserializeString(color));
        borderSide.setSize(StiSerializTypeConverter.stringToDouble(size));
        borderSide.setStyle(StiPenStyle.valueOf(style));
    }
}

