/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.awt.Color;
import java.text.MessageFormat;

public class StiColor
implements IStiSerializable,
IStiSerializableToString {
    public static final StiColor DarkGray = new StiColor(StiColorEnum.DarkGray);
    public static final StiColor Red = new StiColor(StiColorEnum.Red);
    public static final StiColor Blue = new StiColor(StiColorEnum.Blue);
    public static final StiColor Firebrick = new StiColor(StiColorEnum.Firebrick);
    public static final StiColor Gainsboro = new StiColor(StiColorEnum.Gainsboro);
    public static final StiColor Gray = new StiColor(StiColorEnum.Gray);
    public static final StiColor Black = new StiColor(StiColorEnum.Black);
    public static final StiColor Silver = new StiColor(StiColorEnum.Silver);
    public static final StiColor Transparent = new StiColor(StiColorEnum.Transparent);
    public static final StiColor Empty = new StiColor(StiColorEnum.Black);
    public static final StiColor White = new StiColor(StiColorEnum.White);
    private static final int A_DEFAULT = 255;
    private String name;
    public int a = 255;
    public int r;
    public int g;
    public int b;
    private int gradient;

    public String toString() {
        return "r=" + this.r + " g=" + this.g + " b=" + this.b + " a=" + this.a;
    }

    public String toHTML() {
        return "#" + String.format("%1$6s", Integer.toHexString(this.getAwtColor().getRGB() & 0xFFFFFF).toUpperCase()).replaceAll(" ", "0");
    }

    public String toArgbHTML() {
        return "#" + String.format("%1$8s", Integer.toHexString(this.getAwtColor().getRGB() & 0xFFFFFFFF).toUpperCase()).replaceAll(" ", "0");
    }

    public String toRGBAhtml() {
        return String.format("rgba(%s, %s, %s, %s)", this.r, this.g, this.b, (double)this.a / 255.0);
    }

    public static StiColor parseIntARGB(int color) {
        int r = color & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 16 & 0xFF;
        int a = color >> 24 & 0xFF;
        return new StiColor(a, r, g, b);
    }

    public static StiColor parseIntRGB(int color) {
        int b = color & 0xFF;
        int g = color >> 8 & 0xFF;
        int r = color >> 16 & 0xFF;
        return new StiColor(r, g, b);
    }

    public StiColor() {
    }

    public Color getAwtColor() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public StiColor(String r, String g, String b) {
        this(255, Integer.valueOf(r), Integer.valueOf(g), Integer.valueOf(b), null);
    }

    public StiColor(int r, int g, int b) {
        this(255, r, g, b, null);
    }

    public StiColor(String a, String r, String g, String b) {
        this(Integer.valueOf(a), Integer.valueOf(r), Integer.valueOf(g), Integer.valueOf(b), null);
    }

    public StiColor(int a, int r, int g, int b) {
        this(a, r, g, b, null);
    }

    public StiColor(StiColorEnum color) {
        this(color.a, color.r, color.g, color.b, color.name());
    }

    public StiColor(int a, int r, int g, int b, String name) {
        this.a = Math.min(Math.max(a, 0), 255);
        this.r = Math.min(Math.max(r, 0), 255);
        this.g = Math.min(Math.max(g, 0), 255);
        this.b = Math.min(Math.max(b, 0), 255);
        this.name = name;
    }

    public StiColor light(int value) {
        StiColor color = this.clone();
        color.r = Math.min(255, this.r + value);
        color.g = Math.min(255, this.g + value);
        color.b = Math.min(255, this.b + value);
        return color;
    }

    public StiColor dark(int value) {
        StiColor color = this.clone();
        color.r = Math.max(0, this.r - value);
        color.g = Math.max(0, this.g - value);
        color.b = Math.max(0, this.b - value);
        return color;
    }

    public StiColor clone() {
        StiColor object = new StiColor(this.a, this.r, this.g, this.b, this.name);
        object.setGradient(this.gradient);
        return object;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setA(int a) {
        this.a = a;
    }

    public int getA() {
        return this.a;
    }

    public void setR(int r) {
        this.r = r;
    }

    public int getR() {
        return this.r;
    }

    public void setG(int g) {
        this.g = g;
    }

    public int getG() {
        return this.g;
    }

    public void setB(int b) {
        this.b = b;
    }

    public int getB() {
        return this.b;
    }

    public boolean is(StiColorEnum color) {
        return this.a == color.a && this.r == color.r && this.g == color.g && this.b == color.b;
    }

    public String serializeString() {
        String result = StiValidationUtil.isEmpty((String)this.name) && this.a == 255 ? MessageFormat.format("[{0}:{1}:{2}]", this.r, this.g, this.b) : (StiValidationUtil.isNotEmpty((String)this.name) && !"Custom".equals(this.name) ? MessageFormat.format("{0}", "Empty".equals(this.name) ? "Transparent" : this.name) : MessageFormat.format("[{0}:{1}:{2}:{3}]", this.a, this.r, this.g, this.b));
        return result;
    }

    public static String serializeStringArray(StiColor[] colors) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < colors.length; ++i) {
            sb.append(colors[i].serializeString());
            if (i == colors.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static StiColor fromAColor(int alpha, StiColor color) {
        return new StiColor(alpha, color.r, color.g, color.b);
    }

    public static StiColor fromArgb(int a, int r, int g, int b) {
        return new StiColor(a, r, g, b);
    }

    public static StiColor deserializeString(String value) {
        String colorName;
        String[] values = (value = value.replaceAll("\\[|\\]", "")).split(":");
        StiColor result = values.length == 1 ? ((colorName = values[0].trim()).equals("Empty") ? new StiColor(StiColorEnum.Transparent) : new StiColor(StiColorEnum.valueOf(colorName))) : (values.length == 4 ? new StiColor(values[0].trim(), values[1].trim(), values[2].trim(), values[3].trim()) : new StiColor(values[0].trim(), values[1].trim(), values[2].trim()));
        return result;
    }

    public static StiColor[] deserializeStringArray(String value) {
        String[] strColors = value.split(",");
        StiColor[] colors = new StiColor[strColors.length];
        for (int i = 0; i < strColors.length; ++i) {
            colors[i] = StiColor.deserializeString(strColors[i]);
        }
        return colors;
    }

    public static StiColor create(StiColorEnum color) {
        return new StiColor(color);
    }

    public static StiColor Light(StiColorEnum color, int i) {
        return new StiColor(color).light(i);
    }

    public static StiColor Dark(StiColorEnum color, int i) {
        return new StiColor(color).dark(i);
    }

    @Override
    public String serialize() {
        if (StiValidationUtil.isEmpty((String)this.name) || "Custom".equals(this.name)) {
            if (this.gradient != 0) {
                return MessageFormat.format("{0}, {1}, {2}, {3}, {4}", this.a, this.r, this.g, this.b, this.gradient);
            }
            if (this.a == 255) {
                return MessageFormat.format("{0}, {1}, {2}", this.r, this.g, this.b);
            }
            return MessageFormat.format("{0}, {1}, {2}, {3}", this.a, this.r, this.g, this.b);
        }
        return this.name;
    }

    @Override
    public void deserialize(String textContent) {
        if (textContent.indexOf(", ") >= 0) {
            String[] colorPar = textContent.split(", ");
            this.name = "Custom";
            if (colorPar.length >= 4) {
                this.a = StiSerializTypeConverter.stringToInt(colorPar[0]);
                this.r = StiSerializTypeConverter.stringToInt(colorPar[1]);
                this.g = StiSerializTypeConverter.stringToInt(colorPar[2]);
                this.b = StiSerializTypeConverter.stringToInt(colorPar[3]);
                this.gradient = colorPar.length > 4 ? StiSerializTypeConverter.stringToInt(colorPar[4]) : 0;
            } else {
                this.r = StiSerializTypeConverter.stringToInt(colorPar[0]);
                this.g = StiSerializTypeConverter.stringToInt(colorPar[1]);
                this.b = StiSerializTypeConverter.stringToInt(colorPar[2]);
                this.a = 255;
                this.gradient = 0;
            }
        } else {
            StiColor tempColor = StiColorEnum.valueOf(textContent).color();
            this.a = tempColor.a;
            this.r = tempColor.r;
            this.g = tempColor.g;
            this.b = tempColor.b;
            this.gradient = 0;
            this.name = tempColor.name;
        }
    }

    public boolean equals(StiColorEnum color) {
        return StiValidationUtil.isNotBlank((String)this.name) && this.name.equals(color.name());
    }

    public boolean equals(StiColor color) {
        return this.a == color.a && this.r == color.r && this.g == color.g && this.b == color.b;
    }

    public static StiColor fromArgb(int r, int g, int b) {
        return new StiColor(r, g, b);
    }

    public static StiColor by(StiColorEnum color) {
        return new StiColor(color);
    }

    public static StiColor fromArgb(int alpha, StiColor color) {
        return new StiColor(alpha, color.getR(), color.getG(), color.getB());
    }

    public void setGradient(int gradient) {
        this.gradient = gradient;
        this.name = "Custom";
    }

    public int getGradient() {
        return this.gradient;
    }

    public static Object ConvertColorToString(StiColor color) {
        return null;
    }

    public static StiColor ConvertStringToColor(String string) {
        return null;
    }

    public static StiColor FromArgb(int alpha, StiColor color) {
        return StiColor.fromArgb(alpha, color);
    }

    public static StiColor FromArgb(int intColor) {
        StiColor color = new StiColor();
        color.a = 255;
        color.r = intColor / 65536;
        color.g = (intColor - color.r * 65536) / 256;
        color.b = (intColor - color.r * 65536 - color.g * 256) / 1;
        return color;
    }

    public static StiColor fromHtml(String colorStr) {
        if (colorStr.startsWith("#")) {
            colorStr = colorStr.substring(1);
        }
        if (colorStr.length() == 6) {
            return new StiColor(Integer.valueOf(colorStr.substring(0, 2), 16), Integer.valueOf(colorStr.substring(2, 4), 16), Integer.valueOf(colorStr.substring(4, 6), 16));
        }
        return new StiColor(Integer.valueOf(colorStr.substring(0, 2), 16), Integer.valueOf(colorStr.substring(2, 4), 16), Integer.valueOf(colorStr.substring(4, 6), 16), Integer.valueOf(colorStr.substring(6, 8), 16));
    }
}

