/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.painter.StiGradient2Painter;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.Paint;
import java.awt.geom.Point2D;

public class StiGlareBrush
extends StiBrush {
    private StiColor startColor;
    private StiColor endColor;
    public double angle;
    private float focus = 0.5f;
    private float scale = 1.0f;
    private StiRectangle rectangle = new StiRectangle(0L, 0L, 0L, 0L);
    private final Point2D startGradiendPoint = new Point2D.Double();
    private final Point2D endGradiendPoint = new Point2D.Double();
    private float paintFocus;

    @Override
    public String serialize() {
        return StiSerializerUtil.serializFormat("GlareBrush,{0},{1},{2},{3},{4}", this.startColor.serializeString(), this.endColor.serializeString(), this.angle, Float.valueOf(this.focus), Float.valueOf(this.scale));
    }

    @Override
    public void deserialize(String value) {
        String[] values = value.split(",");
        this.startColor = StiColor.deserializeString(values[1]);
        this.endColor = StiColor.deserializeString(values[2]);
        this.angle = StiSerializTypeConverter.stringToDouble(values[3]);
        this.focus = StiSerializTypeConverter.stringToFloat(values[4]);
        this.scale = StiSerializTypeConverter.stringToFloat(values[5]);
    }

    public final StiColor getStartColor() {
        return this.startColor;
    }

    public final void setStartColor(StiColor value) {
        this.startColor = value;
        this.invalidate();
    }

    public final StiColor getEndColor() {
        return this.endColor;
    }

    public final void setEndColor(StiColor value) {
        this.endColor = value;
        this.invalidate();
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double value) {
        this.angle = value;
        this.invalidate();
    }

    public final float getFocus() {
        return this.focus;
    }

    public final void setFocus(float value) {
        if (this.focus != value) {
            if (value > 1.0f || value < 0.0f) {
                throw new IllegalArgumentException("Focus must be in range between 0 and 1!");
            }
            this.focus = value;
            this.invalidate();
        }
    }

    private void updateGradientPoints() {
        StiRectangle rect = this.getRectangle();
        Double angle1 = this.getAngle() % 180.0 > 0.0 ? this.getAngle() % 180.0 : 180.0 + this.getAngle() % 180.0;
        if (angle1 <= 45.0) {
            this.startGradiendPoint.setLocation(rect.getX(), rect.getY() + rect.getHeight() / 2.0 * (45.0 - angle1) / 45.0);
        } else if (angle1 < 135.0) {
            this.startGradiendPoint.setLocation(rect.getX() + rect.getWidth() * (angle1 - 45.0) / 90.0, rect.getY());
        } else {
            this.startGradiendPoint.setLocation(rect.getRight(), rect.getY() + rect.getHeight() / 2.0 * (angle1 - 135.0) / 45.0);
        }
        Double x0 = rect.getLeft() + rect.getWidth() / 2.0;
        Double y0 = rect.getTop() + rect.getHeight() / 2.0;
        this.endGradiendPoint.setLocation(this.startGradiendPoint.getX() + (x0 - this.startGradiendPoint.getX()) * 1.0, this.startGradiendPoint.getY() + (y0 - this.startGradiendPoint.getY()) * 1.0);
        Double angle2 = this.getAngle() % 360.0;
        this.paintFocus = angle2 > 180.0 || angle2 <= 0.0 && angle2 > -180.0 ? 1.0f - this.focus : this.focus;
    }

    public Paint getPaint() {
        StiColor color = new StiColor(Math.round((float)this.endColor.getR() * this.scale + (1.0f - this.scale) * (float)this.startColor.getR()), Math.round((float)this.endColor.getG() * this.scale + (1.0f - this.scale) * (float)this.startColor.getG()), Math.round((float)this.endColor.getB() * this.scale + (1.0f - this.scale) * (float)this.startColor.getB()));
        return new StiGradient2Painter(this.startGradiendPoint, this.getStartColor().getAwtColor(), this.endGradiendPoint, color.getAwtColor(), true, this.paintFocus);
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScale(float value) {
        if (this.scale != value) {
            if (value > 1.0f || value < 0.0f) {
                throw new IllegalArgumentException("Scale must be in range between 0 and 1!");
            }
            this.scale = value;
            this.invalidate();
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiGlareBrush brush = (StiGlareBrush)(obj instanceof StiGlareBrush ? obj : null);
        if (brush == null) {
            return false;
        }
        if (this.angle != brush.angle) {
            return false;
        }
        if (this.endColor != brush.endColor) {
            return false;
        }
        if (this.startColor != brush.startColor) {
            return false;
        }
        if (this.focus != brush.focus) {
            return false;
        }
        return this.scale == brush.scale;
    }

    private boolean ShouldSerializeStartColor() {
        return this.startColor != StiColor.Black;
    }

    private boolean ShouldSerializeEndColor() {
        return this.endColor != StiColor.White;
    }

    private boolean ShouldSerializeAngle() {
        return this.angle != 0.0;
    }

    public StiGlareBrush() {
        this(StiColor.Black, StiColor.White, 0.0);
    }

    public StiGlareBrush(StiColor startColor, StiColor endColor, double angle) {
        this(startColor, endColor, angle, 0.5f, 1.0f);
    }

    public StiGlareBrush(StiColor startColor, StiColor endColor, double angle, float focus, float scale) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.angle = angle;
        this.focus = focus;
        this.scale = scale;
    }

    public StiRectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(StiRectangle rectangle) {
        this.rectangle = rectangle;
        this.updateGradientPoints();
    }

    public void LoadValuesFromJson(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("StartColor")) {
                this.setStartColor(StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("EndColor")) {
                this.setEndColor(StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("Angle")) {
                this.setAngle(property.doubleValue());
                continue;
            }
            if (property.Name.equals("Focus")) {
                this.setFocus(property.floatValue().floatValue());
                continue;
            }
            if (!property.Name.equals("Scale")) continue;
            this.setScale(property.floatValue().floatValue());
        }
    }
}

