/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class StiRotatedTextDrawing {
    private static StiPoint getStartPoint(StiRotationMode rotationMode, StiRectangle textRect) {
        StiPoint centerPoint = new StiPoint(textRect.x + textRect.width / 2.0, textRect.y + textRect.height / 2.0);
        switch (rotationMode) {
            case LeftCenter: {
                return new StiPoint(textRect.x, centerPoint.y);
            }
            case LeftBottom: {
                return new StiPoint(textRect.x, textRect.getBottom());
            }
            case CenterTop: {
                return new StiPoint(centerPoint.x, textRect.getTop());
            }
            case CenterCenter: {
                return centerPoint;
            }
            case CenterBottom: {
                return new StiPoint(centerPoint.x, textRect.getBottom());
            }
            case RightTop: {
                return new StiPoint(textRect.getRight(), textRect.getTop());
            }
            case RightCenter: {
                return new StiPoint(textRect.getRight(), centerPoint.y);
            }
            case RightBottom: {
                return new StiPoint(textRect.getRight(), textRect.getBottom());
            }
        }
        return textRect.getLocation();
    }

    private static StiRectangle drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiPoint point, StringFormat stringFormat, StiRotationMode rotationMode, double angle, boolean antialiasing, boolean draw, boolean measure, int maximalWidth, double zoom, boolean wordWrap) {
        if (text == null || text.length() == 0) {
            return new StiRectangle(point.x, point.y, 0.0, 0.0);
        }
        StiRectangle ttSize = StiGraphicsHelper.GRAPHICS.drawAttributedString(text, font.getAwtFont(2.0), new StiRectangle(0L, 0L, maximalWidth <= 0 ? Integer.MAX_VALUE : (long)maximalWidth, Integer.MAX_VALUE), false, wordWrap, StiTextHorAlignment.Left, false, new ArrayList<StiLineInfo>(), false);
        StiSize textSize = new StiSize(ttSize.width / 2.0 + zoom * 3.0, ttSize.height / 2.0 + zoom + 2.0);
        if (textSize.width == 0.0 && textSize.height == 0.0) {
            return new StiRectangle(point.x, point.y, 0.0, 0.0);
        }
        RenderingHints renderingHints = g.getG().getRenderingHints();
        if (antialiasing) {
            g.getG().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        double px = point.x;
        double py = point.y;
        StiRectangle textRect = new StiRectangle(0.0, 0.0, textSize.width, textSize.height);
        StiPoint startPoint = StiRotatedTextDrawing.getStartPoint(rotationMode, textRect);
        textRect.x -= startPoint.x;
        textRect.y -= startPoint.y;
        StiRectangle rect = StiRectangle.getEmpty();
        if (textRect.width != 0.0 && textRect.height != 0.0) {
            if (draw) {
                g.setOffset(px, py);
                g.getG().rotate(Math.toRadians(angle), g.getOffsetX(), g.getOffsetY());
                StiTextOptions options = new StiTextOptions();
                options.setAngle((float)(-angle));
                g.drawText(text, textRect, font, brush, stringFormat.getHorAlignment(), stringFormat.getVertsAlignment(), stringFormat.isWordWrap(), 1.0, null, new StiBorder(StiEnumSet.of(StiBorderSides.Right), StiColorEnum.Red.color(), 44.0, StiPenStyle.Solid), stringFormat.getTextOptions());
                g.getG().rotate(-Math.toRadians(angle), g.getOffsetX(), g.getOffsetY());
                g.clearOffset();
            }
            if (measure) {
                AffineTransform af = new AffineTransform();
                af.translate(g.getOffsetX() + px, g.getOffsetY() + py);
                af.rotate(Math.toRadians(angle));
                GeneralPath path = new GeneralPath();
                path.append(new Rectangle2D.Double(textRect.x, textRect.y, textRect.width, textRect.height), true);
                path.transform(af);
                Rectangle2D awtRect = path.getBounds2D();
                rect = new StiRectangle(awtRect.getX(), awtRect.getY(), awtRect.getWidth(), awtRect.getHeight());
                rect = new StiRectangle(rect.x - g.getOffsetX(), rect.y - g.getOffsetY(), rect.width, rect.height);
            }
        }
        if (antialiasing) {
            g.getG().setRenderingHints(renderingHints);
        }
        return rect;
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiPoint point, StringFormat stringFormat, StiRotationMode rotationMode, double angle, boolean antialiasing, double zoom) {
        StiRotatedTextDrawing.drawString(g, text, font, brush, point, stringFormat, rotationMode, angle, antialiasing, 0, zoom);
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiPoint point, StringFormat stringFormat, StiRotationMode rotationMode, double angle, boolean antialiasing, int maximalWidth, double zoom) {
        StiRotatedTextDrawing.drawString(g, text, font, brush, point, stringFormat, rotationMode, angle, antialiasing, true, false, maximalWidth, zoom, false);
    }

    public static StiRectangle measureString(StiGraphics g, String text, StiFont font, StiPoint point, StringFormat stringFormat, StiRotationMode rotationMode, double angle, int maximalWidth, double zoom, boolean wordWrap) {
        return StiRotatedTextDrawing.drawString(g, text, font, null, point, stringFormat, rotationMode, angle, false, false, true, maximalWidth, zoom, wordWrap);
    }

    public static StiRectangle measureString(StiGraphics g, String text, StiFont font, StiPoint point, StringFormat stringFormat, StiRotationMode rotationMode, double angle, double zoom) {
        return StiRotatedTextDrawing.measureString(g, text, font, point, stringFormat, rotationMode, angle, 0, zoom, false);
    }

    public static StiRectangle measureString(StiGraphics g, String text, StiFont font, StiRectangle rect, StringFormat stringFormat, StiRotationMode rotationMode, double angle, int maximalWidth, double zoom) {
        StiPoint point = new StiPoint(rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
        return StiRotatedTextDrawing.drawString(g, text, font, null, point, stringFormat, rotationMode, angle, false, false, true, maximalWidth, zoom, false);
    }

    public static StiRectangle measureString(StiGraphics g, String text, StiFont font, StiRectangle rect, StringFormat stringFormat, StiRotationMode rotationMode, double angle, double zoom) {
        return StiRotatedTextDrawing.measureString(g, text, font, rect, stringFormat, rotationMode, angle, 0, zoom);
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiRectangle rect, StringFormat stringFormat, StiRotationMode rotationMode, double angle, boolean antialiasing, int maximalWidth, double zoom) {
        StiPoint point = new StiPoint(rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
        StiRotatedTextDrawing.drawString(g, text, font, brush, point, stringFormat, rotationMode, angle, antialiasing, maximalWidth, zoom);
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiRectangle rect, StringFormat stringFormat, StiRotationMode rotationMode, double angle, boolean antialiasing, double zoom) {
        StiRotatedTextDrawing.drawString(g, text, font, brush, rect, stringFormat, rotationMode, angle, antialiasing, 0, zoom);
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiRectangle rect, StringFormat stringFormat, double angle, boolean antialiasing, int maximalWidth, double zoom) {
        StiRotatedTextDrawing.drawString(g, text, font, brush, rect, stringFormat, StiRotationMode.CenterCenter, angle, antialiasing, maximalWidth, zoom);
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiRectangle rect, StringFormat stringFormat, double angle, boolean antialiasing, double zoom) {
        StiRotatedTextDrawing.drawString(g, text, font, brush, rect, stringFormat, angle, antialiasing, 0, zoom);
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiRectangle rect, StringFormat stringFormat, double angle, int maximalWidth, double zoom) {
        StiRotatedTextDrawing.drawString(g, text, font, brush, rect, stringFormat, angle, false, maximalWidth, zoom);
    }

    public static void drawString(StiGraphics g, String text, StiFont font, StiBrush brush, StiRectangle rect, StringFormat stringFormat, double angle, double zoom) {
        StiRotatedTextDrawing.drawString(g, text, font, brush, rect, stringFormat, angle, 0, zoom);
    }
}

