/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiShadowSides;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathRectangle;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class StiShadow {
    private static final int SHADOW_EN = 4;
    private static final int SHADOW_POWER = 99;
    private static int shadowSize = 4;
    private static BufferedImage edgeShadow = StiShadow.getEdgeShadow();
    private static BufferedImage leftShadow = StiShadow.getEdgeShadow();
    private static BufferedImage topShadow = StiShadow.getEdgeShadow();

    public static void setShadowSize(int size) {
        if (shadowSize != 4 * size) {
            shadowSize = 4 * size;
            edgeShadow = StiShadow.getEdgeShadow();
            leftShadow = StiShadow.getEdgeShadow();
            topShadow = StiShadow.getEdgeShadow();
            AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -shadowSize);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            topShadow = op.filter(topShadow, null);
            tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-shadowSize, 0.0);
            op = new AffineTransformOp(tx, 1);
            leftShadow = op.filter(leftShadow, null);
        }
    }

    public static void drawCachedShadow(StiGraphics g, StiRectangle sRect, StiEnumSet<StiShadowSides> sides, boolean isSimple) {
        StiRectangle rect = sRect.clone().round(0.0);
        if (isSimple) {
            ArrayList<StiPathCommand> path = new ArrayList<StiPathCommand>();
            if (sides.contains(StiShadowSides.Top)) {
                path.add(new StiPathRectangle(rect.getRight(), rect.y + (double)shadowSize, shadowSize, shadowSize));
            }
            if (sides.contains(StiShadowSides.Right)) {
                path.add(new StiPathRectangle(rect.getRight(), rect.y + (double)(shadowSize * 2), shadowSize, rect.height - (double)(shadowSize * 2)));
            }
            if (sides.contains(StiShadowSides.Edge)) {
                path.add(new StiPathRectangle(rect.getRight(), rect.getBottom(), shadowSize, shadowSize));
            }
            if (sides.contains(StiShadowSides.Bottom)) {
                path.add(new StiPathRectangle(rect.getXi() + shadowSize * 2, rect.getBi(), rect.getWi() - shadowSize * 2, shadowSize));
            }
            if (sides.contains(StiShadowSides.Left)) {
                path.add(new StiPathRectangle(rect.x + (double)shadowSize, rect.getBottom(), shadowSize, shadowSize));
            }
            g.drawPath(path, null, new StiSolidBrush(new StiColor(50, 0, 0, 0)), 1.0, 1.0);
        } else {
            StiShadow.drawCachedShadow(g, StiShadow.convertRect(rect), sides);
        }
    }

    public static void drawCachedShadow(StiGraphics g, StiRectangle rect, StiEnumSet<StiShadowSides> sides) {
        StiRectangle cachedRect = rect.clone();
        if (rect.width <= 0.0) {
            rect.width = 1.0;
        }
        if (rect.height <= 0.0) {
            rect.height = 1.0;
        }
        BufferedImage image = new BufferedImage(rect.getWi(), rect.getHi(), 2);
        Graphics2D gg = image.createGraphics();
        cachedRect.x = -shadowSize;
        cachedRect.y = -shadowSize;
        if (sides.contains(StiShadowSides.Top)) {
            StiShadow.drawTopShadow(gg, cachedRect);
        }
        if (sides.contains(StiShadowSides.Right)) {
            StiShadow.drawRightShadow(gg, cachedRect);
        }
        if (sides.contains(StiShadowSides.Edge)) {
            StiShadow.drawEdgeShadow(gg, cachedRect);
        }
        if (sides.contains(StiShadowSides.Bottom)) {
            StiShadow.drawBottomShadow(gg, cachedRect);
        }
        if (sides.contains(StiShadowSides.Left)) {
            StiShadow.drawLeftShadow(gg, cachedRect);
        }
        StiRectangle imgRect = rect.clone();
        imgRect.x += (double)shadowSize;
        imgRect.y += (double)shadowSize;
        g.drawImage(image, imgRect, false, false, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEdgeShadow(Graphics2D g, StiRectangle rect) {
        BufferedImage bufferedImage = edgeShadow;
        synchronized (bufferedImage) {
            g.drawImage((Image)edgeShadow, rect.getRi(), rect.getBi(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLeftShadow(Graphics2D g, StiRectangle rect) {
        BufferedImage bufferedImage = leftShadow;
        synchronized (bufferedImage) {
            g.drawImage((Image)leftShadow, rect.getLi() + shadowSize, rect.getBi(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawTopShadow(Graphics2D g, StiRectangle rect) {
        BufferedImage bufferedImage = topShadow;
        synchronized (bufferedImage) {
            g.drawImage((Image)topShadow, rect.getRi(), rect.getTi() + shadowSize, null);
        }
    }

    public static void drawRightShadow(Graphics2D g, StiRectangle rect) {
        Color startColor = new Color(0, 0, 0, 99);
        Color endColor = new Color(0, 0, 0, 0);
        StiRectangle rectSideRight = new StiRectangle(rect.getRight(), rect.y + (double)(shadowSize * 2), (double)(shadowSize + 1), rect.height - (double)(shadowSize * 2));
        if (rectSideRight.width != 0.0 && rectSideRight.height != 0.0) {
            GradientPaint gradientPaint = new GradientPaint(new Point(rectSideRight.getXi(), rectSideRight.getYi()), startColor, new Point(rectSideRight.getRi(), rectSideRight.getYi()), endColor);
            g.setPaint(gradientPaint);
            g.fillRect(rectSideRight.getXi(), rectSideRight.getYi(), rectSideRight.getWi(), rectSideRight.getHi());
        }
    }

    public static void drawBottomShadow(Graphics2D g, StiRectangle rect) {
        Color startColor = new Color(0, 0, 0, 99);
        Color endColor = new Color(0, 0, 0, 0);
        StiRectangle rectSideBottom = new StiRectangle(rect.x + (double)(shadowSize * 2), rect.getBottom(), rect.width - (double)(shadowSize * 2), (double)shadowSize);
        if (rectSideBottom.width != 0.0 && rectSideBottom.height != 0.0) {
            GradientPaint gradientPaint = new GradientPaint(new Point(rectSideBottom.getXi(), rectSideBottom.getYi()), startColor, new Point(rectSideBottom.getXi(), rectSideBottom.getBi()), endColor);
            g.setPaint(gradientPaint);
            g.fillRect(rectSideBottom.getXi(), rectSideBottom.getYi(), rectSideBottom.getWi(), rectSideBottom.getHi());
        }
    }

    public static void drawShadow(Graphics2D g, StiRectangle rect) {
        StiShadow.drawEdgeShadow(g, rect);
        StiShadow.drawLeftShadow(g, rect);
        StiShadow.drawTopShadow(g, rect);
        StiShadow.drawRightShadow(g, rect);
        StiShadow.drawBottomShadow(g, rect);
    }

    private static StiRectangle convertRect(StiRectangle rect) {
        return new StiRectangle((int)Math.round(rect.x), (int)Math.round(rect.y), (int)Math.round(rect.width), (int)Math.round(rect.height));
    }

    private static BufferedImage getEdgeShadow() {
        shadowSize = shadowSize <= 0 ? 1 : shadowSize;
        BufferedImage image = new BufferedImage(shadowSize, shadowSize, 2);
        Graphics2D g2d = image.createGraphics();
        for (int indexY = 0; indexY < shadowSize; ++indexY) {
            int alphay = 99 * (shadowSize + 1 - indexY) / (shadowSize + 1);
            for (int indexX = 0; indexX < shadowSize; ++indexX) {
                g2d.setColor(new Color(0, 0, 0, alphay * (shadowSize - indexX) / (shadowSize + 1)));
                g2d.fillRect(indexX, indexY, 1, 1);
            }
        }
        return image;
    }

    static {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -shadowSize);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        topShadow = op.filter(topShadow, null);
        tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-shadowSize, 0.0);
        op = new AffineTransformOp(tx, 1);
        leftShadow = op.filter(leftShadow, null);
    }
}

