/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.helper;

import com.kitfox.svg.app.beans.SVGIcon;
import com.kitfox.svg.xml.ColorTable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class StiSvgHelper {
    private static final int MaxSvgOffset = 1000;
    private static boolean colorsAdded = false;

    public static Map<String, Color> getColorsTable() {
        try {
            if (!colorsAdded) {
                StiSvgHelper.addColors();
            }
            ColorTable.instance();
            Field field = ColorTable.class.getDeclaredField("colorTable");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            return (Map)field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void addColors() {
        try {
            ColorTable.instance();
            Field field = ColorTable.class.getDeclaredField("colorTable");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            Map tableIn = (Map)field.get(null);
            HashMap<String, Color> table = new HashMap<String, Color>(tableIn);
            table.put("aliceblue", new Color(0xF0F8FF));
            table.put("antiquewhite", new Color(16444375));
            table.put("antiquewhite1", new Color(16773083));
            table.put("antiquewhite2", new Color(15654860));
            table.put("antiquewhite3", new Color(13484208));
            table.put("antiquewhite4", new Color(9143160));
            table.put("aquamarine", new Color(8388564));
            table.put("aquamarine1", new Color(8388564));
            table.put("aquamarine2", new Color(7794374));
            table.put("aquamarine3", new Color(6737322));
            table.put("aquamarine4", new Color(4557684));
            table.put("azure", new Color(0xF0FFFF));
            table.put("azure1", new Color(0xF0FFFF));
            table.put("azure2", new Color(0xE0EEEE));
            table.put("azure3", new Color(0xC1CDCD));
            table.put("azure4", new Color(0x838B8B));
            table.put("beige", new Color(16119260));
            table.put("bisque", new Color(16770244));
            table.put("bisque1", new Color(16770244));
            table.put("bisque2", new Color(15652279));
            table.put("bisque3", new Color(13481886));
            table.put("bisque4", new Color(9141611));
            table.put("black", new Color(0));
            table.put("blanchedalmond", new Color(16772045));
            table.put("blue", new Color(255));
            table.put("blue1", new Color(255));
            table.put("blue2", new Color(238));
            table.put("blue3", new Color(205));
            table.put("blue4", new Color(139));
            table.put("blueviolet", new Color(9055202));
            table.put("brown", new Color(0xA52A2A));
            table.put("brown1", new Color(0xFF4040));
            table.put("brown2", new Color(0xEE3B3B));
            table.put("brown3", new Color(0xCD3333));
            table.put("brown4", new Color(9118499));
            table.put("burlywood", new Color(14596231));
            table.put("burlywood1", new Color(16765851));
            table.put("burlywood2", new Color(15648145));
            table.put("burlywood3", new Color(13478525));
            table.put("burlywood4", new Color(9139029));
            table.put("cadetblue", new Color(6266528));
            table.put("cadetblue1", new Color(10024447));
            table.put("cadetblue2", new Color(0x8EE5EE));
            table.put("cadetblue3", new Color(8046029));
            table.put("cadetblue4", new Color(5473931));
            table.put("chartreuse", new Color(0x7FFF00));
            table.put("chartreuse1", new Color(0x7FFF00));
            table.put("chartreuse2", new Color(7794176));
            table.put("chartreuse3", new Color(6737152));
            table.put("chartreuse4", new Color(4557568));
            table.put("chocolate", new Color(13789470));
            table.put("chocolate1", new Color(16744228));
            table.put("chocolate2", new Color(15627809));
            table.put("chocolate3", new Color(13461021));
            table.put("chocolate4", new Color(9127187));
            table.put("coral", new Color(16744272));
            table.put("coral1", new Color(16740950));
            table.put("coral2", new Color(15624784));
            table.put("coral3", new Color(13458245));
            table.put("coral4", new Color(9125423));
            table.put("cornflowerblue", new Color(6591981));
            table.put("cornsilk", new Color(16775388));
            table.put("cornsilk1", new Color(16775388));
            table.put("cornsilk2", new Color(15657165));
            table.put("cornsilk3", new Color(13486257));
            table.put("cornsilk4", new Color(0x8B8878));
            table.put("crimson", new Color(14423100));
            table.put("cyan", new Color(65535));
            table.put("cyan1", new Color(65535));
            table.put("cyan2", new Color(61166));
            table.put("cyan3", new Color(52685));
            table.put("cyan4", new Color(35723));
            table.put("darkgoldenrod", new Color(12092939));
            table.put("darkgoldenrod1", new Color(16759055));
            table.put("darkgoldenrod2", new Color(15641870));
            table.put("darkgoldenrod3", new Color(13473036));
            table.put("darkgoldenrod4", new Color(9135368));
            table.put("darkgreen", new Color(25600));
            table.put("darkkhaki", new Color(12433259));
            table.put("darkolivegreen", new Color(5597999));
            table.put("darkolivegreen1", new Color(13303664));
            table.put("darkolivegreen2", new Color(12381800));
            table.put("darkolivegreen3", new Color(10669402));
            table.put("darkolivegreen4", new Color(7244605));
            table.put("darkorange", new Color(16747520));
            table.put("darkorange1", new Color(0xFF7F00));
            table.put("darkorange2", new Color(15627776));
            table.put("darkorange3", new Color(13460992));
            table.put("darkorange4", new Color(9127168));
            table.put("darkorchid", new Color(10040012));
            table.put("darkorchid1", new Color(12533503));
            table.put("darkorchid2", new Color(11680494));
            table.put("darkorchid3", new Color(10105549));
            table.put("darkorchid4", new Color(6824587));
            table.put("darksalmon", new Color(15308410));
            table.put("darkseagreen", new Color(9419919));
            table.put("darkseagreen1", new Color(0xC1FFC1));
            table.put("darkseagreen2", new Color(0xB4EEB4));
            table.put("darkseagreen3", new Color(10210715));
            table.put("darkseagreen4", new Color(6916969));
            table.put("darkslateblue", new Color(4734347));
            table.put("darkslategray", new Color(0x2F4F4F));
            table.put("darkslategray1", new Color(0x97FFFF));
            table.put("darkslategray2", new Color(0x8DEEEE));
            table.put("darkslategray3", new Color(7982541));
            table.put("darkslategray4", new Color(5409675));
            table.put("darkslategrey", new Color(0x2F4F4F));
            table.put("darkturquoise", new Color(52945));
            table.put("darkviolet", new Color(9699539));
            table.put("deeppink", new Color(16716947));
            table.put("deeppink1", new Color(16716947));
            table.put("deeppink2", new Color(15602313));
            table.put("deeppink3", new Color(13439094));
            table.put("deeppink4", new Color(9112144));
            table.put("deepskyblue", new Color(49151));
            table.put("deepskyblue1", new Color(49151));
            table.put("deepskyblue2", new Color(45806));
            table.put("deepskyblue3", new Color(39629));
            table.put("deepskyblue4", new Color(26763));
            table.put("dimgray", new Color(0x696969));
            table.put("dimgrey", new Color(0x696969));
            table.put("dodgerblue", new Color(2003199));
            table.put("dodgerblue1", new Color(2003199));
            table.put("dodgerblue2", new Color(1869550));
            table.put("dodgerblue3", new Color(1602765));
            table.put("dodgerblue4", new Color(1068683));
            table.put("firebrick", new Color(0xB22222));
            table.put("firebrick1", new Color(0xFF3030));
            table.put("firebrick2", new Color(0xEE2C2C));
            table.put("firebrick3", new Color(13444646));
            table.put("firebrick4", new Color(9116186));
            table.put("floralwhite", new Color(0xFFFAF0));
            table.put("forestgreen", new Color(0x228B22));
            table.put("gainsboro", new Color(0xDCDCDC));
            table.put("ghostwhite", new Color(0xF8F8FF));
            table.put("gold", new Color(16766720));
            table.put("gold1", new Color(16766720));
            table.put("gold2", new Color(15649024));
            table.put("gold3", new Color(13479168));
            table.put("gold4", new Color(9139456));
            table.put("goldenrod", new Color(14329120));
            table.put("goldenrod1", new Color(16761125));
            table.put("goldenrod2", new Color(15643682));
            table.put("goldenrod3", new Color(13474589));
            table.put("goldenrod4", new Color(9136404));
            table.put("gray", new Color(0xC0C0C0));
            table.put("gray0", new Color(0));
            table.put("gray1", new Color(197379));
            table.put("gray10", new Color(0x1A1A1A));
            table.put("gray100", new Color(0xFFFFFF));
            table.put("gray11", new Color(0x1C1C1C));
            table.put("gray12", new Color(0x1F1F1F));
            table.put("gray13", new Color(0x212121));
            table.put("gray14", new Color(0x242424));
            table.put("gray15", new Color(0x262626));
            table.put("gray16", new Color(0x292929));
            table.put("gray17", new Color(0x2B2B2B));
            table.put("gray18", new Color(0x2E2E2E));
            table.put("gray19", new Color(0x303030));
            table.put("gray2", new Color(328965));
            table.put("gray20", new Color(0x333333));
            table.put("gray21", new Color(0x363636));
            table.put("gray22", new Color(0x383838));
            table.put("gray23", new Color(0x3B3B3B));
            table.put("gray24", new Color(0x3D3D3D));
            table.put("gray25", new Color(0x404040));
            table.put("gray26", new Color(0x424242));
            table.put("gray27", new Color(0x454545));
            table.put("gray28", new Color(0x474747));
            table.put("gray29", new Color(0x4A4A4A));
            table.put("gray3", new Color(526344));
            table.put("gray30", new Color(0x4D4D4D));
            table.put("gray31", new Color(0x4F4F4F));
            table.put("gray32", new Color(0x525252));
            table.put("gray33", new Color(0x545454));
            table.put("gray34", new Color(0x575757));
            table.put("gray35", new Color(0x595959));
            table.put("gray36", new Color(0x5C5C5C));
            table.put("gray37", new Color(0x5E5E5E));
            table.put("gray38", new Color(0x616161));
            table.put("gray39", new Color(0x636363));
            table.put("gray4", new Color(657930));
            table.put("gray40", new Color(0x666666));
            table.put("gray41", new Color(0x696969));
            table.put("gray42", new Color(0x6B6B6B));
            table.put("gray43", new Color(0x6E6E6E));
            table.put("gray44", new Color(0x707070));
            table.put("gray45", new Color(0x737373));
            table.put("gray46", new Color(0x757575));
            table.put("gray47", new Color(0x787878));
            table.put("gray48", new Color(0x7A7A7A));
            table.put("gray49", new Color(0x7D7D7D));
            table.put("gray5", new Color(855309));
            table.put("gray50", new Color(0x7F7F7F));
            table.put("gray51", new Color(0x828282));
            table.put("gray52", new Color(0x858585));
            table.put("gray53", new Color(0x878787));
            table.put("gray54", new Color(0x8A8A8A));
            table.put("gray55", new Color(0x8C8C8C));
            table.put("gray56", new Color(0x8F8F8F));
            table.put("gray57", new Color(0x919191));
            table.put("gray58", new Color(0x949494));
            table.put("gray59", new Color(0x969696));
            table.put("gray6", new Color(986895));
            table.put("gray60", new Color(0x999999));
            table.put("gray61", new Color(0x9C9C9C));
            table.put("gray62", new Color(0x9E9E9E));
            table.put("gray63", new Color(0xA1A1A1));
            table.put("gray64", new Color(0xA3A3A3));
            table.put("gray65", new Color(0xA6A6A6));
            table.put("gray66", new Color(0xA8A8A8));
            table.put("gray67", new Color(0xABABAB));
            table.put("gray68", new Color(0xADADAD));
            table.put("gray69", new Color(0xB0B0B0));
            table.put("gray7", new Color(0x121212));
            table.put("gray70", new Color(0xB3B3B3));
            table.put("gray71", new Color(0xB5B5B5));
            table.put("gray72", new Color(0xB8B8B8));
            table.put("gray73", new Color(0xBABABA));
            table.put("gray74", new Color(0xBDBDBD));
            table.put("gray75", new Color(0xBFBFBF));
            table.put("gray76", new Color(0xC2C2C2));
            table.put("gray77", new Color(0xC4C4C4));
            table.put("gray78", new Color(0xC7C7C7));
            table.put("gray79", new Color(0xC9C9C9));
            table.put("gray8", new Color(0x141414));
            table.put("gray80", new Color(0xCCCCCC));
            table.put("gray81", new Color(0xCFCFCF));
            table.put("gray82", new Color(0xD1D1D1));
            table.put("gray83", new Color(0xD4D4D4));
            table.put("gray84", new Color(0xD6D6D6));
            table.put("gray85", new Color(0xD9D9D9));
            table.put("gray86", new Color(0xDBDBDB));
            table.put("gray87", new Color(0xDEDEDE));
            table.put("gray88", new Color(0xE0E0E0));
            table.put("gray89", new Color(0xE3E3E3));
            table.put("gray9", new Color(0x171717));
            table.put("gray90", new Color(0xE5E5E5));
            table.put("gray91", new Color(0xE8E8E8));
            table.put("gray92", new Color(0xEBEBEB));
            table.put("gray93", new Color(0xEDEDED));
            table.put("gray94", new Color(0xF0F0F0));
            table.put("gray95", new Color(0xF2F2F2));
            table.put("gray96", new Color(0xF5F5F5));
            table.put("gray97", new Color(0xF7F7F7));
            table.put("gray98", new Color(0xFAFAFA));
            table.put("gray99", new Color(0xFCFCFC));
            table.put("green", new Color(65280));
            table.put("green1", new Color(65280));
            table.put("green2", new Color(60928));
            table.put("green3", new Color(52480));
            table.put("green4", new Color(35584));
            table.put("greenyellow", new Color(11403055));
            table.put("grey", new Color(0xC0C0C0));
            table.put("grey0", new Color(0));
            table.put("grey1", new Color(197379));
            table.put("grey10", new Color(0x1A1A1A));
            table.put("grey100", new Color(0xFFFFFF));
            table.put("grey11", new Color(0x1C1C1C));
            table.put("grey12", new Color(0x1F1F1F));
            table.put("grey13", new Color(0x212121));
            table.put("grey14", new Color(0x242424));
            table.put("grey15", new Color(0x262626));
            table.put("grey16", new Color(0x292929));
            table.put("grey17", new Color(0x2B2B2B));
            table.put("grey18", new Color(0x2E2E2E));
            table.put("grey19", new Color(0x303030));
            table.put("grey2", new Color(328965));
            table.put("grey20", new Color(0x333333));
            table.put("grey21", new Color(0x363636));
            table.put("grey22", new Color(0x383838));
            table.put("grey23", new Color(0x3B3B3B));
            table.put("grey24", new Color(0x3D3D3D));
            table.put("grey25", new Color(0x404040));
            table.put("grey26", new Color(0x424242));
            table.put("grey27", new Color(0x454545));
            table.put("grey28", new Color(0x474747));
            table.put("grey29", new Color(0x4A4A4A));
            table.put("grey3", new Color(526344));
            table.put("grey30", new Color(0x4D4D4D));
            table.put("grey31", new Color(0x4F4F4F));
            table.put("grey32", new Color(0x525252));
            table.put("grey33", new Color(0x545454));
            table.put("grey34", new Color(0x575757));
            table.put("grey35", new Color(0x595959));
            table.put("grey36", new Color(0x5C5C5C));
            table.put("grey37", new Color(0x5E5E5E));
            table.put("grey38", new Color(0x616161));
            table.put("grey39", new Color(0x636363));
            table.put("grey4", new Color(657930));
            table.put("grey40", new Color(0x666666));
            table.put("grey41", new Color(0x696969));
            table.put("grey42", new Color(0x6B6B6B));
            table.put("grey43", new Color(0x6E6E6E));
            table.put("grey44", new Color(0x707070));
            table.put("grey45", new Color(0x737373));
            table.put("grey46", new Color(0x757575));
            table.put("grey47", new Color(0x787878));
            table.put("grey48", new Color(0x7A7A7A));
            table.put("grey49", new Color(0x7D7D7D));
            table.put("grey5", new Color(855309));
            table.put("grey50", new Color(0x7F7F7F));
            table.put("grey51", new Color(0x828282));
            table.put("grey52", new Color(0x858585));
            table.put("grey53", new Color(0x878787));
            table.put("grey54", new Color(0x8A8A8A));
            table.put("grey55", new Color(0x8C8C8C));
            table.put("grey56", new Color(0x8F8F8F));
            table.put("grey57", new Color(0x919191));
            table.put("grey58", new Color(0x949494));
            table.put("grey59", new Color(0x969696));
            table.put("grey6", new Color(986895));
            table.put("grey60", new Color(0x999999));
            table.put("grey61", new Color(0x9C9C9C));
            table.put("grey62", new Color(0x9E9E9E));
            table.put("grey63", new Color(0xA1A1A1));
            table.put("grey64", new Color(0xA3A3A3));
            table.put("grey65", new Color(0xA6A6A6));
            table.put("grey66", new Color(0xA8A8A8));
            table.put("grey67", new Color(0xABABAB));
            table.put("grey68", new Color(0xADADAD));
            table.put("grey69", new Color(0xB0B0B0));
            table.put("grey7", new Color(0x121212));
            table.put("grey70", new Color(0xB3B3B3));
            table.put("grey71", new Color(0xB5B5B5));
            table.put("grey72", new Color(0xB8B8B8));
            table.put("grey73", new Color(0xBABABA));
            table.put("grey74", new Color(0xBDBDBD));
            table.put("grey75", new Color(0xBFBFBF));
            table.put("grey76", new Color(0xC2C2C2));
            table.put("grey77", new Color(0xC4C4C4));
            table.put("grey78", new Color(0xC7C7C7));
            table.put("grey79", new Color(0xC9C9C9));
            table.put("grey8", new Color(0x141414));
            table.put("grey80", new Color(0xCCCCCC));
            table.put("grey81", new Color(0xCFCFCF));
            table.put("grey82", new Color(0xD1D1D1));
            table.put("grey83", new Color(0xD4D4D4));
            table.put("grey84", new Color(0xD6D6D6));
            table.put("grey85", new Color(0xD9D9D9));
            table.put("grey86", new Color(0xDBDBDB));
            table.put("grey87", new Color(0xDEDEDE));
            table.put("grey88", new Color(0xE0E0E0));
            table.put("grey89", new Color(0xE3E3E3));
            table.put("grey9", new Color(0x171717));
            table.put("grey90", new Color(0xE5E5E5));
            table.put("grey91", new Color(0xE8E8E8));
            table.put("grey92", new Color(0xEBEBEB));
            table.put("grey93", new Color(0xEDEDED));
            table.put("grey94", new Color(0xF0F0F0));
            table.put("grey95", new Color(0xF2F2F2));
            table.put("grey96", new Color(0xF5F5F5));
            table.put("grey97", new Color(0xF7F7F7));
            table.put("grey98", new Color(0xFAFAFA));
            table.put("grey99", new Color(0xFCFCFC));
            table.put("honeydew", new Color(0xF0FFF0));
            table.put("honeydew1", new Color(0xF0FFF0));
            table.put("honeydew2", new Color(0xE0EEE0));
            table.put("honeydew3", new Color(0xC1CDC1));
            table.put("honeydew4", new Color(0x838B83));
            table.put("hotpink", new Color(16738740));
            table.put("hotpink1", new Color(16740020));
            table.put("hotpink2", new Color(15624871));
            table.put("hotpink3", new Color(13459600));
            table.put("hotpink4", new Color(9124450));
            table.put("indianred", new Color(0xCD5C5C));
            table.put("indianred1", new Color(0xFF6A6A));
            table.put("indianred2", new Color(0xEE6363));
            table.put("indianred3", new Color(0xCD5555));
            table.put("indianred4", new Color(9124410));
            table.put("indigo", new Color(4915330));
            table.put("invis", new Color(0xFFFFFE));
            table.put("ivory", new Color(0xFFFFF0));
            table.put("ivory1", new Color(0xFFFFF0));
            table.put("ivory2", new Color(0xEEEEE0));
            table.put("ivory3", new Color(0xCDCDC1));
            table.put("ivory4", new Color(0x8B8B83));
            table.put("khaki", new Color(15787660));
            table.put("khaki1", new Color(0xFFF68F));
            table.put("khaki2", new Color(15656581));
            table.put("khaki3", new Color(13485683));
            table.put("khaki4", new Color(9143886));
            table.put("lavender", new Color(15132410));
            table.put("lavenderblush", new Color(0xFFF0F5));
            table.put("lavenderblush1", new Color(0xFFF0F5));
            table.put("lavenderblush2", new Color(0xEEE0E5));
            table.put("lavenderblush3", new Color(13484485));
            table.put("lavenderblush4", new Color(9143174));
            table.put("lawngreen", new Color(8190976));
            table.put("lemonchiffon", new Color(16775885));
            table.put("lemonchiffon1", new Color(16775885));
            table.put("lemonchiffon2", new Color(15657407));
            table.put("lemonchiffon3", new Color(13486501));
            table.put("lemonchiffon4", new Color(9144688));
            table.put("lightblue", new Color(11393254));
            table.put("lightblue1", new Color(0xBFEFFF));
            table.put("lightblue2", new Color(11722734));
            table.put("lightblue3", new Color(10141901));
            table.put("lightblue4", new Color(6849419));
            table.put("lightcoral", new Color(0xF08080));
            table.put("lightcyan", new Color(0xE0FFFF));
            table.put("lightcyan1", new Color(0xE0FFFF));
            table.put("lightcyan2", new Color(0xD1EEEE));
            table.put("lightcyan3", new Color(11849165));
            table.put("lightcyan4", new Color(8031115));
            table.put("lightgoldenrod", new Color(15654274));
            table.put("lightgoldenrod1", new Color(16772235));
            table.put("lightgoldenrod2", new Color(15654018));
            table.put("lightgoldenrod3", new Color(13483632));
            table.put("lightgoldenrod4", new Color(9142604));
            table.put("lightgoldenrodyellow", new Color(16448210));
            table.put("lightgray", new Color(0xD3D3D3));
            table.put("lightgrey", new Color(0xD3D3D3));
            table.put("lightpink", new Color(16758465));
            table.put("lightpink1", new Color(16756409));
            table.put("lightpink2", new Color(15639213));
            table.put("lightpink3", new Color(13470869));
            table.put("lightpink4", new Color(9133925));
            table.put("lightsalmon", new Color(16752762));
            table.put("lightsalmon1", new Color(16752762));
            table.put("lightsalmon2", new Color(15635826));
            table.put("lightsalmon3", new Color(13468002));
            table.put("lightsalmon4", new Color(9131842));
            table.put("lightseagreen", new Color(2142890));
            table.put("lightskyblue", new Color(8900346));
            table.put("lightskyblue1", new Color(11592447));
            table.put("lightskyblue2", new Color(10802158));
            table.put("lightskyblue3", new Color(9287373));
            table.put("lightskyblue4", new Color(6323083));
            table.put("lightslateblue", new Color(8679679));
            table.put("lightslategray", new Color(0x778899));
            table.put("lightslategrey", new Color(0x778899));
            table.put("lightsteelblue", new Color(11584734));
            table.put("lightsteelblue1", new Color(13296127));
            table.put("lightsteelblue2", new Color(12374766));
            table.put("lightsteelblue3", new Color(10663373));
            table.put("lightsteelblue4", new Color(7240587));
            table.put("lightyellow", new Color(0xFFFFE0));
            table.put("lightyellow1", new Color(0xFFFFE0));
            table.put("lightyellow2", new Color(0xEEEED1));
            table.put("lightyellow3", new Color(13487540));
            table.put("lightyellow4", new Color(9145210));
            table.put("limegreen", new Color(3329330));
            table.put("linen", new Color(16445670));
            table.put("magenta", new Color(0xFF00FF));
            table.put("magenta1", new Color(0xFF00FF));
            table.put("magenta2", new Color(0xEE00EE));
            table.put("magenta3", new Color(0xCD00CD));
            table.put("magenta4", new Color(0x8B008B));
            table.put("maroon", new Color(11546720));
            table.put("maroon1", new Color(16725171));
            table.put("maroon2", new Color(15610023));
            table.put("maroon3", new Color(13445520));
            table.put("maroon4", new Color(9116770));
            table.put("mediumaquamarine", new Color(6737322));
            table.put("mediumblue", new Color(205));
            table.put("mediumorchid", new Color(12211667));
            table.put("mediumorchid1", new Color(14706431));
            table.put("mediumorchid2", new Color(13721582));
            table.put("mediumorchid3", new Color(11817677));
            table.put("mediumorchid4", new Color(8009611));
            table.put("mediumpurple", new Color(9662683));
            table.put("mediumpurple1", new Color(11240191));
            table.put("mediumpurple2", new Color(10451438));
            table.put("mediumpurple3", new Color(9005261));
            table.put("mediumpurple4", new Color(6113163));
            table.put("mediumseagreen", new Color(3978097));
            table.put("mediumslateblue", new Color(8087790));
            table.put("mediumspringgreen", new Color(64154));
            table.put("mediumturquoise", new Color(4772300));
            table.put("mediumvioletred", new Color(13047173));
            table.put("midnightblue", new Color(1644912));
            table.put("mintcream", new Color(0xF5FFFA));
            table.put("mistyrose", new Color(16770273));
            table.put("mistyrose1", new Color(16770273));
            table.put("mistyrose2", new Color(15652306));
            table.put("mistyrose3", new Color(13481909));
            table.put("mistyrose4", new Color(9141627));
            table.put("moccasin", new Color(16770229));
            table.put("navajowhite", new Color(16768685));
            table.put("navajowhite1", new Color(16768685));
            table.put("navajowhite2", new Color(15650721));
            table.put("navajowhite3", new Color(13480843));
            table.put("navajowhite4", new Color(9140574));
            table.put("navy", new Color(128));
            table.put("navyblue", new Color(128));
            table.put("none", new Color(0xFFFFFE));
            table.put("oldlace", new Color(16643558));
            table.put("olivedrab", new Color(7048739));
            table.put("olivedrab1", new Color(12648254));
            table.put("olivedrab2", new Color(11791930));
            table.put("olivedrab3", new Color(10145074));
            table.put("olivedrab4", new Color(6916898));
            table.put("orange", new Color(16753920));
            table.put("orange1", new Color(16753920));
            table.put("orange2", new Color(15636992));
            table.put("orange3", new Color(13468928));
            table.put("orange4", new Color(9132544));
            table.put("orangered", new Color(16729344));
            table.put("orangered1", new Color(16729344));
            table.put("orangered2", new Color(0xEE4000));
            table.put("orangered3", new Color(13448960));
            table.put("orangered4", new Color(9118976));
            table.put("orchid", new Color(14315734));
            table.put("orchid1", new Color(16745466));
            table.put("orchid2", new Color(15629033));
            table.put("orchid3", new Color(13461961));
            table.put("orchid4", new Color(9127817));
            table.put("palegoldenrod", new Color(0xEEE8AA));
            table.put("palegreen", new Color(10025880));
            table.put("palegreen1", new Color(0x9AFF9A));
            table.put("palegreen2", new Color(0x90EE90));
            table.put("palegreen3", new Color(0x7CCD7C));
            table.put("palegreen4", new Color(5540692));
            table.put("paleturquoise", new Color(0xAFEEEE));
            table.put("paleturquoise1", new Color(0xBBFFFF));
            table.put("paleturquoise2", new Color(0xAEEEEE));
            table.put("paleturquoise3", new Color(9883085));
            table.put("paleturquoise4", new Color(0x668B8B));
            table.put("palevioletred", new Color(14381203));
            table.put("palevioletred1", new Color(16745131));
            table.put("palevioletred2", new Color(15628703));
            table.put("palevioletred3", new Color(13461641));
            table.put("palevioletred4", new Color(9127773));
            table.put("papayawhip", new Color(16773077));
            table.put("peachpuff", new Color(16767673));
            table.put("peachpuff1", new Color(16767673));
            table.put("peachpuff2", new Color(15649709));
            table.put("peachpuff3", new Color(13479829));
            table.put("peachpuff4", new Color(9140069));
            table.put("peru", new Color(13468991));
            table.put("pink", new Color(16761035));
            table.put("pink1", new Color(16758213));
            table.put("pink2", new Color(15641016));
            table.put("pink3", new Color(13472158));
            table.put("pink4", new Color(9134956));
            table.put("plum", new Color(0xDDA0DD));
            table.put("plum1", new Color(0xFFBBFF));
            table.put("plum2", new Color(0xEEAEEE));
            table.put("plum3", new Color(13473485));
            table.put("plum4", new Color(0x8B668B));
            table.put("powderblue", new Color(11591910));
            table.put("purple", new Color(10494192));
            table.put("purple1", new Color(10170623));
            table.put("purple2", new Color(9514222));
            table.put("purple3", new Color(8201933));
            table.put("purple4", new Color(5577355));
            table.put("red", new Color(0xFF0000));
            table.put("red1", new Color(0xFF0000));
            table.put("red2", new Color(0xEE0000));
            table.put("red3", new Color(0xCD0000));
            table.put("red4", new Color(0x8B0000));
            table.put("rosybrown", new Color(12357519));
            table.put("rosybrown1", new Color(0xFFC1C1));
            table.put("rosybrown2", new Color(0xEEB4B4));
            table.put("rosybrown3", new Color(13474715));
            table.put("rosybrown4", new Color(9136489));
            table.put("royalblue", new Color(4286945));
            table.put("royalblue1", new Color(4749055));
            table.put("royalblue2", new Color(4419310));
            table.put("royalblue3", new Color(3825613));
            table.put("royalblue4", new Color(2572427));
            table.put("saddlebrown", new Color(9127187));
            table.put("salmon", new Color(16416882));
            table.put("salmon1", new Color(16747625));
            table.put("salmon2", new Color(15630946));
            table.put("salmon3", new Color(13463636));
            table.put("salmon4", new Color(9129017));
            table.put("sandybrown", new Color(16032864));
            table.put("seagreen", new Color(3050327));
            table.put("seagreen1", new Color(5570463));
            table.put("seagreen2", new Color(0x4EEE94));
            table.put("seagreen3", new Color(4443520));
            table.put("seagreen4", new Color(3050327));
            table.put("seashell", new Color(0xFFF5EE));
            table.put("seashell1", new Color(0xFFF5EE));
            table.put("seashell2", new Color(0xEEE5DE));
            table.put("seashell3", new Color(13485503));
            table.put("seashell4", new Color(9143938));
            table.put("sienna", new Color(10506797));
            table.put("sienna1", new Color(16745031));
            table.put("sienna2", new Color(15628610));
            table.put("sienna3", new Color(13461561));
            table.put("sienna4", new Color(9127718));
            table.put("skyblue", new Color(8900331));
            table.put("skyblue1", new Color(8900351));
            table.put("skyblue2", new Color(8306926));
            table.put("skyblue3", new Color(7120589));
            table.put("skyblue4", new Color(4878475));
            table.put("slateblue", new Color(6970061));
            table.put("slateblue1", new Color(8613887));
            table.put("slateblue2", new Color(8021998));
            table.put("slateblue3", new Color(6904269));
            table.put("slateblue4", new Color(4668555));
            table.put("slategray", new Color(7372944));
            table.put("slategray1", new Color(13034239));
            table.put("slategray2", new Color(12178414));
            table.put("slategray3", new Color(10467021));
            table.put("slategray4", new Color(7109515));
            table.put("slategrey", new Color(7372944));
            table.put("snow", new Color(0xFFFAFA));
            table.put("snow1", new Color(0xFFFAFA));
            table.put("snow2", new Color(0xEEE9E9));
            table.put("snow3", new Color(0xCDC9C9));
            table.put("snow4", new Color(0x8B8989));
            table.put("springgreen", new Color(65407));
            table.put("springgreen1", new Color(65407));
            table.put("springgreen2", new Color(61046));
            table.put("springgreen3", new Color(52582));
            table.put("springgreen4", new Color(35653));
            table.put("steelblue", new Color(4620980));
            table.put("steelblue1", new Color(6535423));
            table.put("steelblue2", new Color(6073582));
            table.put("steelblue3", new Color(5215437));
            table.put("steelblue4", new Color(3564683));
            table.put("tan", new Color(13808780));
            table.put("tan1", new Color(16753999));
            table.put("tan2", new Color(15637065));
            table.put("tan3", new Color(13468991));
            table.put("tan4", new Color(9132587));
            table.put("thistle", new Color(14204888));
            table.put("thistle1", new Color(0xFFE1FF));
            table.put("thistle2", new Color(0xEED2EE));
            table.put("thistle3", new Color(13481421));
            table.put("thistle4", new Color(0x8B7B8B));
            table.put("tomato", new Color(16737095));
            table.put("tomato1", new Color(16737095));
            table.put("tomato2", new Color(15621186));
            table.put("tomato3", new Color(13455161));
            table.put("tomato4", new Color(9123366));
            table.put("transparent", new Color(0xFFFFFE));
            table.put("turquoise", new Color(4251856));
            table.put("turquoise1", new Color(62975));
            table.put("turquoise2", new Color(58862));
            table.put("turquoise3", new Color(50637));
            table.put("turquoise4", new Color(34443));
            table.put("violet", new Color(0xEE82EE));
            table.put("violetred", new Color(13639824));
            table.put("violetred1", new Color(16727702));
            table.put("violetred2", new Color(15612556));
            table.put("violetred3", new Color(13447800));
            table.put("violetred4", new Color(9118290));
            table.put("wheat", new Color(16113331));
            table.put("wheat1", new Color(16771002));
            table.put("wheat2", new Color(15653038));
            table.put("wheat3", new Color(13482646));
            table.put("wheat4", new Color(9141862));
            table.put("white", new Color(0xFFFFFF));
            table.put("whitesmoke", new Color(0xF5F5F5));
            table.put("yellow", new Color(0xFFFF00));
            table.put("yellow1", new Color(0xFFFF00));
            table.put("yellow2", new Color(0xEEEE00));
            table.put("yellow3", new Color(0xCDCD00));
            table.put("yellow4", new Color(0x8B8B00));
            table.put("yellowgreen", new Color(10145074));
            field.set(null, table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        colorsAdded = true;
    }

    public static boolean isSvg(String data) {
        return StiSvgHelper.isSvg(StiBase64DecoderUtil.decode((String)data.substring(0, Math.min(1020, data.length()))));
    }

    public static boolean isSvg(byte[] data) {
        block7: {
            try {
                if (data.length > 5 && data[0] == 60 && data[1] == 115 && data[2] == 118 && data[3] == 103 && Character.isWhitespace((char)data[4])) {
                    return true;
                }
                Stack<Boolean> stack = new Stack<Boolean>();
                boolean flag1 = false;
                int level = 0;
                for (int pos = 0; pos < data.length - 5 && pos < 1000; ++pos) {
                    if (data[pos] == 60) {
                        if (level == 0 && data[pos + 1] == 115 && data[pos + 2] == 118 && data[pos + 3] == 103 && Character.isWhitespace((char)data[pos + 4])) {
                            return true;
                        }
                        if (data[pos + 1] == 47) {
                            --level;
                            flag1 = (Boolean)stack.pop();
                            continue;
                        }
                        ++level;
                        stack.push(flag1);
                        if (data[pos + 1] != 33 && data[pos + 1] != 63) continue;
                        flag1 = true;
                        continue;
                    }
                    if (data[pos] != 62 || (pos <= 1 || data[pos - 1] != 47) && !flag1) continue;
                    --level;
                    flag1 = (Boolean)stack.pop();
                }
            }
            catch (Exception e) {
                if (StiLoggingUtil.getLogLevel() < 10) break block7;
                e.printStackTrace();
            }
        }
        return false;
    }

    public static BufferedImage decodeSVG(String base64string, StiRectangle rect, double zoom) throws IOException {
        return StiSvgHelper.decodeSVG(StiBase64DecoderUtil.decode((String)base64string), rect, zoom);
    }

    public static BufferedImage decodeSVG(byte[] svgBytes, StiRectangle rect, double zoom) throws IOException {
        BufferedImage bi;
        if (!colorsAdded) {
            StiSvgHelper.addColors();
        }
        SVGIcon icon = new SVGIcon();
        icon.setAntiAlias(true);
        icon.getSvgUniverse().clear();
        icon.setSvgURI(icon.getSvgUniverse().loadSVG((InputStream)new ByteArrayInputStream(svgBytes), "file.svg"));
        if (rect != null) {
            icon.setScaleToFit(true);
            icon.setInterpolation(2);
            icon.setPreferredSize(new Dimension((int)(rect.width / zoom), (int)(rect.height / zoom)));
            bi = new BufferedImage((int)(rect.width / zoom), (int)(rect.height / zoom), 2);
        } else {
            bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        }
        Graphics2D ig2 = bi.createGraphics();
        icon.paintIcon(null, (Graphics)ig2, 0, 0);
        return bi;
    }
}

