/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiDeserializerDocument;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.StiDeserializationDispatcher;
import org.w3c.dom.Node;

public class StiDeserializerDocumentThread
extends StiDeserializerDocument
implements Runnable {
    private StiDeserializationDispatcher dispatcher;
    private Thread thread;

    public StiDeserializerDocumentThread(StiDeserializerControler controler, IStiSerializable instance, Node rootNode, StiDeserializationDispatcher dispatcher) {
        super(controler, instance, rootNode);
        this.dispatcher = dispatcher;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            Object result = this.deserialize();
            if (!this.thread.isInterrupted()) {
                this.controler.addReferences((IStiSerializable)result, "0");
                this.controler.finish();
                this.dispatcher.deserializationFinished((IStiSerializable)result);
            }
        }
        catch (Throwable e) {
            System.out.println("Deserialization failed: " + e);
            this.dispatcher.deserializationFailed();
            StiExceptionProvider.show(e, null);
        }
    }

    public void stop() {
        this.thread.interrupt();
    }
}

