/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system.geometry;

import com.stimulsoft.base.enums.StiContentAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.utils.StiMath;
import java.awt.Rectangle;

public class StiRectangle
implements IStiSerializableToString {
    public double width;
    public double height;
    public double y;
    public double x;

    public static StiRectangle empty() {
        return new StiRectangle(0L, 0L, 0L, 0L);
    }

    public StiRectangle() {
        this(0L, 0L, 0L, 0L);
    }

    public StiRectangle(StiRectangle rectangleD) {
        this.width = rectangleD.getWidth();
        this.height = rectangleD.getHeight();
        this.y = rectangleD.getY();
        this.x = rectangleD.getX();
    }

    public StiRectangle(long x, long y, long width, long height) {
        this.width = width;
        this.height = height;
        this.y = y;
        this.x = x;
    }

    public StiRectangle(double x, double y, double width, double height) {
        this.width = width;
        this.height = height;
        this.y = y;
        this.x = x;
    }

    public StiRectangle(StiPoint location, StiSize size) {
        this.x = location.x;
        this.y = location.y;
        this.width = size.width;
        this.height = size.height;
    }

    public StiRectangle clone() {
        return new StiRectangle(this.x, this.y, this.width, this.height);
    }

    public StiRectangle move(Double deltaX, Double deltaY) {
        this.x += deltaX.doubleValue();
        this.y += deltaY.doubleValue();
        return this;
    }

    public StiRectangle inflate(Double width, Double height) {
        this.x -= width.doubleValue();
        this.y -= height.doubleValue();
        this.width += 2.0 * width;
        this.height += 2.0 * height;
        return this;
    }

    public StiRectangle inflate(int width, int height) {
        this.x -= (double)width;
        this.y -= (double)height;
        this.width += (double)(2 * width);
        this.height += (double)(2 * height);
        return this;
    }

    public Boolean isEmpty() {
        return this.width == 0.0 && this.height == 0.0 && this.x == 0.0 && this.y == 0.0;
    }

    public static StiRectangle alignSizeInRect(StiRectangle rect, StiSize size, StiContentAlignment alignment) {
        Double x = 0.0;
        Double y = 0.0;
        if (alignment == StiContentAlignment.BottomLeft || alignment == StiContentAlignment.MiddleLeft || alignment == StiContentAlignment.TopLeft) {
            x = rect.getX();
        }
        if (alignment == StiContentAlignment.BottomCenter || alignment == StiContentAlignment.MiddleCenter || alignment == StiContentAlignment.TopCenter) {
            x = rect.getX() + (rect.getWidth() - size.getWidth()) / 2.0;
        }
        if (alignment == StiContentAlignment.BottomRight || alignment == StiContentAlignment.MiddleRight || alignment == StiContentAlignment.TopRight) {
            x = rect.getRight() - size.getWidth();
        }
        if (alignment == StiContentAlignment.TopLeft || alignment == StiContentAlignment.TopCenter || alignment == StiContentAlignment.TopRight) {
            y = rect.getY();
        }
        if (alignment == StiContentAlignment.MiddleLeft || alignment == StiContentAlignment.MiddleCenter || alignment == StiContentAlignment.MiddleRight) {
            y = rect.getY() + (rect.getHeight() - size.getHeight()) / 2.0;
        }
        if (alignment == StiContentAlignment.BottomLeft || alignment == StiContentAlignment.BottomCenter || alignment == StiContentAlignment.BottomRight) {
            y = rect.getBottom() - size.getHeight();
        }
        return new StiRectangle(x, y, size.getWidth(), size.getHeight());
    }

    public Boolean intersectsWith(StiRectangle rect) {
        Double rectX = StiMath.round((Double)rect.getX(), 2.0);
        Double rectY = StiMath.round((Double)rect.getY(), 2.0);
        Double rectRight = StiMath.round((Double)rect.getRight(), 2.0);
        Double rectBottom = StiMath.round((Double)rect.getBottom(), 2.0);
        Double thisX = StiMath.round((Double)this.getX(), 2.0);
        Double thisY = StiMath.round((Double)this.getY(), 2.0);
        Double thisRight = StiMath.round((Double)this.getRight(), 2.0);
        Double thisBottom = StiMath.round((Double)this.getBottom(), 2.0);
        return rectX < thisRight && rectY < thisBottom && rectRight > thisX && rectBottom > thisY;
    }

    public Boolean contains(Double x, Double y) {
        if (this.x <= x && x < this.x + this.width && this.y <= y) {
            return y < this.y + this.height;
        }
        return false;
    }

    public StiRectangle zoom(Double zoom) {
        this.width *= zoom.doubleValue();
        this.height *= zoom.doubleValue();
        this.x *= zoom.doubleValue();
        this.y *= zoom.doubleValue();
        return this;
    }

    public StiRectangle round(double digits) {
        return this.round(digits, true);
    }

    public StiRectangle round(Double digits, Boolean smartRound) {
        if (smartRound.booleanValue()) {
            this.width = StiMath.round((Double)(StiMath.round((Double)(this.width + this.x), digits) - StiMath.round((Double)this.x, digits)), digits);
            this.height = StiMath.round((Double)(StiMath.round((Double)(this.height + this.y), digits) - StiMath.round((Double)this.y, digits)), digits);
        } else {
            this.width = StiMath.round((Double)this.width, 2.0);
            this.height = StiMath.round((Double)this.height, 2.0);
        }
        this.x = StiMath.round((Double)this.x, digits);
        this.y = StiMath.round((Double)this.y, digits);
        return this;
    }

    public StiRectangle normalize() {
        StiRectangle rect = this.clone();
        if (rect.width < 0.0) {
            rect.x += rect.width;
            rect.width = -rect.width;
        }
        if (rect.height < 0.0) {
            rect.y += rect.height;
            rect.height = -rect.height;
        }
        return rect;
    }

    public Rectangle toRectangle() {
        return new Rectangle((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    public String toString() {
        return "x = " + this.x + ", y = " + this.y + ", width = " + this.width + ", height = " + this.height;
    }

    public double getLeft() {
        return this.x;
    }

    public double getRight() {
        return this.x + this.width;
    }

    public double getTop() {
        return this.y;
    }

    public double getBottom() {
        return this.y + this.height;
    }

    public void setBottom(double bottom) {
        this.height = bottom - this.y;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setLeft(double left) {
        this.width += this.x - left;
        this.x = left;
    }

    public void setRight(double right) {
        this.width = right - this.x;
    }

    public void setTop(double top) {
        this.height += this.y - top;
        this.y = top;
    }

    public int getHi() {
        return (int)Math.round(this.height);
    }

    public int getWi() {
        return (int)Math.round(this.width);
    }

    public int getXi() {
        return (int)Math.round(this.x);
    }

    public int getYi() {
        return (int)Math.round(this.y);
    }

    public int getRi() {
        return (int)Math.round(this.getRight());
    }

    public int getBi() {
        return (int)Math.round(this.getBottom());
    }

    public int getLi() {
        return (int)Math.round(this.getLeft());
    }

    public int getTi() {
        return (int)Math.round(this.getTop());
    }

    public static StiRectangle round(StiRectangle labelRect) {
        return new StiRectangle(Math.round(labelRect.x), Math.round(labelRect.y), Math.round(labelRect.width), Math.round(labelRect.height));
    }

    public StiSize getSize() {
        return new StiSize(this.width, this.height);
    }

    public void setSize(StiSize value) {
        this.width = value.width;
        this.height = value.height;
    }

    public StiPoint getLocation() {
        return new StiPoint(this.x, this.y);
    }

    public void setLocation(StiPoint value) {
        this.x = value.x;
        this.y = value.y;
    }

    public static StiRectangle union(StiRectangle a, StiRectangle b) {
        double x = Math.min(a.x, b.x);
        double num2 = Math.max(a.x + a.width, b.x + b.width);
        double y = Math.min(a.y, b.y);
        double num4 = Math.max(a.y + a.height, b.y + b.height);
        return new StiRectangle(x, y, num2 - x, num4 - y);
    }

    public boolean contains(double x, double y) {
        if (this.x <= x && x < this.x + this.width && this.y <= y) {
            return y < this.y + this.height;
        }
        return false;
    }

    public boolean contains(StiPoint pt) {
        return this.contains(pt.x, pt.y);
    }

    public static StiRectangle getEmpty() {
        return new StiRectangle(0L, 0L, 0L, 0L);
    }

    public boolean getIsEmpty() {
        return this.width == 0.0 && this.height == 0.0 && this.x == 0.0 && this.y == 0.0;
    }

    @Override
    public String serialize() {
        return StiSerializerUtil.serializFormat("{0},{1},{2},{3}", this.x, this.y, this.width, this.height);
    }

    public StiRectangle deserializeString(String strObject) {
        this.deserialize(strObject);
        return this;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.x = StiSerializTypeConverter.stringToDouble(values[0]);
        this.y = StiSerializTypeConverter.stringToDouble(values[1]);
        this.width = StiSerializTypeConverter.stringToDouble(values[2]);
        this.height = StiSerializTypeConverter.stringToDouble(values[3]);
    }

    public StiRectangle Multiply(double multipleFactor) {
        return new StiRectangle(this.getX() * multipleFactor, this.getY() * multipleFactor, this.getWidth() * multipleFactor, this.getHeight() * multipleFactor);
    }

    public StiRectangle getNormalize() {
        return this.normalize();
    }

    public StiRectangle FitToRectangle(StiRectangle rectangle) {
        if (this.getIsEmpty()) {
            return rectangle;
        }
        if (rectangle.getIsEmpty()) {
            return this;
        }
        StiRectangle rectangle2 = this;
        if (rectangle2.getLeft() > rectangle.getLeft()) {
            rectangle2.setWidth(rectangle2.getWidth() + rectangle2.getLeft() - rectangle.getLeft());
            rectangle2.setX(rectangle.getLeft());
        }
        if (rectangle2.getTop() > rectangle.getTop()) {
            rectangle2.setHeight(rectangle2.getHeight() + rectangle2.getTop() - rectangle.getTop());
            rectangle2.setY(rectangle.getTop());
        }
        if (rectangle2.getRight() < rectangle.getRight()) {
            rectangle2.setWidth(rectangle2.getWidth() + rectangle.getRight() - rectangle2.getRight());
        }
        if (rectangle2.getBottom() < rectangle.getBottom()) {
            rectangle2.setHeight(rectangle2.getHeight() + rectangle.getBottom() - rectangle2.getBottom());
        }
        return rectangle2;
    }

    public StiRectangle OffsetRect(StiRectangle offsettingRectangle) {
        return new StiRectangle(this.x - offsettingRectangle.x, this.y - offsettingRectangle.y, this.width + offsettingRectangle.width, this.height + offsettingRectangle.height);
    }

    public StiRectangle AlignToGrid(double gridSize, boolean aligningToGrid) {
        if (aligningToGrid) {
            return new StiRectangle((double)Math.round(this.getX() / gridSize) * gridSize, (double)Math.round(this.getY() / gridSize) * gridSize, (double)Math.round(this.getWidth() / gridSize) * gridSize, (double)Math.round(this.getHeight() / gridSize) * gridSize);
        }
        return new StiRectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
    }

    public boolean IntersectsWith(StiRectangle rect) {
        return rect.x < this.x + this.width && this.x < rect.x + rect.width && rect.y < this.y + this.height && this.y < rect.y + rect.height;
    }

    public void LoadFromJson(JSONObject jObject) throws NumberFormatException, JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equalsIgnoreCase("X")) {
                this.x = Double.parseDouble(property.Value.toString());
                continue;
            }
            if (property.Name.equalsIgnoreCase("Y")) {
                this.y = Double.parseDouble(property.Value.toString());
                continue;
            }
            if (property.Name.equalsIgnoreCase("Width")) {
                this.width = Double.parseDouble(property.Value.toString());
                continue;
            }
            if (!property.Name.equalsIgnoreCase("Height")) continue;
            this.height = Double.parseDouble(property.Value.toString());
        }
    }
}

