/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import com.stimulsoft.base.enums.StiArabicDigitsType;

public class StiBidirectionalConvert {
    private static final String ST_SEPARATOR = "./:\\,-";
    private static final int ARABIC_TABLE_SIZE = 76;
    private static final int LIGATURES_TABLE_SIZE = 40;
    private static String[][] ligaturesTable;
    private static int[][] arabicTableArray;
    private int[][] arabicTable;
    private Mode mode = Mode.Pdf;
    private boolean useStaticArrays = true;

    public StiBidirectionalConvert(Mode mode) {
        this.mode = mode;
        if (this.arabicTable == null) {
            int[][] tempArabicTable = new int[][]{{1569, 1, 65152, 0, 0, 0}, {1570, 2, 65153, 65154, 0, 0}, {1571, 2, 65155, 65156, 0, 0}, {1572, 2, 65157, 65158, 0, 0}, {1573, 2, 65159, 65160, 0, 0}, {1574, 3, 65161, 65162, 65163, 65164}, {1575, 2, 65165, 65166, 0, 0}, {1576, 3, 65167, 65168, 65169, 65170}, {1577, 2, 65171, 65172, 0, 0}, {1578, 3, 65173, 65174, 65175, 65176}, {1579, 3, 65177, 65178, 65179, 65180}, {1580, 3, 65181, 65182, 65183, 65184}, {1581, 3, 65185, 65186, 65187, 65188}, {1582, 3, 65189, 65190, 65191, 65192}, {1583, 2, 65193, 65194, 0, 0}, {1584, 2, 65195, 65196, 0, 0}, {1585, 2, 65197, 65198, 0, 0}, {1586, 2, 65199, 65200, 0, 0}, {1587, 3, 65201, 65202, 65203, 65204}, {1588, 3, 65205, 65206, 65207, 65208}, {1589, 3, 65209, 65210, 65211, 65212}, {1590, 3, 65213, 65214, 65215, 65216}, {1591, 3, 65217, 65218, 65219, 65220}, {1592, 3, 65221, 65222, 65223, 65224}, {1593, 3, 65225, 65226, 65227, 65228}, {1594, 3, 65229, 65230, 65231, 65232}, {1601, 3, 65233, 65234, 65235, 65236}, {1602, 3, 65237, 65238, 65239, 65240}, {1603, 3, 65241, 65242, 65243, 65244}, {1604, 3, 65245, 65246, 65247, 65248}, {1605, 3, 65249, 65250, 65251, 65252}, {1606, 3, 65253, 65254, 65255, 65256}, {1607, 3, 65257, 65258, 65259, 65260}, {1608, 2, 65261, 65262, 0, 0}, {1609, 3, 65263, 65264, 64488, 64489}, {1610, 3, 65265, 65266, 65267, 65268}, {1649, 2, 64336, 64337, 0, 0}, {1655, 2, 64477, 1655, 0, 0}, {1657, 3, 64358, 64359, 64360, 64361}, {1658, 3, 64350, 64351, 64352, 64353}, {1659, 3, 64338, 64339, 64340, 64341}, {1662, 3, 64342, 64343, 64344, 64345}, {1663, 3, 64354, 64355, 64356, 64357}, {1664, 3, 64346, 64347, 64348, 64349}, {1667, 3, 64374, 64375, 64376, 64377}, {1668, 3, 64370, 64371, 64372, 64373}, {1670, 3, 64378, 64379, 64380, 64381}, {1671, 3, 64382, 64383, 64384, 64385}, {1672, 2, 64392, 64393, 0, 0}, {1676, 2, 64388, 64389, 0, 0}, {1677, 2, 64386, 64387, 0, 0}, {1678, 2, 64390, 64391, 0, 0}, {1681, 2, 64396, 64397, 0, 0}, {1688, 2, 64394, 64395, 0, 0}, {1700, 3, 64362, 64363, 64364, 64365}, {1702, 3, 64366, 64367, 64368, 64369}, {1705, 3, 64398, 64399, 64400, 64401}, {1709, 3, 64467, 64468, 64469, 64470}, {1711, 3, 64402, 64403, 64404, 64405}, {1713, 3, 64410, 64411, 64412, 64413}, {1715, 3, 64406, 64407, 64408, 64409}, {1722, 2, 64414, 64415, 0, 0}, {1723, 3, 64416, 64417, 64418, 64419}, {1726, 3, 64426, 64427, 64428, 64429}, {1728, 2, 64420, 64421, 0, 0}, {1729, 3, 64422, 64423, 64424, 64425}, {1733, 2, 64480, 64481, 0, 0}, {1734, 2, 64473, 64474, 0, 0}, {1735, 2, 64471, 64472, 0, 0}, {1736, 2, 64475, 64476, 0, 0}, {1737, 2, 64482, 64483, 0, 0}, {1739, 2, 64478, 64479, 0, 0}, {1740, 3, 64508, 64509, 64510, 64511}, {1744, 3, 64484, 64485, 64486, 64487}, {1746, 2, 64430, 64431, 0, 0}, {1747, 2, 64432, 64433, 0, 0}};
            this.arabicTable = tempArabicTable;
        }
        if (ligaturesTable == null) {
            String[][] tempLigaturesTable = new String[][]{{"\ufedf\ufe82", "\ufef5"}, {"\ufee0\ufe82", "\ufef6"}, {"\ufedf\ufe84", "\ufef7"}, {"\ufee0\ufe84", "\ufef8"}, {"\ufedf\ufe88", "\ufef9"}, {"\ufee0\ufe88", "\ufefa"}, {"\ufedf\ufe8e", "\ufefb"}, {"\ufee0\ufe8e", "\ufefc"}, {"\u05e9\u05c1", "\ufb2a"}, {"\u05e9\u05c2", "\ufb2b"}, {"\ufb49\u05c1", "\ufb2c"}, {"\ufb49\u05c2", "\ufb2d"}, {"\u05d0\u05b7", "\ufb2e"}, {"\u05d0\u05b8", "\ufb2f"}, {"\u05d0\u05bc", "\ufb30"}, {"\u05d1\u05bc", "\ufb31"}, {"\u05d2\u05bc", "\ufb32"}, {"\u05d3\u05bc", "\ufb33"}, {"\u05d4\u05bc", "\ufb34"}, {"\u05d5\u05bc", "\ufb35"}, {"\u05d6\u05bc", "\ufb36"}, {"\u05d8\u05bc", "\ufb38"}, {"\u05d9\u05bc", "\ufb39"}, {"\u05da\u05bc", "\ufb3a"}, {"\u05db\u05bc", "\ufb3b"}, {"\u05dc\u05bc", "\ufb3c"}, {"\u05de\u05bc", "\ufb3e"}, {"\u05e0\u05bc", "\ufb40"}, {"\u05e1\u05bc", "\ufb41"}, {"\u05e3\u05bc", "\ufb43"}, {"\u05e4\u05bc", "\ufb44"}, {"\u05e6\u05bc", "\ufb46"}, {"\u05e7\u05bc", "\ufb47"}, {"\u05e8\u05bc", "\ufb48"}, {"\u05e9\u05bc", "\ufb49"}, {"\u05ea\u05bc", "\ufb4a"}, {"\u05d5\u05b9", "\ufb4b"}, {"\u05d1\u05bf", "\ufb4c"}, {"\u05db\u05bf", "\ufb4d"}, {"\u05e4\u05bf", "\ufb4e"}};
            ligaturesTable = tempLigaturesTable;
        }
        if (arabicTableArray == null) {
            int index;
            int[][] tempArray = new int[65536][5];
            for (index = 0; index < 76; ++index) {
                int tempInt = this.arabicTable[index][0];
                tempArray[tempInt][0] = this.arabicTable[index][1];
                tempArray[tempInt][1] = this.arabicTable[index][2];
                tempArray[tempInt][2] = this.arabicTable[index][3];
                tempArray[tempInt][3] = this.arabicTable[index][4];
                tempArray[tempInt][4] = this.arabicTable[index][5];
            }
            for (index = 1424; index <= 1535; ++index) {
                tempArray[index][0] = 1;
                tempArray[index][1] = index;
            }
            for (index = 64285; index <= 64335; ++index) {
                tempArray[index][0] = 1;
                tempArray[index][1] = index;
            }
            arabicTableArray = tempArray;
        }
    }

    public StringBuilder convert(StringBuilder inputString, boolean useRightToLeft) {
        return this.convert(inputString, useRightToLeft, false, null);
    }

    public StringBuilder convert(StringBuilder inputString, boolean useRightToLeft, Boolean pdfConvertDigitsToArabic, StiArabicDigitsType arabicDigitsType) {
        StringBuilder outputString = new StringBuilder();
        if (inputString.length() > 0) {
            if (useRightToLeft) {
                int index = 0;
                StringBuilder sbTemp = new StringBuilder();
                if (Character.isDigit(inputString.charAt(0))) {
                    int digIndex;
                    StringBuilder sbb = new StringBuilder();
                    for (digIndex = 0; digIndex < inputString.length() && (Character.isDigit(inputString.charAt(digIndex)) || ST_SEPARATOR.indexOf(inputString.charAt(digIndex)) != -1); ++digIndex) {
                        sbb.append(inputString.charAt(digIndex));
                    }
                    if (inputString.charAt(digIndex - 1) == '.') {
                        sbb.setLength(sbb.length() - 1);
                        sbb.insert(0, '.');
                    }
                    while (digIndex < inputString.length() && (inputString.charAt(digIndex) == ' ' || inputString.charAt(digIndex) == '\u00a0')) {
                        ++digIndex;
                        outputString.insert(0, ' ');
                    }
                    outputString.append((CharSequence)sbb);
                    index = digIndex;
                }
                while (index < inputString.length()) {
                    char num = inputString.charAt(index);
                    if (this.symbolIsArabicOrHebrew(num) || this.symbolIsRTLMark(num)) {
                        int startIndex;
                        if (!this.symbolIsRTLMark(num)) {
                            while (index > 0 && sbTemp.length() > 0 && (inputString.charAt(index - 1) >= ' ' && inputString.charAt(index - 1) <= '@' || inputString.charAt(index - 1) >= '[' && inputString.charAt(index - 1) <= '`' || inputString.charAt(index - 1) >= '{' && inputString.charAt(index - 1) <= '~' || inputString.charAt(index - 1) == '\u00a0')) {
                                --index;
                                sbTemp.setLength(sbTemp.length() - 1);
                            }
                        }
                        int lastSpace = startIndex = index;
                        int lastArabicHebrew = startIndex;
                        num = inputString.charAt(index);
                        while (!this.symbolIsLTRMark(num) && (this.symbolIsArabicOrHebrew(num) || num >= ' ' && num <= '@' || num >= '[' && num <= '`' || num >= '{' && num <= '~' || num == '\u00a0' || num >= '\u2000' && num <= '\u206f')) {
                            if (this.symbolIsArabicOrHebrew(num)) {
                                lastArabicHebrew = index;
                            }
                            if (Character.isWhitespace(num)) {
                                lastSpace = index;
                            }
                            if (++index < inputString.length()) {
                                num = inputString.charAt(index);
                                continue;
                            }
                            num = '\u0000';
                        }
                        int endIndex = index;
                        if (lastSpace > lastArabicHebrew) {
                            endIndex = lastSpace + 1;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (index = startIndex; index < endIndex; ++index) {
                            num = inputString.charAt(index);
                            if (this.symbolIsBidiMark(num)) continue;
                            sb.append(inputString.charAt(index));
                        }
                        --index;
                        outputString.insert(0, sbTemp);
                        outputString.insert(0, this.convertArabic(sb));
                        sbTemp = new StringBuilder();
                    } else if (!this.symbolIsBidiMark(num)) {
                        sbTemp.append(num);
                    }
                    ++index;
                }
                outputString.insert(0, sbTemp);
            } else {
                for (int index = 0; index < inputString.length(); ++index) {
                    char num = inputString.charAt(index);
                    if (this.symbolIsArabicOrHebrew(num)) {
                        StringBuilder sb = new StringBuilder();
                        while (this.symbolIsArabicOrHebrew(num) || num >= ' ' && num <= '@' || num >= '[' && num <= '`' || num >= '{' && num <= '~' || num == '\u00a0' || num >= '\u2000' && num <= '\u206f') {
                            if (!this.symbolIsBidiMark(num)) {
                                sb.append(inputString.charAt(index));
                            }
                            if (++index < inputString.length()) {
                                num = inputString.charAt(index);
                                continue;
                            }
                            num = '\u0000';
                        }
                        --index;
                        while (inputString.charAt(index) == ' ' || inputString.charAt(index) == '\u00a0') {
                            --index;
                            sb.setLength(sb.length() - 1);
                        }
                        outputString.append(this.convertArabic(sb));
                        continue;
                    }
                    if (this.symbolIsBidiMark(num)) continue;
                    outputString.append(num);
                }
            }
            if (this.mode == Mode.Pdf && pdfConvertDigitsToArabic.booleanValue() && useRightToLeft) {
                return StiBidirectionalConvert.convertDigitsToArabic(outputString, arabicDigitsType);
            }
        }
        return outputString;
    }

    public static String convertDigitsToArabic(String inputString, StiArabicDigitsType digitsType) {
        StringBuilder sb = new StringBuilder(inputString);
        sb = StiBidirectionalConvert.convertDigitsToArabic(sb, digitsType);
        return sb.toString();
    }

    public static StringBuilder convertDigitsToArabic(StringBuilder inputString, StiArabicDigitsType digitsType) {
        for (int index = 0; index < inputString.length(); ++index) {
            int num = inputString.charAt(index);
            if (num < 48 || num > 57) continue;
            num += 1584;
            if (digitsType == StiArabicDigitsType.Eastern) {
                num += 144;
            }
            inputString.setCharAt(index, (char)num);
        }
        return inputString;
    }

    private String convertArabic(StringBuilder inputSB) {
        StringBuilder tempSB = new StringBuilder();
        block12: for (int index = 0; index < inputSB.length(); ++index) {
            int tempInt = arabicTableArray[inputSB.charAt(index)][0];
            switch (tempInt) {
                case 3: {
                    StringBuilder sb = new StringBuilder();
                    sb.append(inputSB.charAt(index));
                    while (index + 1 < inputSB.length() && arabicTableArray[inputSB.charAt(index + 1)][0] == 3) {
                        sb.append(inputSB.charAt(++index));
                    }
                    if (index + 1 < inputSB.length() && arabicTableArray[inputSB.charAt(index + 1)][0] == 2) {
                        sb.append(inputSB.charAt(++index));
                    }
                    if (sb.length() == 1) {
                        tempSB.append((char)arabicTableArray[sb.charAt(0)][1]);
                        continue block12;
                    }
                    tempSB.append((char)arabicTableArray[sb.charAt(0)][3]);
                    if (sb.length() > 2) {
                        for (int tempIndex = 1; tempIndex < sb.length() - 1; ++tempIndex) {
                            tempSB.append((char)arabicTableArray[sb.charAt(tempIndex)][4]);
                        }
                    }
                    tempSB.append((char)arabicTableArray[sb.charAt(sb.length() - 1)][2]);
                    continue block12;
                }
                case 1: 
                case 2: {
                    tempSB.append((char)arabicTableArray[inputSB.charAt(index)][1]);
                    continue block12;
                }
                default: {
                    tempSB.append(inputSB.charAt(index));
                }
            }
        }
        StringBuilder tempSB2 = new StringBuilder();
        tempSB2 = tempSB;
        for (int index3 = 0; index3 < 40; ++index3) {
            tempSB2 = new StringBuilder(tempSB2.toString().replace(ligaturesTable[index3][0], ligaturesTable[index3][1]));
        }
        StringBuilder outputSB = new StringBuilder();
        for (int index2 = tempSB2.length() - 1; index2 >= 0; --index2) {
            int num = tempSB2.charAt(index2);
            switch (num) {
                case 40: {
                    num = 41;
                    break;
                }
                case 41: {
                    num = 40;
                    break;
                }
                case 91: {
                    num = 93;
                    break;
                }
                case 93: {
                    num = 91;
                    break;
                }
                case 123: {
                    num = 125;
                    break;
                }
                case 125: {
                    num = 123;
                }
            }
            if (Character.isDigit((char)num)) {
                int index5;
                for (index5 = index2; index5 > 0 && this.symbolIsDigitOrDelimiter(tempSB2.charAt(index5 - 1)); --index5) {
                }
                for (int index4 = index5; index4 <= index2; ++index4) {
                    outputSB.append(tempSB2.charAt(index4));
                }
                index2 = index5;
                continue;
            }
            outputSB.append((char)num);
        }
        return outputSB.toString();
    }

    private boolean symbolIsDigitOrDelimiter(int num) {
        return Character.isDigit((char)num) || num == 46 || num == 47 || num == 58 || num == 92 || num == 44 || num == 45;
    }

    private boolean symbolIsArabicOrHebrew(int num) {
        return num >= 1536 && num <= 1791 || num >= 1424 && num <= 1535 || num >= 64285 && num <= 64335 || num >= 64336 && num <= 65023 || num >= 65136 && num <= 65279;
    }

    private boolean symbolIsBidiMark(int num) {
        return num == 8206 || num == 8207 || num >= 8234 && num <= 8238;
    }

    private boolean symbolIsLTRMark(int num) {
        return num == 8206 || num == 8234 || num == 8237;
    }

    private boolean symbolIsRTLMark(int num) {
        return num == 8207 || num == 8235 || num == 8238;
    }

    public void clear() {
        if (!this.useStaticArrays) {
            this.arabicTable = null;
            ligaturesTable = null;
            arabicTableArray = null;
        }
    }

    public static enum Mode {
        Pdf,
        Xps;

    }
}

