/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.nio.charset.Charset;

public class StiCharsetHelper {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset WINDOWS_1251 = Charset.forName("windows-1251");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_16 = Charset.forName("UTF-16");
    public static final Charset WINDOWS_1252 = Charset.forName("windows-1252");
    public static final Charset IBM437 = Charset.forName("IBM437");
    public static final Charset IBM850 = Charset.forName("IBM850");
    public static final Charset IBM852 = Charset.forName("IBM852");
    public static final Charset IBM857 = Charset.forName("IBM857");
    public static final Charset IBM860 = Charset.forName("IBM860");
    public static final Charset IBM861 = Charset.forName("IBM861");
    public static final Charset IBM862 = Charset.forName("IBM862");
    public static final Charset IBM863 = Charset.forName("IBM863");
    public static final Charset IBM865 = Charset.forName("IBM865");
    public static final Charset IBM866 = Charset.forName("IBM866");
    public static final Charset IBM869 = Charset.forName("IBM869");
    public static Charset[] CHARSETS = new Charset[]{WINDOWS_1251, US_ASCII, UTF_16, UTF8};
    public static String[] CHARSET_NAMES = new String[]{WINDOWS_1251.displayName(), US_ASCII.displayName(), UTF_16.displayName(), UTF8.displayName()};

    public static Charset getCharsetFromName(String charsetName) {
        return StiCharsetHelper.getCharsetFromName(charsetName, CHARSETS);
    }

    public static Charset getCharsetFromName(String charsetName, Charset[] charsets) {
        for (Charset chraset : charsets) {
            if (!chraset.displayName().equals(charsetName)) continue;
            return chraset;
        }
        return UTF8;
    }

    public static Charset findCharset(String charsetName) {
        for (String name : Charset.availableCharsets().keySet()) {
            if (name.indexOf("windows-" + charsetName) <= 0) continue;
            return (Charset)Charset.availableCharsets().get(name);
        }
        for (String name : Charset.availableCharsets().keySet()) {
            if (name.indexOf(charsetName) <= 0) continue;
            return (Charset)Charset.availableCharsets().get(name);
        }
        return UTF8;
    }
}

