/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.zip;

import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class StiGZipHelper {
    public static byte[] convertStringToByteArray(String str) throws UnsupportedEncodingException {
        if (StiValidationUtil.isNullOrWhiteSpace((String)str)) {
            return null;
        }
        return str.getBytes(System.getProperty("file.encoding"));
    }

    public static String convertByteArrayToString(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, System.getProperty("file.encoding"));
    }

    public static byte[] pack(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(bos);
        StiIOUtil.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)gzos);
        bos.close();
        gzos.close();
        return bos.toByteArray();
    }

    public static String pack(String str) throws UnsupportedEncodingException, IOException {
        if (StiValidationUtil.isNullOrWhiteSpace((String)str)) {
            return null;
        }
        return new String(StiBase64EncoderUtil.encode((byte[])StiGZipHelper.pack(StiGZipHelper.convertStringToByteArray(str))), System.getProperty("file.encoding"));
    }

    public static byte[] unpack(byte[] buff) throws IOException {
        if (buff == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(buff);
        GZIPInputStream gzis = new GZIPInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StiIOUtil.copy((InputStream)gzis, (OutputStream)bos);
        bos.close();
        gzis.close();
        return bos.toByteArray();
    }
}

