/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiCap;
import com.stimulsoft.base.drawing.StiCapStyle;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiStringBuilder;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class StiJsonReportObjectHelper {

    public static class Deserialize {
        public static String[] stringArray(JSONObject jObject) throws JSONException {
            String[] result = new String[jObject.names().length()];
            int index = 0;
            for (int i = 0; i < jObject.names().length(); ++i) {
                String key = jObject.names().getString(i);
                try {
                    index = Integer.parseInt(key);
                }
                catch (Exception e) {
                    // empty catch block
                }
                result[index] = jObject.getString(key);
                ++index;
            }
            return result;
        }

        public static ArrayList<String> stringList(JSONObject jObject) throws JSONException {
            String[] res = Deserialize.stringArray(jObject);
            ArrayList<String> result = new ArrayList<String>(Arrays.asList(res));
            return result;
        }

        public static Integer[] intArray(JSONObject jObject) throws JSONException {
            Integer[] result = new Integer[jObject.names().length()];
            int index = 0;
            for (int i = 0; i < jObject.names().length(); ++i) {
                String key = jObject.names().getString(i);
                try {
                    index = Integer.parseInt(key);
                }
                catch (Exception e) {
                    // empty catch block
                }
                result[index] = jObject.getInt(key);
                ++index;
            }
            return result;
        }

        public static ArrayList<Integer> IntArrayList(JSONObject jObject) throws JSONException {
            Integer[] res = Deserialize.intArray(jObject);
            ArrayList<Integer> result = new ArrayList<Integer>(Arrays.asList(res));
            return result;
        }

        public static StiFont Font(JProperty prop, StiFont defaultFont) throws JSONException {
            if (prop.Value instanceof JSONObject) {
                return Deserialize.Font((JSONObject)prop.Value, defaultFont);
            }
            return Deserialize.Font((String)prop.Value, defaultFont);
        }

        private static StiFont Font(String text, StiFont defaultFont) {
            String[] values = StiStringUtil.split((String)text, (String)";");
            if (values.length != 4) {
                throw new RuntimeException("Parsing Error");
            }
            String defaultFamily = defaultFont.getName();
            double defaultEmSize = defaultFont.getSize();
            int defaultStyle = defaultFont.getFontStyle();
            StiGraphicsUnit defaultUnit = defaultFont.getUnit();
            if (!StiValidationUtil.isNullOrEmpty((String)values[0])) {
                defaultFamily = values[0];
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                defaultEmSize = Float.parseFloat(values[1]);
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                defaultStyle = StiFont.deserializeStyle(values[2]);
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[3])) {
                defaultUnit = StiGraphicsUnit.valueOf(values[3]);
            }
            return new StiFont(defaultFamily, defaultEmSize, defaultStyle, defaultUnit);
        }

        private static StiFont Font(JSONObject jObject, StiFont defaultFont) throws JSONException {
            String familyName = defaultFont.getName();
            double emSize = defaultFont.size;
            int style = defaultFont.getStyle();
            StiGraphicsUnit unit = defaultFont.getUnit();
            for (JProperty property : jObject.Properties()) {
                if (property.Name.equals("FamilyName")) {
                    familyName = property.Value.toString();
                    continue;
                }
                if (property.Name.equals("Size")) {
                    emSize = property.floatValue().floatValue();
                    continue;
                }
                if (property.Name.equals("Style")) {
                    style = StiFont.deserializeStyle((String)property.Value);
                    continue;
                }
                if (!property.Name.equals("Unit")) continue;
                unit = StiGraphicsUnit.valueOf(property.Value.toString());
            }
            return new StiFont(familyName, emSize, style, unit);
        }

        public static StiBorderSide JBorderSide(String text) {
            String[] values = StiStringUtil.split((String)text, (String)":");
            StiBorderSide side = new StiBorderSide();
            if (!StiValidationUtil.isNullOrEmpty((String)values[0])) {
                side.setColor(Deserialize.Color(values[0]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                side.setSize(Double.parseDouble(values[1]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                side.setStyle(StiPenStyle.valueOf(values[2]));
            }
            return side;
        }

        public static StiCap JCap(String text) {
            String[] values = StiStringUtil.split((String)text, (String)";");
            StiCap cap = new StiCap();
            if (values.length != 4) {
                throw new RuntimeException("Parsing Error");
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[0])) {
                cap.setWidth(Integer.parseInt(values[0]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                cap.setHeight(Integer.parseInt(values[1]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                cap.setStyle(StiCapStyle.valueOf(values[2]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[3])) {
                cap.setColor(Deserialize.Color(values[3]));
            }
            return cap;
        }

        public static StiBorder Border(JProperty prop) throws JSONException {
            if (!(prop.Value instanceof JSONObject)) {
                return Deserialize.Border((String)prop.Value);
            }
            StiBorder border = new StiBorder();
            border.LoadFromJson((JSONObject)prop.Value);
            return border;
        }

        private static StiBorder Border(String text) {
            String[] values = StiStringUtil.split((String)text, (String)";");
            if (values.length == 7) {
                boolean dropShadow = false;
                double shadowSize = 4.0;
                StiSolidBrush shadowBrush = new StiSolidBrush(StiColorEnum.Black.color());
                return new StiAdvancedBorder(Deserialize.JBorderSide(values[0]), Deserialize.JBorderSide(values[1]), Deserialize.JBorderSide(values[2]), Deserialize.JBorderSide(values[3]), dropShadow, shadowSize, (StiBrush)shadowBrush);
            }
            StiBorder border = new StiBorder();
            if (!StiValidationUtil.isNullOrEmpty((String)values[0])) {
                border.setSide(StiEnumSet.stringToEnums(StiBorderSides.class, values[0]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                border.setColor(Deserialize.Color(values[1]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                border.setSize(Double.parseDouble(values[2]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[3])) {
                border.setStyle(StiPenStyle.valueOf(values[3]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[4])) {
                border.setShadowSize(Double.parseDouble(values[4]));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[5])) {
                border.setDropShadow(true);
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[6])) {
                border.setTopmost(true);
            }
            if (!StiValidationUtil.isNullOrEmpty((String)values[7])) {
                border.setShadowBrush(Deserialize.Brush(values[7]));
            }
            return border;
        }

        public static StiColor Color(String value) {
            if (value.indexOf(",") != -1) {
                String[] strs = StiStringUtil.split((String)value, (String)",");
                if (strs.length == 4) {
                    return StiColor.fromArgb(Integer.parseInt(strs[0].trim()), Integer.parseInt(strs[1].trim()), Integer.parseInt(strs[2].trim()), Integer.parseInt(strs[3].trim()));
                }
                return StiColor.fromArgb(Integer.parseInt(strs[0].trim()), Integer.parseInt(strs[1].trim()), Integer.parseInt(strs[2].trim()));
            }
            if (value.startsWith("#")) {
                throw new RuntimeException("Unknown color" + value);
            }
            return StiColorEnum.valueOf(value).color();
        }

        public static StiBrush Brush(JProperty prop) throws JSONException {
            if (!(prop.Value instanceof JSONObject)) {
                return Deserialize.Brush((String)prop.Value);
            }
            return StiBrush.LoadFromJson((JSONObject)prop.Value);
        }

        private static StiBrush Brush(String text) {
            String[] values = StiStringUtil.split((String)text, (String)":");
            if (values[0].equals("empty")) {
                return new StiEmptyBrush();
            }
            if (values[0].equals("glass")) {
                StiGlassBrush glass = new StiGlassBrush();
                if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                    glass.setColor(Deserialize.Color(values[1]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                    glass.setDrawHatch(true);
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[3])) {
                    glass.setBlend(Float.parseFloat(values[3]));
                }
                return glass;
            }
            if (values[0].equals("glare")) {
                StiGlareBrush glare = new StiGlareBrush();
                if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                    glare.setStartColor(Deserialize.Color(values[1]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                    glare.setEndColor(Deserialize.Color(values[2]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[3])) {
                    glare.setAngle(Double.parseDouble(values[3]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[4])) {
                    glare.setFocus(Float.parseFloat(values[4]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[5])) {
                    glare.setScale(Float.parseFloat(values[5]));
                }
                return glare;
            }
            if (values[0].equals("hatch")) {
                StiHatchBrush hatch = new StiHatchBrush();
                if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                    hatch.setBackColor(Deserialize.Color(values[1]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                    hatch.setForeColor(Deserialize.Color(values[2]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[3])) {
                    hatch.setStyle(StiHatchStyle.valueOf(values[3]));
                }
                return hatch;
            }
            if (values[0].equals("gradient")) {
                StiGradientBrush gradient = new StiGradientBrush();
                if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                    gradient.setStartColor(Deserialize.Color(values[1]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[2])) {
                    gradient.setEndColor(Deserialize.Color(values[2]));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)values[3])) {
                    gradient.setAngle(Double.parseDouble(values[3]));
                }
                return gradient;
            }
            if (values[0].equals("solid")) {
                StiSolidBrush solid = new StiSolidBrush();
                if (!StiValidationUtil.isNullOrEmpty((String)values[1])) {
                    solid.setColor(Deserialize.Color(values[1]));
                }
                return solid;
            }
            return null;
        }

        public static StiColor[] ColorArray(JSONObject jObject) throws NumberFormatException, JSONException {
            StiColor[] result = new StiColor[jObject.length()];
            int index = 0;
            for (JProperty prop : jObject.Properties()) {
                String[] strs;
                String value = prop.Value.toString();
                result[index] = value.indexOf(",") != -1 ? ((strs = StiStringUtil.split((String)value, (String)",")).length == 4 ? StiColor.fromArgb(Integer.parseInt(strs[0].trim()), Integer.parseInt(strs[1].trim()), Integer.parseInt(strs[2].trim()), Integer.parseInt(strs[3].trim())) : StiColor.fromArgb(Integer.parseInt(strs[0].trim()), Integer.parseInt(strs[1].trim()), Integer.parseInt(strs[2].trim()))) : StiColorEnum.valueOf(value).color();
                ++index;
            }
            return result;
        }

        public static StiDateTime DateTime(JProperty prop) throws JSONException {
            Object obj = prop.Value;
            Calendar cal = Calendar.getInstance();
            if (obj instanceof String) {
                int index;
                String value = ((String)prop.Value).substring(6, ((String)prop.Value).length() - 2);
                long coeff = 1L;
                if (value.startsWith("-")) {
                    value = value.substring(1);
                    coeff = -1L;
                }
                if ((index = value.indexOf("-") + value.indexOf("+")) == -2) {
                    cal.setTimeInMillis(Long.parseLong(value) + 21600000L);
                } else {
                    cal.setTimeInMillis(Long.parseLong(value.substring(0, (index == -2 ? value.length() - 1 : index) + 1)) * coeff);
                    cal.set(15, (Integer.parseInt(value.substring(index + 3, index + 4)) * 60 + Integer.parseInt(value.substring(index + 4, index + 5))) * 60 * 1000);
                }
                JSONObject.dateFormat.format(cal.getTime());
                return new StiDateTime(cal);
            }
            if (obj instanceof Long) {
                cal.setTimeInMillis((Long)obj);
                return new StiDateTime(cal);
            }
            return new StiDateTime(Calendar.getInstance());
        }

        public static StiRectangle RectangleD(JProperty prop) throws JSONException {
            if (!(prop.Value instanceof JSONObject)) {
                String text = (String)prop.Value;
                String[] values = StiStringUtil.split((String)text, (String)",");
                if (values.length != 4) {
                    throw new RuntimeException("Parsing Error");
                }
                return new StiRectangle(Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2]), Double.parseDouble(values[3]));
            }
            StiRectangle rect = new StiRectangle();
            rect.LoadFromJson((JSONObject)prop.Value);
            return rect;
        }

        public static StiSize SizeD(JProperty prop) throws JSONException {
            if (!(prop.Value instanceof JSONObject)) {
                String text = (String)prop.Value;
                String[] values = StiStringUtil.split((String)text, (String)",");
                if (values.length != 2) {
                    throw new RuntimeException("Parsing Error");
                }
                return new StiSize(Double.parseDouble(values[0]), Double.parseDouble(values[1]));
            }
            StiSize size = new StiSize();
            for (JProperty pr : ((JSONObject)prop.Value).Properties()) {
                if (prop.Name.equals("width")) {
                    size.width = Integer.parseInt(pr.Value.toString());
                    continue;
                }
                if (!prop.Name.equals("height")) continue;
                size.height = Integer.parseInt(pr.Value.toString());
            }
            return size;
        }

        public static StiPoint Point(JSONObject jObject) throws JSONException {
            StiPoint point = new StiPoint();
            for (JProperty property : jObject.Properties()) {
                if (property.Name.equals("X")) {
                    point.x = property.doubleValue();
                    continue;
                }
                if (!property.Name.equals("Y")) continue;
                point.y = property.doubleValue();
            }
            return point;
        }

        public static StiPoint PointF(JSONObject jObject) throws JSONException {
            return Deserialize.Point(jObject);
        }
    }

    public static class Serialize {
        public static String fontDefault(StiFont font) {
            return Serialize.font(font, "Arial", 8.0f, StiFontStyle.Regular.intValue);
        }

        public static String font(StiFont font, String defaultFamily, float defaultEmSize) {
            return Serialize.font(font, defaultFamily, defaultEmSize, StiFontStyle.Regular.intValue);
        }

        public static String font(StiFont font, String defaultFamily, float defaultEmSize, int defaultStyle) {
            String fontFamily = "";
            String size = "";
            String style = "";
            String unit = "";
            int count = 0;
            if (!font.getName().equals(defaultFamily)) {
                ++count;
                fontFamily = font.getName();
            }
            if (font.getSize() != (double)defaultEmSize) {
                ++count;
                size = String.valueOf(font.getSize());
            }
            if (font.getFontStyle() != defaultStyle) {
                ++count;
                style = font.getStylesStr(", ");
            }
            if (count == 0) {
                return null;
            }
            return fontFamily + ";" + size + ";" + style + ";" + unit;
        }

        public static String rectangleD(StiRectangle rect) {
            return rect.x + "," + rect.y + "," + rect.width + "," + rect.height;
        }

        public static String sizeD(StiSize size) {
            return size.width + "," + size.height;
        }

        public static String jColor(StiColor color, StiColor defColor) {
            if (color.equals(defColor)) {
                return null;
            }
            return Serialize.jColor(color);
        }

        public static String JColor(StiColor color, StiColorEnum defColor) {
            if (color.equals(defColor.color())) {
                return null;
            }
            return Serialize.jColor(color);
        }

        public static String jColor(StiColor color) {
            if (StiValidationUtil.isNotNullOrEmpty((String)color.getName()) && !"Custom".equals(color.getName())) {
                return color.getName();
            }
            if (color.getA() == 255) {
                return String.valueOf(color.getR()) + "," + String.valueOf(color.getG()) + "," + String.valueOf(color.getB());
            }
            return String.valueOf(color.getA()) + "," + String.valueOf(color.getR()) + "," + String.valueOf(color.getG()) + "," + String.valueOf(color.getB());
        }

        public static JSONObject colorArray(StiColor[] array) throws JSONException {
            JSONObject jObject = new JSONObject();
            for (int index = 0; index < array.length; ++index) {
                StiColor color = array[index];
                String colorStr = Serialize.jColor(color);
                jObject.put(String.valueOf(index), colorStr);
            }
            return jObject;
        }

        public static JSONObject StringArray(String[] array) throws JSONException {
            if (array == null || array.length == 0) {
                return null;
            }
            JSONObject jObject = new JSONObject();
            for (int index = 0; index < array.length; ++index) {
                jObject.put(String.valueOf(index), array[index]);
            }
            return jObject;
        }

        public static JSONObject StringArray(List<String> array) throws JSONException {
            if (array == null || array.size() == 0) {
                return null;
            }
            JSONObject jObject = new JSONObject();
            for (int index = 0; index < array.size(); ++index) {
                jObject.put(String.valueOf(index), array.get(index));
            }
            return jObject;
        }

        public static JSONObject IntArray(int[] array) throws JSONException {
            if (array == null || array.length == 0) {
                return null;
            }
            JSONObject jObject = new JSONObject();
            for (int index = 0; index < array.length; ++index) {
                jObject.putNullOfEmpty(String.valueOf(index), array[index]);
            }
            return jObject;
        }

        public static JSONObject IntArray(List<Integer> array) throws JSONException {
            if (array == null || array.size() == 0) {
                return null;
            }
            JSONObject jObject = new JSONObject();
            for (int index = 0; index < array.size(); ++index) {
                jObject.putNullOfEmpty(String.valueOf(index), array.get(index));
            }
            return jObject;
        }

        public static JSONObject size(StiSize size) throws JSONException {
            JSONObject jObject = new JSONObject();
            jObject.put("Width", size.width);
            jObject.put("Height", size.height);
            return jObject;
        }

        public static JSONObject point(StiPoint pos) throws JSONException {
            JSONObject jObject = new JSONObject();
            jObject.putNullOfEmpty("X", pos.x);
            jObject.putNullOfEmpty("Y", pos.y);
            return jObject;
        }

        public static JSONObject pointF(StiPoint pos) throws JSONException {
            JSONObject jObject = new JSONObject();
            jObject.putNullOfEmpty("X", pos.x);
            jObject.putNullOfEmpty("Y", pos.y);
            return jObject;
        }

        public static String jCap(StiCap cap) {
            StiStringBuilder builder = new StiStringBuilder();
            if (cap.getWidth() != 10) {
                builder.append(cap.getWidth());
            }
            builder.append(";");
            if (cap.getHeight() != 10) {
                builder.append(cap.getHeight());
            }
            builder.append(";");
            if (cap.getStyle() != StiCapStyle.None) {
                builder.append(cap.getStyle().toString());
            }
            builder.append(";");
            builder.append(Serialize.jColor(cap.getColor(), StiColorEnum.Black.color()));
            return builder.toString();
        }

        public static String JBrush(StiBrush brush) {
            return Serialize.JBrush(brush, null);
        }

        public static String JBrush(StiBrush brush, StiBrush defaultBrush) {
            StiStringBuilder builder = new StiStringBuilder();
            if (brush instanceof StiSolidBrush) {
                StiSolidBrush solid = (StiSolidBrush)brush;
                builder.append("solid:");
                builder.append(Serialize.jColor(solid.getColor(), StiColorEnum.Transparent.color()));
            } else if (brush instanceof StiEmptyBrush) {
                builder.append("empty");
            } else if (brush instanceof StiGlareBrush) {
                StiGlareBrush glare = (StiGlareBrush)brush;
                builder.append("glare:");
                builder.append(Serialize.jColor(glare.getStartColor(), StiColorEnum.Black.color()));
                builder.append(":");
                builder.append(Serialize.jColor(glare.getEndColor(), StiColorEnum.White.color()));
                builder.append(":");
                if (glare.getAngle() != 0.0) {
                    builder.append(glare.getAngle());
                }
                builder.append(":");
                if (glare.getFocus() != 0.5f) {
                    builder.append(glare.getFocus());
                }
                builder.append(":");
                if (glare.getScale() != 1.0f) {
                    builder.append(glare.getScale());
                }
            } else if (brush instanceof StiGlassBrush) {
                StiGlassBrush glass = (StiGlassBrush)brush;
                builder.append("glass:");
                builder.append(Serialize.jColor(glass.getColor(), StiColorEnum.Silver.color()));
                builder.append(":");
                if (glass.getDrawHatch()) {
                    builder.append(glass.getDrawHatch());
                }
                builder.append(":");
                if (glass.getBlend() != 0.2f) {
                    builder.append(glass.getBlend());
                }
            } else if (brush instanceof StiGradientBrush) {
                StiGradientBrush gradient = (StiGradientBrush)brush;
                builder.append("gradient:");
                builder.append(Serialize.jColor(gradient.getStartColor(), StiColorEnum.Black.color()));
                builder.append(":");
                builder.append(Serialize.jColor(gradient.getEndColor(), StiColorEnum.White.color()));
                builder.append(":");
                if (gradient.getAngle() != 0.0) {
                    builder.append(gradient.getAngle());
                }
            } else if (brush instanceof StiHatchBrush) {
                StiHatchBrush hatch = (StiHatchBrush)brush;
                builder.append("hatch:");
                builder.append(Serialize.jColor(hatch.getBackColor(), StiColorEnum.Black.color()));
                builder.append(":");
                builder.append(Serialize.jColor(hatch.getForeColor(), StiColorEnum.White.color()));
                builder.append(":");
                if (hatch.getStyle() != StiHatchStyle.BackwardDiagonal) {
                    builder.append(hatch.getStyle().toString());
                }
            }
            return builder.toString();
        }

        public static String jBorderSide(StiBorderSide side) {
            String color = Serialize.jColor(side.getColor(), StiColorEnum.Black.color());
            String size = "";
            if (side.getSize() != 1.0) {
                size = String.valueOf(side.getSize());
            }
            String style = "";
            if (side.getStyle() != StiPenStyle.None) {
                style = side.getStyle().toString();
            }
            return (color != null ? color : "") + ":" + size + ":" + style;
        }

        public static String JBorder(StiBorder border) {
            return Serialize.jBorder(border);
        }

        public static String jBorder(StiBorder border) {
            StiAdvancedBorder advancedBorder;
            StiStringBuilder builder = new StiStringBuilder();
            StiAdvancedBorder stiAdvancedBorder = advancedBorder = border instanceof StiAdvancedBorder ? (StiAdvancedBorder)border : null;
            if (advancedBorder != null) {
                builder.append(Serialize.jBorderSide(advancedBorder.getTopSide()));
                builder.append(";");
                builder.append(Serialize.jBorderSide(advancedBorder.getBottomSide()));
                builder.append(";");
                builder.append(Serialize.jBorderSide(advancedBorder.getLeftSide()));
                builder.append(";");
                builder.append(Serialize.jBorderSide(advancedBorder.getRightSide()));
                builder.append(";");
                if (border.getDropShadow()) {
                    builder.append(border.getDropShadow());
                }
                builder.append(";");
                if (border.getShadowSize() != 4.0) {
                    builder.append(border.getShadowSize());
                }
                builder.append(";");
                builder.append(Serialize.JBrush(border.getShadowBrush(), new StiSolidBrush(StiColorEnum.Black.color())));
            } else {
                if (!border.getSide().containsOnly(StiBorderSides.None) && border.getSide().size() > 0) {
                    builder.append(border.getSide().toString());
                }
                builder.append(";");
                if (!border.getColor().equals(StiColorEnum.Black.color())) {
                    builder.append(Serialize.jColor(border.getColor()));
                }
                builder.append(";");
                if (border.getSize() != 1.0) {
                    builder.append(border.getSize());
                }
                builder.append(";");
                if (border.getStyle() != StiPenStyle.Solid) {
                    builder.append(border.getStyle().toString());
                }
                builder.append(";");
                if (border.getShadowSize() != 4.0) {
                    builder.append(border.getShadowSize());
                }
                builder.append(";");
                if (border.getDropShadow()) {
                    builder.append(border.getDropShadow());
                }
                builder.append(";");
                if (border.getTopmost()) {
                    builder.append(border.getTopmost());
                }
                builder.append(";");
                builder.append(Serialize.JBrush(border.getShadowBrush(), new StiSolidBrush(StiColorEnum.Black.color())));
            }
            return builder.toString();
        }
    }
}

