/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.utils.StiConvertHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.math.BigDecimal;

public class StiObjectConverter {
    public static BigDecimal ConvertToDecimal(Object value) {
        if (value == null || StiValidationUtil.isNullOrEmpty((String)value.toString())) {
            return new BigDecimal(0);
        }
        return new BigDecimal(value.toString().replace(',', '.'));
    }

    public static double ConvertToDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof String) {
            return Double.parseDouble(((String)value).replace(".", ",").replace(',', StiConvertHelper.DECIMAL_SEPARATOR));
        }
        return Double.valueOf(value.toString());
    }

    public static long ConvertToInt64(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Double) {
            Double valuDouble = (Double)value;
            return valuDouble.longValue();
        }
        return (Long)value;
    }

    public static String ConvertToString(byte[] bytes) {
        if (bytes != null) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        return "";
    }
}

