/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import java.util.concurrent.ConcurrentHashMap;

public enum StiTokenType {
    Empty(0),
    Delimiter(1),
    Variable(2),
    SystemVariable(3),
    DataSourceField(4),
    BusinessObjectField(5),
    Number(6),
    Function(7),
    Method(8),
    Property(9),
    Component(10),
    Cast(11),
    String(12),
    Dot(13),
    Comma(14),
    Colon(15),
    SemiColon(16),
    Shl(17),
    Shr(18),
    Assign(19),
    Equal(20),
    NotEqual(21),
    LeftEqual(22),
    Left(23),
    RightEqual(24),
    Right(25),
    Not(26),
    Or(27),
    And(28),
    Xor(29),
    DoubleOr(30),
    DoubleAnd(31),
    Question(32),
    Plus(33),
    Minus(34),
    Mult(35),
    Div(36),
    Percent(37),
    LParenthesis(38),
    RParenthesis(39),
    LBracket(40),
    RBracket(41),
    Identifier(42),
    Value(44),
    Ident(45),
    LPar(46),
    RPar(47),
    LBrace(48),
    RBrace(49),
    Euro(50),
    Copyright(51),
    Splash(52),
    Sharp(53),
    Dollar(54),
    Ampersand(55),
    DoublePlus(56),
    DoubleMinus(57),
    Unknown(43),
    CustomFunction(98),
    EOF(99);

    private final int intValue;
    private static ConcurrentHashMap<Integer, StiTokenType> mappings;

    private static synchronized ConcurrentHashMap<Integer, StiTokenType> getMappings() {
        if (mappings == null) {
            mappings = new ConcurrentHashMap();
        }
        return mappings;
    }

    private StiTokenType(int value) {
        this.intValue = value;
        StiTokenType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static StiTokenType forValue(int value) {
        return StiTokenType.getMappings().get(value);
    }
}

