/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.StiFont;
import java.awt.Color;
import java.awt.Font;
import java.util.List;

public class StiGlyph {
    public String text;
    public double width;
    public double height;
    public StiFont font;
    public boolean underline;
    public Font awtFont;
    public Color color;
    public Color backColor;
    public StiColor stiColor;
    public double descent;
    public double underlineOffset;
    public double underlineThickness;
    public StiHtmlTagsState ts;

    public String toString() {
        return this.text;
    }

    public String openTag() {
        StringBuilder sb = new StringBuilder();
        sb.append("<font style=\"");
        sb.append("font-family:" + this.ts.fontName + ";");
        sb.append("font-size:" + this.ts.fontSize + "pt;");
        sb.append("color:" + this.ts.fontColor.toHTML() + ";");
        if (this.ts.bold) {
            sb.append("font-weight:bold;");
        }
        if (this.ts.italic) {
            sb.append("font-style:italic;");
        }
        if (this.ts.underline) {
            sb.append("text-decoration:underline;");
        }
        if (this.ts.strikeout) {
            sb.append("text-decoration:line-through;");
        }
        sb.append("background-color:" + this.ts.backColor.toRGBAhtml() + ";");
        if (this.ts.subscript) {
            sb.append("vertical-align:sub;");
        }
        if (this.ts.superscript) {
            sb.append("vertical-align:super;");
        }
        sb.append("letter-spacing:" + this.ts.letterSpacing + "px;");
        sb.append("word-spacing:" + this.ts.wordSpacing + "px;");
        sb.append("line-height:" + this.ts.lineHeight + ";");
        sb.append("text-align:" + (this.ts.textAlign == StiTextHorAlignment.Width ? "center" : this.ts.textAlign.toString().toLowerCase()));
        sb.append("\">");
        return sb.toString();
    }

    public String closeTag() {
        return "</font>";
    }

    public static String toHTML(List<StiGlyph> glyphs) {
        if (glyphs.size() > 0) {
            StringBuilder sb = new StringBuilder();
            StiGlyph lastGlyph = null;
            for (StiGlyph glyph : glyphs) {
                if (lastGlyph == null || lastGlyph.ts != glyph.ts) {
                    if (lastGlyph != null) {
                        sb.append("</font>");
                    }
                    lastGlyph = glyph;
                    sb.append(glyph.openTag());
                }
                sb.append("\n".equals(glyph.text) ? "<br>" : glyph.text);
            }
            sb.append("</font>");
            return sb.toString();
        }
        return "";
    }
}

