/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;

public class StiGradientBrush
extends StiBrush {
    private StiColor startColor;
    private StiRectangle rectangle = new StiRectangle(0L, 0L, 0L, 0L);
    private Point2D startGradiendPoint = new Point2D.Float();
    private Point2D endGradiendPoint = new Point2D.Float();
    private StiColor endColor;
    public double angle;

    public final StiColor getStartColor() {
        return this.startColor;
    }

    @Override
    public String serialize() {
        return StiSerializerUtil.serializFormat("GradientBrush,{0},{1},{2}", this.startColor.serializeString(), this.endColor.serializeString(), this.angle);
    }

    @Override
    public void deserialize(String value) {
        String[] values = value.split(",");
        this.startColor = StiColor.deserializeString(values[1]);
        this.endColor = StiColor.deserializeString(values[2]);
        this.angle = StiSerializTypeConverter.stringToDouble(values[3]);
    }

    public final void setStartColor(StiColor value) {
        this.startColor = value;
        this.invalidate();
    }

    private void updateGradientPoints() {
        StiRectangle rect_ = this.getRectangle();
        Double angle1 = this.getAngle() % 180.0 > 0.0 ? this.getAngle() % 180.0 : 180.0 + this.getAngle() % 180.0;
        if (angle1 <= 45.0) {
            this.startGradiendPoint.setLocation(rect_.getX(), rect_.getY() + rect_.getHeight() / 2.0 * (45.0 - angle1) / 45.0);
        } else if (angle1 < 135.0) {
            this.startGradiendPoint.setLocation(rect_.getX() + rect_.getWidth() * (angle1 - 45.0) / 90.0, rect_.getY());
        } else {
            this.startGradiendPoint.setLocation(rect_.getRight(), rect_.getY() + rect_.getHeight() / 2.0 * (angle1 - 135.0) / 45.0);
        }
        Double x0 = rect_.getLeft() + rect_.getWidth() / 2.0;
        Double y0 = rect_.getTop() + rect_.getHeight() / 2.0;
        this.endGradiendPoint.setLocation(this.startGradiendPoint.getX() + (x0 - this.startGradiendPoint.getX()) * 2.0, this.startGradiendPoint.getY() + (y0 - this.startGradiendPoint.getY()) * 2.0);
        Double angle2 = this.getAngle() % 360.0;
        if (angle2 > 180.0 || angle2 <= 0.0 && angle2 > -180.0) {
            Point2D tempPoint2d = this.startGradiendPoint;
            this.startGradiendPoint = this.endGradiendPoint;
            this.endGradiendPoint = tempPoint2d;
        }
    }

    public final StiColor getEndColor() {
        return this.endColor;
    }

    public final void setEndColor(StiColor value) {
        this.endColor = value;
        this.invalidate();
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double value) {
        this.angle = value;
        this.invalidate();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiGradientBrush brush = (StiGradientBrush)(obj instanceof StiGradientBrush ? obj : null);
        if (brush == null) {
            return false;
        }
        if (this.angle != brush.angle) {
            return false;
        }
        if (this.endColor != brush.endColor) {
            return false;
        }
        return this.startColor == brush.startColor;
    }

    private boolean ShouldSerializeStartColor() {
        return this.startColor != StiColor.White;
    }

    private boolean ShouldSerializeEndColor() {
        return this.endColor != StiColor.Black;
    }

    private boolean ShouldSerializeAngle() {
        return this.angle != 0.0;
    }

    public Paint getPaint() {
        return new GradientPaint(this.getStartGradiendPoint(), this.getStartColor().getAwtColor(), this.getEndGradiendPoint(), this.getEndColor().getAwtColor());
    }

    public StiGradientBrush() {
        this.startColor = StiColor.Black;
        this.endColor = StiColor.White;
        this.angle = 0.0;
    }

    public StiGradientBrush(StiColor startColor, StiColor endColor, double angle) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.angle = angle;
    }

    public StiRectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(StiRectangle rectangle) {
        this.rectangle = rectangle;
        this.updateGradientPoints();
    }

    public Point2D getStartGradiendPoint() {
        return this.startGradiendPoint;
    }

    public void setStartGradiendPoint(Point2D startGradiendPoint) {
        this.startGradiendPoint = startGradiendPoint;
    }

    public Point2D getEndGradiendPoint() {
        return this.endGradiendPoint;
    }

    public void setEndGradiendPoint(Point2D endGradiendPoint) {
        this.endGradiendPoint = endGradiendPoint;
    }

    public void LoadValuesFromJson(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("StartColor")) {
                this.setStartColor(StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("EndColor")) {
                this.setEndColor(StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString()));
                continue;
            }
            if (!property.Name.equals("Angle")) continue;
            this.setAngle(property.doubleValue());
        }
    }
}

