/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.exception;

import com.stimulsoft.base.localization.StiLocalization;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class StiExceptionSaveDialog
extends JFileChooser {
    private static final long serialVersionUID = -2336194278751809560L;
    private static final String EXCEPTION = "txt";

    public StiExceptionSaveDialog() {
        this.setSelectedFile(new File("Exception"));
        this.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Text Files (*.txt)";
            }

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(StiExceptionSaveDialog.EXCEPTION) || f.isDirectory();
            }
        });
    }

    public File getFile() {
        if (this.getSelectedFile() != null) {
            File result = this.getSelectedFile();
            if (!result.getAbsolutePath().toLowerCase().endsWith(EXCEPTION)) {
                result = new File(result.getAbsolutePath() + "." + EXCEPTION);
            }
            return result;
        }
        return null;
    }

    @Override
    public void approveSelection() {
        if (this.getFile() != null && this.getFile().exists()) {
            if (0 == JOptionPane.showConfirmDialog(this, String.format(StiLocalization.getValue("Dialogs", "ConfirmOverwriteExistPrompt"), this.getFile().getAbsolutePath()), StiLocalization.getValue("Dialogs", "ConfirmSaveExistCaption"), 0)) {
                super.approveSelection();
            }
        } else {
            super.approveSelection();
        }
    }
}

