/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.json;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class StiJSONHelper {
    public static HashMap<String, Object> jsonToHash(JSONObject json) {
        Iterator it = json.keys();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                result.put(key, json.get(key) != JSONObject.NULL ? json.get(key) : null);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Hashtable<String, String> jsonToStringHash(JSONObject json) {
        Iterator it = json.keys();
        Hashtable<String, String> result = new Hashtable<String, String>();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                result.put(key, json.getString(key));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<Object> isJsonFile(InputStream input) throws IOException {
        int bytesRead;
        ArrayList<Object> result = new ArrayList<Object>();
        if (input.available() < 2) {
            result.add(false);
            result.add(input);
            return result;
        }
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        byte[] buf = output.toByteArray();
        output.close();
        input.close();
        result.add(buf[0] == 123);
        result.add(new ByteArrayInputStream(buf));
        return result;
    }
}

