/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.text.MessageFormat;

public class DateTimeRange
extends Range {
    public StiDateTime From = null;
    public StiDateTime To = null;

    public final StiDateTime getFromDate() {
        if (this.From == null) {
            return StiDateTime.minValue;
        }
        return this.From;
    }

    public final StiDateTime getToDate() {
        if (this.From == null) {
            return StiDateTime.MaxValue;
        }
        return this.To;
    }

    @Override
    public String getRangeName() {
        return "DateTimeRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemDateTime;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof StiDateTime) {
            this.From = (StiDateTime)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof StiDateTime) {
            this.To = (StiDateTime)value;
        }
    }

    public final boolean Contains(StiDateTime value) {
        if (this.From == null && this.To == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (this.From == null && this.To != null) {
            return this.To.getValue() >= value.getValue();
        }
        if (this.From != null && this.To == null) {
            return this.From.getValue() <= value.getValue();
        }
        return this.From.getValue() <= value.getValue() && this.To.getValue() >= value.getValue();
    }

    public DateTimeRange() {
    }

    public DateTimeRange(StiDateTime from, StiDateTime to) {
        this.From = from;
        this.To = to;
    }

    public static DateTimeRange fromString(String strObject) {
        DateTimeRange result = new DateTimeRange();
        result.deserialize(strObject);
        return result;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        String strFrom = StiXMLConvert.decodeName(values[1]).trim();
        String strTo = StiXMLConvert.decodeName(values[2]).trim();
        this.From = StiValidationUtil.isNullOrEmpty((String)strFrom) ? null : StiDateTime.fromString(strFrom);
        this.To = StiValidationUtil.isNullOrEmpty((String)strTo) ? null : StiDateTime.fromString(strTo);
    }

    @Override
    public String serialize() {
        String data = MessageFormat.format(this.getSerializeName() + ",{0},{1}", this.From.toString("MM/dd/yyyy hh:mm:ss a"), this.To.toString("MM/dd/yyyy hh:mm:ss a"));
        return data;
    }

    @Override
    protected String getSerializeName() {
        return "DateTime";
    }

    public static DateTimeRange fromSerializeValue(String str) {
        DateTimeRange result = new DateTimeRange();
        result.deserialize(str);
        return result;
    }
}

