/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import java.text.MessageFormat;

public class DoubleRange
extends Range {
    public double From = 0.0;
    public double To = 0.0;

    @Override
    public String getRangeName() {
        return "DoubleRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemDouble;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof Double) {
            this.From = (Double)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof Double) {
            this.To = (Double)value;
        }
    }

    public final boolean Contains(double value) {
        return this.From <= value && this.To >= value;
    }

    public DoubleRange() {
    }

    public DoubleRange(double from, double to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public String serialize() {
        String data = MessageFormat.format(this.getSerializeName() + ",{0},{1}", StiXMLConvert.encodeName(StiSerializTypeConverter.doubleToString(this.From)), StiXMLConvert.encodeName(StiSerializTypeConverter.doubleToString(this.To)));
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = StiSerializTypeConverter.stringToDouble(StiXMLConvert.decodeName(values[1]));
        this.To = StiSerializTypeConverter.stringToDouble(StiXMLConvert.decodeName(values[2]));
    }

    @Override
    protected String getSerializeName() {
        return "Double";
    }

    public static DoubleRange fromSerializeValue(String str) {
        DoubleRange result = new DoubleRange();
        result.deserialize(str);
        return result;
    }
}

