/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.base.serializing.ProcessingReferences;
import com.stimulsoft.base.serializing.SerializeMode;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.serializing.StiDeserializerDocument;
import com.stimulsoft.base.serializing.StiDeserializerDocumentThread;
import com.stimulsoft.base.serializing.StiDeserializerFromXmlString;
import com.stimulsoft.base.serializing.StiDeserializerReport;
import com.stimulsoft.base.serializing.StiProperty;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.StiDeserializationDispatcher;
import com.stimulsoft.lib.io.StiFileUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StiDeserializerControler {
    private final ProcessingReferences processingReferences = new ProcessingReferences();
    private final SerializeMode serializeMode;

    public StiDeserializerControler(SerializeMode serializeMode) {
        this.serializeMode = serializeMode;
    }

    public static IStiSerializable deserializeReport(File file, Class<? extends IStiSerializable> clazz) throws IOException, SAXException, StiDeserializationException {
        IStiSerializable newInstance;
        try {
            newInstance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new StiDeserializationException(e);
        }
        return StiDeserializerControler.deserializeReport(file, newInstance);
    }

    public static IStiSerializable deserializeReport(File file, IStiSerializable instance) throws IOException, SAXException, StiDeserializationException {
        return StiDeserializerControler.deserializeReport(file, instance, null);
    }

    public static IStiSerializable deserializeReport(File file, IStiSerializable instance, Hashtable<String, Object> memoryStore) throws IOException, SAXException, StiDeserializationException {
        StiFileUtil.checkReadFile((File)file);
        InputStream fis = null;
        try {
            fis = new FileInputStream(file);
            List<Object> json = StiJSONHelper.isJsonFile(fis);
            boolean isJson = (Boolean)json.get(0);
            fis = (InputStream)json.get(1);
            if (!isJson) {
                IStiSerializable result;
                Document document = StiXmlUtil.parseXmlInputStream((InputStream)fis);
                IStiSerializable iStiSerializable = result = StiDeserializerControler.deserializeReportWithoutException(document, instance, memoryStore, true);
                return iStiSerializable;
            }
            instance.getClass().getMethod("loadFromJson", String.class).invoke((Object)instance, StiIOUtil.toString((InputStream)fis));
            IStiSerializable iStiSerializable = instance;
            return iStiSerializable;
        }
        catch (Exception e) {
            throw new StiDeserializationException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static IStiSerializable deserializeReport(InputStream is, IStiSerializable instance) throws IOException, SAXException, StiDeserializationException {
        return StiDeserializerControler.deserializeReport(is, instance, null);
    }

    public static IStiSerializable deserializeReport(InputStream is, IStiSerializable instance, Hashtable<String, Object> memoryStore) throws IOException, SAXException, StiDeserializationException {
        return StiDeserializerControler.deserializeReport(is, instance, memoryStore, true);
    }

    public static IStiSerializable deserializeReport(InputStream is, IStiSerializable instance, Hashtable<String, Object> memoryStore, Boolean allowException) throws IOException, SAXException, StiDeserializationException {
        try {
            List<Object> json = StiJSONHelper.isJsonFile(is);
            boolean isJson = (Boolean)json.get(0);
            is = (InputStream)json.get(1);
            if (!isJson) {
                Document document = StiXmlUtil.parseXmlInputStream((InputStream)is);
                IStiSerializable result = StiDeserializerControler.deserializeReportWithoutException(document, instance, memoryStore, allowException);
                return result;
            }
            instance.getClass().getMethod("loadFromJson", String.class).invoke((Object)instance, StiIOUtil.toString((InputStream)is));
            return instance;
        }
        catch (Exception e) {
            throw new StiDeserializationException(e);
        }
    }

    public static IStiSerializable deserializeReportWithoutException(Document document, IStiSerializable instance, Hashtable<String, Object> memoryStore, Boolean allowException) {
        StiDeserializerControler controler = new StiDeserializerControler(SerializeMode.report);
        Object result = new StiDeserializerReport(controler, instance, document.getFirstChild(), memoryStore).deserialize();
        controler.addReferences((IStiSerializable)result, "0");
        controler.finish(allowException);
        return result;
    }

    public static IStiSerializable deserializeDocument(File file, Class<? extends IStiSerializable> clazz) {
        InputStream fis = null;
        try {
            fis = new FileInputStream(file);
            List<Object> json = StiJSONHelper.isJsonFile(fis);
            boolean isJson = (Boolean)json.get(0);
            fis = (InputStream)json.get(1);
            if (!isJson) {
                Document document = StiXmlUtil.parseXmlInputStream((InputStream)fis);
                IStiSerializable iStiSerializable = StiDeserializerControler.deserializeDocument(document, clazz);
                return iStiSerializable;
            }
            IStiSerializable doc = null;
            doc = (IStiSerializable)Class.forName("com.stimulsoft.report.saveLoad.StiDocument").newInstance();
            Object report = Class.forName("com.stimulsoft.report.StiReport").getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
            report.getClass().getMethod("loadFromJson", String.class).invoke(report, StiIOUtil.toString((InputStream)new FileInputStream(file)));
            doc.getClass().getMethod("setReport", Class.forName("com.stimulsoft.report.StiReport")).invoke((Object)doc, report);
            IStiSerializable iStiSerializable = doc;
            return iStiSerializable;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static IStiSerializable deserializeDocument(InputStream is, Class<? extends IStiSerializable> clazz) {
        try {
            List<Object> json = StiJSONHelper.isJsonFile(is);
            boolean isJson = (Boolean)json.get(0);
            is = (InputStream)json.get(1);
            if (!isJson) {
                Document document = StiXmlUtil.parseXmlInputStream((InputStream)is);
                return StiDeserializerControler.deserializeDocument(document, clazz);
            }
            IStiSerializable doc = null;
            doc = (IStiSerializable)Class.forName("com.stimulsoft.report.saveLoad.StiDocument").newInstance();
            Object report = Class.forName("com.stimulsoft.report.StiReport").getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
            report.getClass().getMethod("loadFromJson", String.class).invoke(report, StiIOUtil.toString((InputStream)is));
            doc.getClass().getMethod("setReport", Class.forName("com.stimulsoft.report.StiReport")).invoke((Object)doc, report);
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IStiSerializable deserializeDocument(Document document, Class<? extends IStiSerializable> clazz) {
        StiDeserializerControler controler = new StiDeserializerControler(SerializeMode.document);
        Object result = new StiDeserializerDocument(controler, clazz, document.getFirstChild()).deserialize();
        controler.addReferences((IStiSerializable)result, "0");
        controler.finish();
        return result;
    }

    public static StiDeserializerDocumentThread deserializeDocumentInThread(String fileName, IStiSerializable instance, StiDeserializationDispatcher dispatcher) {
        Document document = StiXmlUtil.parseXmlFile((String)fileName);
        return StiDeserializerControler.deserializeDocumentInThread(document, instance, dispatcher);
    }

    public static StiDeserializerDocumentThread deserializeDocumentInThread(Document document, IStiSerializable instance, StiDeserializationDispatcher dispatcher) {
        StiDeserializerControler controler = new StiDeserializerControler(SerializeMode.document);
        StiDeserializerDocumentThread thread = new StiDeserializerDocumentThread(controler, instance, document.getFirstChild(), dispatcher);
        return thread;
    }

    public static IStiSerializable deserializeFromString(String xmlString, IStiSerializable instance) {
        if (StiValidationUtil.isNotNullOrEmpty((String)xmlString)) {
            Document document = StiXmlUtil.parseFromString((String)xmlString);
            StiDeserializerControler controler = new StiDeserializerControler(SerializeMode.xmlString);
            Object result = new StiDeserializerFromXmlString(controler, instance, document.getFirstChild()).deserializeFromXmlString();
            controler.addReferences((IStiSerializable)result, "0");
            controler.finish();
            return result;
        }
        return null;
    }

    public void addReferenceToObject(Object instance, StiProperty currentProperty, String references) {
        this.processingReferences.addClass(instance, currentProperty.getSETMetod(), references);
    }

    public void addReferences(IStiSerializable instance, String references) {
        this.processingReferences.addRef(instance, references);
    }

    public void finish() {
        this.finish(true);
    }

    public void finish(Boolean allowException) {
        this.processingReferences.finish(allowException);
    }

    public IStiSerializable deserializeBranch(IStiSerializable instance, Node rootNode) {
        return this.deserializeBranch(instance, rootNode, null);
    }

    public IStiSerializable deserializeBranch(IStiSerializable instance, Node rootNode, Hashtable<String, Object> memoryStore) {
        switch (this.serializeMode) {
            case report: {
                return new StiDeserializerReport(this, instance, rootNode, memoryStore).deserialize();
            }
            case document: {
                return new StiDeserializerDocument(this, instance, rootNode).deserialize();
            }
            case xmlString: {
                return new StiDeserializerFromXmlString(this, instance, rootNode).deserialize();
            }
        }
        throw new RuntimeException("\u041d\u0435\u0437\u0430\u0434\u0430\u043d \u0440\u0435\u0436\u0438\u043c \u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
    }
}

