/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.IStiValueCollection;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiValueCollection;
import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.serializing.utils.StiClassConverter;
import com.stimulsoft.base.utils.StiReflectUtill;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;

public class StiProperty
implements IStiName {
    private static final Object[] EMPTY = new Object[0];
    private Class<?> returnClass;
    private String name;
    private Method setMetod;
    private Method getMetod;
    private StiSerializable serializAnnotation;
    private Class<?> contentTypeList;
    private String shortName;

    public StiProperty() {
    }

    public StiProperty(Method getMetod, Method setMetod, String propertyName) {
        this.serializAnnotation = getMetod.getAnnotation(StiSerializable.class);
        this.name = StiValidationUtil.isNotNullOrEmpty((String)propertyName) ? propertyName : StiProperty.getPropertyName(getMetod);
        this.shortName = this.serializAnnotation.shortName();
        this.returnClass = getMetod.getReturnType();
        this.getMetod = getMetod;
        this.setMetod = setMetod;
    }

    public boolean isObject() {
        try {
            return IStiSerializable.class.isAssignableFrom(this.returnClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isReferenceToObject() {
        return this.serializAnnotation.isRef();
    }

    public boolean memoryStore() {
        return this.serializAnnotation.memoryStore();
    }

    public boolean isRefObject() {
        try {
            if (this.isCollection()) {
                return IStiSerializableRef.class.isAssignableFrom(this.contentTypeList);
            }
            return IStiSerializableRef.class.isAssignableFrom(this.returnClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValueList() {
        try {
            return StiValueCollection.class.isAssignableFrom(this.returnClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isCollection() {
        try {
            return List.class.isAssignableFrom(this.returnClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPrimitiveCollection() {
        return this.isCollection() && this.contentListIsPrimitive();
    }

    public boolean contentListIsPrimitive() {
        return StiReflectUtill.isPrimitivParameterizedType(this.returnClass());
    }

    public boolean isEnum() {
        try {
            return this.returnClass.isEnum();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Class<?> correctTypeForList(String type) {
        if (this.isCollection()) {
            this.contentTypeList = StiClassConverter.getJavaClass(type);
            return this.contentTypeList;
        }
        throw new RuntimeException("\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0442.\u043a \u0442\u0435\u043a\u0443\u0436\u0438\u0439 \u0442\u0438\u043f \u043d\u0435\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043f\u0438\u0441\u043a\u043e\u043c " + this.returnClass);
    }

    public Method getSETMetod() {
        return this.setMetod;
    }

    public boolean isSerializableToReport(boolean enhanced) {
        return this.serializAnnotation.type() != StiSerializeTypesEnum.SerializeToDocument && this.serializAnnotation.need() && (!enhanced && !this.serializAnnotation.enhanced() || enhanced);
    }

    public boolean isDeprecated() {
        return this.serializAnnotation.deprecated();
    }

    public boolean isSerializableToDocument() {
        return this.serializAnnotation.type() != StiSerializeTypesEnum.SerializeToSaveLoad && this.serializAnnotation.need();
    }

    public Class<?> returnClass() {
        return this.returnClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getReturnValue(Object instance) {
        try {
            return this.getMetod.invoke(instance, EMPTY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StiSerializable getSerializAnnotation() {
        return this.serializAnnotation;
    }

    public Method getGETMetod() {
        return this.getMetod;
    }

    public boolean isValueCollection() {
        return IStiValueCollection.class.isAssignableFrom(this.returnClass);
    }

    public <T> T getInstance() {
        try {
            return (T)this.returnClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u043d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u043a\u043b\u0430\u0441\u0441\u0430 : " + this.returnClass(), e);
        }
    }

    public Class getEnumClass(IStiSerializable obj) {
        StiEnumSet set = (StiEnumSet)this.getReturnValue(obj);
        return ((Enum)set.collection().toArray()[0]).getDeclaringClass();
    }

    private StiDefaulValue getDefaulAnnotation() {
        return this.getGETMetod().getAnnotation(StiDefaulValue.class);
    }

    public boolean isDefaulValue(Object value) {
        if (this.isObject()) {
            return this.isDefaultObject(value);
        }
        boolean result = this.isDefaultPrimetive(value);
        return result;
    }

    private boolean isDefaultPrimetive(Object value) {
        boolean result = value == null ? this.isDefaulValue("null") : (value.getClass() == Character.TYPE || value.getClass() == Character.class ? this.isDefaulValue(String.valueOf(((Character)value).hashCode())) : this.isDefaulValue(value.toString()));
        return result;
    }

    private boolean isDefaultObject(Object value) {
        if (value == null) {
            return true;
        }
        boolean defInterface = IStiDefault.class.isAssignableFrom(value.getClass());
        return defInterface && ((IStiDefault)value).isDefault();
    }

    private boolean isDefaulValue(String value) {
        StiDefaulValue anoField = this.getDefaulAnnotation();
        boolean result = anoField == null && value.equals("null") ? true : anoField != null && anoField.value().equals(value);
        return result;
    }

    public String getShorNameOrDefault(String defaultName) {
        String shortName = this.getShortName();
        return StiValidationUtil.isNotEmpty((String)shortName) ? shortName : defaultName;
    }

    public String getShorNameOrName() {
        String shortName = this.getShortName();
        return StiValidationUtil.isNotEmpty((String)shortName) ? shortName : this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Class<?> getPrimitiveListClass() {
        return this.serializAnnotation.listClass();
    }

    public static Method createSetMetod(Class<?> clazz, Method getMetod) {
        try {
            String name = StiProperty.getPropertyName(getMetod);
            return clazz.getMethod("set" + name, getMetod.getReturnType());
        }
        catch (Exception e) {
            throw new RuntimeException("In class '" + clazz + "' no SET method for '" + getMetod + "'", e);
        }
    }

    private static String getPropertyName(Method getMetod) {
        String name = getMetod.getName();
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        return name.substring(3);
    }

    public String toString() {
        String name = "name=" + this.getName();
        String shortName = "shortName=" + this.getShortName();
        String className = this.returnClass != null ? "class=" + this.returnClass.getCanonicalName() : "no class";
        String annotation = "annotation=" + this.serializAnnotation;
        String result = "{0}, {1}, {2}, {3} ";
        return MessageFormat.format(result, name, shortName, className, annotation);
    }
}

