/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing.utils;

import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class StiClassConverter {
    private static final String ERROR_MSG = "Unable to obtain an analog of the class ''{0}''";
    public static final Properties MAPPINGS_NET_PROP = new Properties();
    private static final Properties MAPPINGS_SHORT_NET_PROP = new Properties();
    private static final Properties MAPPINGS_JAVA_PROP = new Properties();
    private static final Properties MAPPINGS_SHORT_JAVA_PROP = new Properties();
    private static ConcurrentHashMap<String, Class<?>> forName = new ConcurrentHashMap();

    private StiClassConverter() {
    }

    private static void fillProperties() {
        try {
            InputStream inStream1 = StiClassConverter.class.getResourceAsStream("/com/stimulsoft/mappings_net.properties");
            MAPPINGS_NET_PROP.load(inStream1);
            InputStream inStream2 = StiClassConverter.class.getResourceAsStream("/com/stimulsoft/mappings_short_net.properties");
            MAPPINGS_SHORT_NET_PROP.load(inStream2);
            for (Map.Entry<Object, Object> element : MAPPINGS_NET_PROP.entrySet()) {
                MAPPINGS_JAVA_PROP.put(element.getValue(), element.getKey());
            }
            for (Map.Entry<Object, Object> element : MAPPINGS_SHORT_NET_PROP.entrySet()) {
                MAPPINGS_SHORT_JAVA_PROP.put(element.getValue(), element.getKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    public static Class<? extends IStiSerializable> getJavaClass(String netClass) {
        block6: {
            Object value = MAPPINGS_SHORT_NET_PROP.getProperty(netClass);
            if (value != null) {
                return StiClassConverter.forName((String)value);
            }
            value = MAPPINGS_NET_PROP.get(netClass);
            if (value == null) break block6;
            return StiClassConverter.forName((String)value);
            {
                catch (Exception e) {
                    throw new RuntimeException(MessageFormat.format(ERROR_MSG, netClass), e);
                }
            }
        }
        try {
            return StiClassConverter.forName(netClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(MessageFormat.format(ERROR_MSG, netClass));
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (forName.containsKey(name)) {
            return forName.get(name);
        }
        Class<?> res = Class.forName(name);
        forName.put(name, res);
        return res;
    }

    public static String getNetClass(Class<?> javaClass) {
        Object value = MAPPINGS_SHORT_JAVA_PROP.get(javaClass.getCanonicalName());
        if (value != null) {
            return (String)value;
        }
        value = MAPPINGS_JAVA_PROP.get(javaClass.getCanonicalName());
        if (value != null) {
            return (String)value;
        }
        try {
            return javaClass.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(MessageFormat.format(ERROR_MSG, javaClass));
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Class.forName("com.stimulsoft.report.components.shapeTypes.StiTriangleShapeType");
        System.out.println(MAPPINGS_NET_PROP.keySet().size());
        System.out.println(MAPPINGS_SHORT_NET_PROP.keySet().size());
    }

    static {
        StiClassConverter.fillProperties();
    }
}

