/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing.utils;

import com.stimulsoft.base.serializing.annotations.StiIgnoreSerialization;
import com.stimulsoft.base.serializing.annotations.StiIgnoreSerializationForDocument;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToAttributes;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToXmlString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class StiSerializerUtil {
    private static Logger logger = Logger.getLogger("com.stimulsoft.base.serializing.utils.StiSerializerUtil");

    private StiSerializerUtil() {
    }

    public static boolean isSerializableToDocument(IStiSerializable object) {
        Class<?> classObject = object.getClass();
        return StiSerializerUtil.isSerializableToDocument(classObject);
    }

    public static boolean isSerializableToDocument(Class<? extends IStiSerializable> classObject) {
        boolean serializableToDocument = IStiSerializableToAttributes.class.isAssignableFrom(classObject);
        boolean notSerializable = classObject.getAnnotation(StiIgnoreSerializationForDocument.class) != null;
        return serializableToDocument && !notSerializable;
    }

    public static boolean isSerializableToXmlString(Class<? extends IStiSerializable> classObject) {
        boolean serializableToXmlString = IStiSerializableToXmlString.class.isAssignableFrom(classObject);
        return serializableToXmlString;
    }

    public static boolean isIgnoreType(Class<? extends IStiSerializable> collectionType) {
        StiIgnoreSerialization annotation = collectionType.getAnnotation(StiIgnoreSerialization.class);
        return annotation != null;
    }

    public static String attributeValue(Node currentItem, String attributename) {
        Node node = currentItem.getAttributes().getNamedItem(attributename);
        if (node == null) {
            logger.warning("Attribute  '" + attributename + "' not present in " + currentItem);
        }
        if (StiValidationUtil.isBlank((String)node.getNodeValue())) {
            logger.warning("Attribute value '" + attributename + "' is empty in " + currentItem);
        }
        return node.getNodeValue();
    }

    public static String serializFormat(String pattern, Object ... arguments) {
        Object[] argumentsStr = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            String argumentStr = StiValidationUtil.isNumber((Object)argument) ? StiSerializTypeConverter.doubleToString(argument) : (argument instanceof Boolean ? StiSerializTypeConverter.booleanToString(argument) : argument.toString());
            argumentsStr[i] = argumentStr;
        }
        return MessageFormat.format(pattern, argumentsStr);
    }

    public static void main(String[] args) {
        boolean qq = false;
        Boolean q = qq;
        if (q instanceof Boolean) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }
}

